/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.AugRateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class LimitManager {
    private final String augId;
    private final List<AugRateLimiter> limiters = new ArrayList<AugRateLimiter>();

    public LimitManager(List<AugRateLimiter> limiters, String augId) {
        if (limiters != null) {
            this.limiters.addAll(limiters);
        }
        this.augId = augId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void TryWithLimits(final long startTime, Runnable augCore) throws Exception {
        boolean canExecute = true;
        ArrayList<1> aftersToCall = new ArrayList<1>();
        try {
            for (final AugRateLimiter augRateLimiter : this.limiters) {
                if (augRateLimiter.BeforeRun(startTime, this.augId)) {
                    aftersToCall.add(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            augRateLimiter.AfterRun(startTime);
                            return null;
                        }
                    });
                    continue;
                }
                canExecute = false;
            }
            if (canExecute) {
                augCore.run();
            }
        }
        finally {
            for (Callable callable : aftersToCall) {
                callable.call();
            }
        }
    }
}

