/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.DynatraceContext;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.newRelicContext;
import com.rookout.rook.Processor.Namespaces.servletContext;
import com.rookout.rook.RookLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.UUID;

public class OpentraceNamespace
extends Namespace {
    private HashMap<String, Object> locals;

    public OpentraceNamespace(HashMap<String, Object> locals) {
        this.locals = locals;
    }

    private ContainerNamespace GetDump(String args) throws Exceptions.ToolException {
        ContainerNamespace containerNamespace = new ContainerNamespace();
        JavaObjectNamespace.ObjectDumpConfig dumpConfig = JavaObjectNamespace.ObjectDumpConfig.GetDefaultDumpConfig();
        if (args.length() > 0 && (dumpConfig = JavaObjectNamespace.ObjectDumpConfig.GetObjectDumpConfig(args.toLowerCase())) == null) {
            throw new Exceptions.RookInvalidMethodArguments("dump()", args);
        }
        Namespace attribute = this.ReadAttribute("");
        if (attribute instanceof JavaObjectNamespace) {
            ((JavaObjectNamespace)attribute).objectDumpConfig = dumpConfig;
        }
        containerNamespace.WriteAttribute("span", attribute);
        return containerNamespace;
    }

    private ClassLoader getCallerClassLoader() {
        for (String str : this.locals.keySet()) {
            if (!str.equals("this")) continue;
            return this.locals.get(str).getClass().getClassLoader();
        }
        return null;
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        ClassLoader cl = this.getCallerClassLoader();
        if (cl == null) {
            return new JavaObjectNamespace(null);
        }
        Namespace result = this.ReadNewRelicTracing(cl);
        if (result == null && (result = this.ReadDynatrace(cl)) == null && (result = this.ReadGlobalTracer(cl)) == null && (result = this.ReadServlet(cl)) == null) {
            return new JavaObjectNamespace(null);
        }
        if (name.equals("")) {
            return result;
        }
        return result.ReadAttribute(name);
    }

    private Namespace ReadGlobalTracer(ClassLoader cl) {
        try {
            Object span;
            Method activeSpan;
            Object globalTracer;
            Method staticGetGlobalTracer;
            Class<?> globalTracerStaticClass;
            if (cl != null && (globalTracerStaticClass = cl.loadClass("io.opentracing.util.GlobalTracer")) != null && (staticGetGlobalTracer = globalTracerStaticClass.getMethod("get", new Class[0])) != null && (globalTracer = staticGetGlobalTracer.invoke(null, new Object[0])) != null && (activeSpan = globalTracer.getClass().getMethod("activeSpan", new Class[0])) != null && (span = activeSpan.invoke(globalTracer, new Object[0])) != null && !span.getClass().getName().contains("NoopSpan")) {
                return new JavaObjectNamespace(span);
            }
        }
        catch (Throwable t) {
            RookLogger.Instance().debug("OpenTracing Span Not Found : " + t.getMessage(), new Object[0]);
        }
        RookLogger.Instance().debug("OpenTracing Span Not Found", new Object[0]);
        return null;
    }

    private Namespace ReadServlet(ClassLoader cl) {
        try {
            Object request;
            Method getRequest;
            Object requestAttributes;
            Method getRequestAttributes;
            Class<?> requestContextHolder;
            if (cl != null && (requestContextHolder = cl.loadClass("org.springframework.web.context.request.RequestContextHolder")) != null && (getRequestAttributes = requestContextHolder.getMethod("getRequestAttributes", new Class[0])) != null && (requestAttributes = getRequestAttributes.invoke(null, new Object[0])) != null && (getRequest = requestAttributes.getClass().getMethod("getRequest", new Class[0])) != null && (request = getRequest.invoke(requestAttributes, new Object[0])) != null) {
                String spanId;
                Method getMethod = request.getClass().getMethod("getMethod", new Class[0]);
                Method getRequestURI = request.getClass().getMethod("getRequestURI", new Class[0]);
                Method getHeaderNames = request.getClass().getMethod("getHeaderNames", new Class[0]);
                Method getAttributeNames = request.getClass().getMethod("getAttributeNames", new Class[0]);
                Method getRequestURL = request.getClass().getMethod("getRequestURL", new Class[0]);
                Class[] cArg = new Class[]{String.class};
                Method getHeader = request.getClass().getMethod("getHeader", cArg);
                Method getAttribute = request.getClass().getMethod("getAttribute", cArg);
                Class[] cArg2 = new Class[]{String.class, Object.class};
                Method setAttribute = request.getClass().getMethod("setAttribute", cArg2);
                HashMap<String, Object> headers = new HashMap<String, Object>();
                if (getHeaderNames != null) {
                    Enumeration headerNames = (Enumeration)getHeaderNames.invoke(request, new Object[0]);
                    while (headerNames.hasMoreElements()) {
                        String key = (String)headerNames.nextElement();
                        headers.put(key, getHeader.invoke(request, key));
                    }
                }
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                if (getAttributeNames != null) {
                    Enumeration attributeNames = (Enumeration)getAttributeNames.invoke(request, new Object[0]);
                    while (attributeNames.hasMoreElements()) {
                        String key = (String)attributeNames.nextElement();
                        attributes.put(key, getAttribute.invoke(request, key));
                    }
                }
                if (!attributes.containsKey("spanId")) {
                    spanId = UUID.randomUUID().toString();
                    setAttribute.invoke(request, "spanId", spanId);
                    attributes.put("spanId", spanId);
                } else {
                    spanId = attributes.get("spanId").toString();
                }
                String method = "";
                String requestURI = "";
                String requestURL = "";
                if (getMethod != null) {
                    method = (String)getMethod.invoke(request, new Object[0]);
                }
                if (getRequestURI != null) {
                    requestURI = (String)getRequestURI.invoke(request, new Object[0]);
                }
                if (getRequestURL != null) {
                    Object rawURL = getRequestURL.invoke(request, new Object[0]);
                    requestURL = rawURL instanceof StringBuffer ? ((StringBuffer)rawURL).toString() : (String)rawURL;
                }
                return new JavaObjectNamespace(new servletContext(method, requestURI, requestURL, headers, attributes, spanId));
            }
        }
        catch (Throwable t) {
            RookLogger.Instance().debug("ServletContext Not Found : " + t.getMessage(), new Object[0]);
        }
        RookLogger.Instance().debug("ServletContext Not Found", new Object[0]);
        return null;
    }

    private Namespace ReadNewRelicTracing(ClassLoader cl) {
        try {
            Class<?> traceMetadataImplClass = cl.loadClass("com.newrelic.agent.TraceMetadataImpl");
            if (traceMetadataImplClass == null) {
                return null;
            }
            Field traceMetadataInstanceField = traceMetadataImplClass.getField("INSTANCE");
            if (traceMetadataInstanceField == null) {
                return null;
            }
            Object traceMetadataInstanceSingleton = traceMetadataInstanceField.get(null);
            if (traceMetadataInstanceSingleton == null) {
                return null;
            }
            Method getSpanIdMethod = traceMetadataImplClass.getMethod("getSpanId", new Class[0]);
            if (getSpanIdMethod == null) {
                return null;
            }
            Object spanIdAsObj = getSpanIdMethod.invoke(traceMetadataInstanceSingleton, new Object[0]);
            if (spanIdAsObj == null) {
                return null;
            }
            String spanId = spanIdAsObj.toString();
            return new JavaObjectNamespace(new newRelicContext(spanId));
        }
        catch (Throwable t) {
            RookLogger.Instance().debug("NewRelic Tracing Span Not Found : " + t.getMessage(), new Object[0]);
            RookLogger.Instance().debug("NewRelic Tracing Span Not Found", new Object[0]);
            return null;
        }
    }

    private Namespace ReadDynatrace(ClassLoader cl) {
        try {
            Class<?> traceTagStorage = cl.loadClass("com.dynatrace.agent.TraceTagStorage");
            if (traceTagStorage == null) {
                return null;
            }
            Method getTraceTag = traceTagStorage.getMethod("getTraceTag", new Class[0]);
            Object traceTag = getTraceTag.invoke(null, new Object[0]);
            if (traceTag == null) {
                return null;
            }
            Field subPathField = traceTag.getClass().getDeclaredField("subPath");
            Object subPath = subPathField.get(traceTag);
            if (subPath == null) {
                return null;
            }
            Method getSubPathRef = subPath.getClass().getMethod("getSubPathRef", new Class[0]);
            Object subPathRef = getSubPathRef.invoke(subPath, new Object[0]);
            if (subPathRef == null) {
                return null;
            }
            Method getTraceIdAndSpanId = subPathRef.getClass().getMethod("getTraceIdAndSpanId", new Class[0]);
            Object traceIdAndSpanId = getTraceIdAndSpanId.invoke(subPathRef, new Object[0]);
            if (traceIdAndSpanId == null) {
                return null;
            }
            Method getTraceIdAsHexString = traceIdAndSpanId.getClass().getMethod("getTraceIdAsHexString", new Class[0]);
            Method getSpanIdAsHexString = traceIdAndSpanId.getClass().getMethod("getSpanIdAsHexString", new Class[0]);
            Object traceIdAsHexString = getTraceIdAsHexString.invoke(traceIdAndSpanId, new Object[0]);
            Object spanIdAsHexString = getSpanIdAsHexString.invoke(traceIdAndSpanId, new Object[0]);
            if (traceIdAsHexString == null || spanIdAsHexString == null) {
                return null;
            }
            DynatraceContext ctx = new DynatraceContext((String)traceIdAsHexString, (String)spanIdAsHexString);
            return new JavaObjectNamespace(ctx);
        }
        catch (Throwable t) {
            RookLogger.Instance().debug("Dynatrace Tracing Span Not Found : " + t.getMessage(), new Object[0]);
            return null;
        }
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "dump": {
                return this.GetDump(args);
            }
        }
        return new JavaObjectNamespace(null);
    }
}

