/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Processor.RookError;
import com.rookout.rook.WarningReporter;
import java.util.HashSet;
import java.util.Set;

public class ClassTransformUserWarnings {
    private static String classReloadName = "";
    private static Set<WarningReporter> classReloadReporters = new HashSet<WarningReporter>();
    private static Set<WarningReporter> classTransformReporters = new HashSet<WarningReporter>();

    public static synchronized void newClassReload(String newClassName, WarningReporter reporter) {
        classReloadName = newClassName;
        classReloadReporters.clear();
        classReloadReporters.add(reporter);
    }

    public static synchronized void finishClassReload() {
        classReloadReporters.clear();
        classReloadName = "";
    }

    public static synchronized void newClassTransform() {
        classTransformReporters.clear();
    }

    public static synchronized void finishClassTransform() {
        classTransformReporters.clear();
    }

    public static synchronized void addReporter(String className, WarningReporter reporter) {
        classTransformReporters.add(reporter);
        if (className.equals(classReloadName)) {
            classReloadReporters.add(reporter);
        }
    }

    public static synchronized void SendReloadWarning(RookError error) {
        for (WarningReporter reporter : classReloadReporters) {
            reporter.SendWarning(error);
        }
    }

    public static synchronized void SendReloadError(RookError error) {
        for (WarningReporter reporter : classReloadReporters) {
            reporter.SendError(error);
        }
    }

    public static synchronized void SendTransformWarning(RookError error) {
        for (WarningReporter reporter : classTransformReporters) {
            reporter.SendWarning(error);
        }
    }

    public static synchronized void SendTransformError(RookError error) {
        for (WarningReporter reporter : classTransformReporters) {
            reporter.SendError(error);
        }
    }
}

