/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Operations.Operation;
import com.rookout.rook.Processor.Operations.PrintUrl;
import com.rookout.rook.Processor.Operations.Set;
import com.rookout.rook.Processor.Paths.ArithmeticPath;
import com.rookout.rook.Processor.Paths.Path;
import com.rookout.rook.Processor.Processor;
import rook.org.json.JSONArray;
import rook.org.json.JSONObject;

public class ProcessorFactory {
    public Operation getOperation(JSONObject configuration) throws Exceptions.ToolException {
        if (!(configuration.get("name") instanceof String)) {
            throw new Exceptions.RookInvalidObjectConfiguration(null, configuration.toString(), null);
        }
        String operationName = (String)configuration.get("name");
        if (operationName.equals("set")) {
            return new Set(configuration, this);
        }
        if (operationName.equals("print_url")) {
            String format = (String)configuration.get("format");
            return new PrintUrl(format);
        }
        throw new Exceptions.RookInvalidObjectConfiguration(null, configuration.toString(), null);
    }

    public Path getPath(Object configuration) throws Exceptions.ToolException {
        if (configuration instanceof String) {
            return new ArithmeticPath((String)configuration);
        }
        if (configuration instanceof JSONObject) {
            return new ArithmeticPath((JSONObject)configuration);
        }
        throw new Exceptions.RookInvalidObjectConfiguration(null, configuration.toString(), null);
    }

    public Processor getProcessor(JSONArray configuration) throws Exceptions.ToolException {
        return new Processor(configuration, this);
    }
}

