/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.Actions.Action;
import com.rookout.rook.Augs.AugNamespace;
import com.rookout.rook.Augs.Conditions.Condition;
import com.rookout.rook.Augs.LimitManager;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.UserWarnings;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class Aug {
    public static AtomicInteger executeCounter = new AtomicInteger(0);
    public String augId;
    private String agentId;
    private Action action;
    private LimitManager limitManager;
    private long maxAugTime;
    private Condition condition;
    private boolean enabled = true;
    private boolean executed = false;

    public Aug(String augId, String agentId, Action action, Condition condition, long maxAugTime, LimitManager limitManager) {
        this.augId = augId;
        this.agentId = agentId;
        this.action = action;
        this.maxAugTime = maxAugTime;
        this.limitManager = limitManager;
        this.condition = condition;
    }

    public void Execute(final HashMap<String, Object> locals, final Namespace extracted, final long now, final OutputWs output) throws Exception {
        if (!this.enabled) {
            return;
        }
        if (!output.validateCanSendMessage(this.augId)) {
            return;
        }
        boolean shouldSkipLimiters = !this.executed && this.condition == null;
        this.limitManager.TryWithLimits(now, shouldSkipLimiters, new Runnable(){

            @Override
            public void run() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            AugNamespace augNamespace = new AugNamespace(locals, extracted);
                            if (Aug.this.condition == null || Aug.this.condition.evaluate(augNamespace.getAugNamespace())) {
                                if (Aug.this.executed) {
                                    RookLogger.Instance().debug("Executing aug - " + Aug.this.augId, new Object[0]);
                                } else {
                                    RookLogger.Instance().info("Executing aug for the first time - " + Aug.this.augId, new Object[0]);
                                    Aug.this.executed = true;
                                }
                                String reportId = Aug.this.generateNonBlockingUUID();
                                Aug.this.action.Execute(Aug.this.augId, reportId, augNamespace.getAugNamespace(), output);
                            }
                            long augTime = System.nanoTime() - now;
                            if (Aug.this.maxAugTime > 0L && augTime > Aug.this.maxAugTime) {
                                RookLogger.Instance().log(Level.WARNING, "Removing rule because max execution time was reached - " + Aug.this.augId);
                                Aug.this.enabled = false;
                                UserWarnings.SendError(new RookError(new Exceptions.RookRuleMaxExecutionTimeReached(augTime / 1000000L, Aug.this.maxAugTime / 1000000L)));
                            }
                        }
                        catch (Throwable e) {
                            UserWarnings.SendWarning(new RookError(e, "Exception while processing Aug: " + e.toString()));
                        }
                        return null;
                    }
                });
            }
        });
    }

    private String generateNonBlockingUUID() {
        int unique = executeCounter.getAndIncrement();
        String reportMsg = this.agentId + unique;
        return UUID.nameUUIDFromBytes(reportMsg.getBytes()).toString().replace("-", "");
    }
}

