/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.ClassTransformUserWarnings;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.JavaAgent;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.ActiveLocations;
import com.rookout.rook.Services.Instrumentation.AugVisitor;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.BaseVisitor;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.ClassReloader;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.IClassReloader;
import com.rookout.rook.Services.Instrumentation.JUnitVisitor;
import com.rookout.rook.Services.Instrumentation.LoggingVisitor;
import com.rookout.rook.Services.Instrumentation.NoopClassReloader;
import com.rookout.rook.Services.Instrumentation.TestsVisitor;
import com.rookout.rook.Services.Logging.LoggingService;
import com.rookout.rook.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import rook.com.google.common.collect.HashBiMap;
import rook.org.objectweb.asm.ClassReader;
import rook.org.objectweb.asm.ClassWriter;

public class InstrumentationService
implements ClassFileTransformer {
    private final String[] excludedContains = new ArrayList<String>(){
        {
            this.add("$Lambda$");
        }
    }.toArray(new String[0]);
    private final Set<String> excludedClassLoaderNames = new HashSet<String>(Arrays.asList("jdk.nashorn.internal.runtime.ScriptLoader"));
    private Augs augs = new Augs();
    private Files files = new Files();
    private ActiveLocations activeLocations = new ActiveLocations();
    public ArrayList<String> log4jClassNames = new ArrayList();
    public boolean silencedRetransformFailure = false;
    public static InstrumentationService instance;
    private static Instrumentation inst;
    private IClassReloader classReloader = null;
    private static boolean shouldReloadAllClassesOnStart;
    private static boolean disableClassTransform;

    public static void SetInstrumentation(Instrumentation instrumentation, boolean shouldReloadAllClassesOnStartArg, boolean disableClassTransformArg) {
        inst = instrumentation;
        shouldReloadAllClassesOnStart = shouldReloadAllClassesOnStartArg;
        disableClassTransform = disableClassTransformArg;
    }

    public static InstrumentationService Build() {
        if (null == inst) {
            RookLogger.Instance().log(Level.WARNING, "Java agent was not initialized, instrumentation not available");
            return null;
        }
        if (null != instance) {
            throw new RuntimeException("Cannot create multiple instances!");
        }
        instance = new InstrumentationService();
        return instance;
    }

    public void ResetClassReloader() {
        if (null != this.classReloader) {
            this.classReloader.Stop();
            this.classReloader = null;
        }
        this.classReloader = new ClassReloader(inst, this.augs, this.files, this.activeLocations);
    }

    public void Close() {
        if (disableClassTransform) {
            return;
        }
        this.classReloader.Stop();
        this.ClearAugs();
        inst.removeTransformer(this);
        CallbackDispatcher.Close();
        instance = null;
    }

    public void AddAug(LocationFileLine location) throws Exception {
        this.classReloader.AddAug(location);
    }

    public void RemoveAug(String augId) {
        this.classReloader.RemoveAug(augId);
    }

    public void ClearAugs() {
        Set<String> augIds = this.augs.AllAugIds();
        for (String augId : augIds) {
            try {
                this.RemoveAug(augId);
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Error while removing aug", e, new Object[0]);
            }
        }
    }

    public int GetNumberOfAugs() {
        return this.augs.AllAugIds().size();
    }

    private InstrumentationService() {
        if (disableClassTransform) {
            this.classReloader = new NoopClassReloader();
            return;
        }
        CallbackDispatcher.CreateCallbackDispatcher(this.augs);
        this.LoadDeps();
        InstrumentationService.addStaticCallbackToBootstrapLoader();
        inst.addTransformer(this, true);
        if (shouldReloadAllClassesOnStart) {
            this.ReloadAllClasses();
        }
        this.ResetClassReloader();
    }

    public static void addStaticCallbackToBootstrapLoader() {
        try {
            File tempFile = File.createTempFile("rookagent", "");
            tempFile.deleteOnExit();
            String javaAgentPath = JavaAgent.class.getProtectionDomain().getCodeSource().getLocation().getFile().replace("%20", " ");
            try (JarFile thisJar = new JarFile(javaAgentPath);
                 FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
                 ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
                String[] filesToCopy;
                for (String fileToCopy : filesToCopy = new String[]{"com/rookout/agent/StaticCallback.class"}) {
                    int length;
                    InputStream input = thisJar.getInputStream(thisJar.getEntry(fileToCopy));
                    zipOutputStream.putNextEntry(new ZipEntry(fileToCopy));
                    byte[] bytes = new byte[1024];
                    while ((length = input.read(bytes)) >= 0) {
                        zipOutputStream.write(bytes, 0, length);
                    }
                }
            }
            var3_4 = null;
            try (JarFile jarToAppend = new JarFile(tempFile.getPath());){
                inst.appendToBootstrapClassLoaderSearch(jarToAppend);
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            RookLogger.Instance().warn("Failed to add static callback to bootstrap loader: %s", e.getMessage());
        }
    }

    private void LoadDeps() {
        HashBiMap<Integer, Integer> map = HashBiMap.create();
        map.get(1);
        map.put(1, 1);
        map.get(1);
    }

    private void finalizeNamespaceArray(ArrayList<String> arr) {
        ArrayList<String> copy = new ArrayList<String>(arr);
        for (String c : copy) {
            arr.add(c.replace('.', '/'));
        }
    }

    private static boolean IsKotlinClass(Class cls) {
        for (Annotation annotations : cls.getAnnotations()) {
            if (!annotations.annotationType().getName().toLowerCase().contains("kotlin")) continue;
            return true;
        }
        return false;
    }

    private static void AddClassToList(Class cls, String className, Files files) {
        if (cls.getClassLoader() == null) {
            return;
        }
        int fileNameIndex = className.lastIndexOf(46);
        if (fileNameIndex == -1) {
            fileNameIndex = className.lastIndexOf(47);
        }
        if (fileNameIndex != -1) {
            String fileName = className.substring(fileNameIndex + 1);
            fileName = Utils.GetClassNamePath(fileName);
            if (InstrumentationService.IsKotlinClass(cls)) {
                String kotlinFileName = fileName + ".kt";
                files.AddClass(cls.getClassLoader(), kotlinFileName, className);
                if (kotlinFileName.endsWith("Kt.kt")) {
                    files.AddClass(cls.getClassLoader(), kotlinFileName.replace("Kt.kt", ".kt"), className);
                }
                return;
            }
            files.AddClass(cls.getClassLoader(), fileName + ".java", className);
        }
    }

    private boolean IsClassExcluded(String className) {
        for (int i = 0; i < this.excludedContains.length; ++i) {
            if (!className.contains(this.excludedContains[i])) continue;
            return true;
        }
        return false;
    }

    private boolean IsClassLoaderExcluded(ClassLoader classLoader) {
        if (null == classLoader) {
            return true;
        }
        return this.excludedClassLoaderNames.contains(classLoader.getClass().getName());
    }

    private void ReloadAllClasses() {
        Class[] classes = inst.getAllLoadedClasses();
        int classesLength = classes.length;
        RookLogger.Instance().debug("Parsing " + classesLength + " classes", new Object[0]);
        for (int i = 0; i < classesLength; ++i) {
            String className = "";
            Class cls = classes[i];
            className = cls.getName();
            if (className == null || this.IsClassExcluded(className) || !inst.isModifiableClass(cls) || cls.getProtectionDomain() == null) continue;
            InstrumentationService.AddClassToList(cls, className.replace(".", "/"), this.files);
        }
        RookLogger.Instance().debug("Done reloading classes", new Object[0]);
    }

    public void ReloadClass(Class cls) {
        try {
            inst.retransformClasses(cls);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        byte[] byArray;
        String message;
        try {
            if (null == className || null == protectionDomain || this.IsClassExcluded(className) || this.IsClassLoaderExcluded(classLoader)) {
                byte[] byArray2 = null;
                return byArray2;
            }
            ClassTransformUserWarnings.newClassTransform();
            URL location = null;
            if (protectionDomain.getCodeSource() != null) {
                location = protectionDomain.getCodeSource().getLocation();
            }
            if (Config.Instance().InstrumentationConfig$CLASS_LOAD_VERBOSE) {
                RookLogger.Instance().debug("Starting class retransform: " + className, new Object[0]);
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(reader, 0);
            BaseVisitor visitor = new AugVisitor(this.files, this.augs, this.activeLocations, classLoader, className, location, writer);
            if (JUnitVisitor.ShouldHook(className)) {
                visitor.DisableSkip();
                visitor = new JUnitVisitor(className, classLoader, writer);
            }
            if (TestsVisitor.ShouldHook(className)) {
                visitor.DisableSkip();
                visitor = new TestsVisitor(className, classLoader, writer);
            } else if (LoggingService.ShouldHook(className).booleanValue()) {
                visitor.DisableSkip();
                visitor = new LoggingVisitor(className, classLoader, visitor);
            }
            try {
                reader.accept(visitor, 0);
            }
            catch (BaseVisitor.IgnoreClassException e) {
                byte[] byArray3 = null;
                ClassTransformUserWarnings.finishClassTransform();
                return byArray3;
            }
            if (!((BaseVisitor)visitor).isHooked()) {
                byte[] byArray4 = null;
                return byArray4;
            }
            byte[] byArray5 = writer.toByteArray();
            return byArray5;
        }
        catch (BaseVisitor.ClassLoadingVerificationException e) {
            message = "Failed to transform class: " + className + "  - " + e.toString();
            try {
                ClassTransformUserWarnings.SendTransformError(new RookError(new Exceptions.RookMissingStaticCallback((Throwable)((Object)e)), message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            byArray = null;
            return byArray;
        }
        catch (Throwable e) {
            this.silencedRetransformFailure = true;
            message = "Failed to transform class: " + className + "  - " + e.toString();
            RookLogger.Instance().log(Level.WARNING, message, e, new Object[0]);
            try {
                ClassTransformUserWarnings.SendTransformError(new RookError(new Exceptions.RookFailedToVerifyCode(message + " ; " + e.getMessage()), message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            byArray = null;
            return byArray;
        }
        finally {
            ClassTransformUserWarnings.finishClassTransform();
        }
    }

    static {
        shouldReloadAllClassesOnStart = false;
        disableClassTransform = false;
    }
}

