/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.Exceptions;
import java.util.Date;

public class TokenBucket {
    private long lastReset;
    private final int initialValue;
    private int remaining;
    private final int intervalInSeconds;
    private final Callable doOnceWhenExhausted;
    private boolean doOnceWhenExhaustedPerformed;
    private final String bucketName;

    public TokenBucket(int limit, int intervalInSeconds, Callable doOnceWhenExhausted, String bucketName) {
        this.remaining = limit;
        this.initialValue = limit;
        this.intervalInSeconds = intervalInSeconds;
        this.doOnceWhenExhausted = doOnceWhenExhausted;
        this.doOnceWhenExhaustedPerformed = false;
        this.lastReset = new Date().getTime();
        this.bucketName = bucketName;
    }

    public String toString() {
        return String.format("%s bucket limit - %d invocations per %d seconds", this.bucketName, this.initialValue, this.intervalInSeconds);
    }

    synchronized boolean isExhausted() {
        if (new Date().getTime() - this.lastReset >= (long)(this.intervalInSeconds * 1000)) {
            this.lastReset = new Date().getTime();
            this.remaining = this.initialValue;
            this.doOnceWhenExhaustedPerformed = false;
        }
        return this.remaining <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIfAvailable(Callable func) throws Exceptions.RookTokenBucketExhausted {
        TokenBucket tokenBucket = this;
        synchronized (tokenBucket) {
            if (this.isExhausted()) {
                if (this.doOnceWhenExhausted != null && !this.doOnceWhenExhaustedPerformed) {
                    this.doOnceWhenExhaustedPerformed = true;
                    this.doOnceWhenExhausted.call();
                }
                throw new Exceptions.RookTokenBucketExhausted(this);
            }
            --this.remaining;
        }
        func.call();
    }

    public static interface Callable {
        public void call();
    }
}

