/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.agent;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Assertions {
    private static Class pAssertClass;
    private static Method pAssertExecute;
    private static Field pInstance;

    public static String ExtractTestName(StackTraceElement[] stackTraceElements) {
        for (int i = 0; i < stackTraceElements.length - 1; ++i) {
            if (!Assertions.IsRookoutFrame(stackTraceElements[i]) || Assertions.IsRookoutFrame(stackTraceElements[i + 1])) continue;
            return stackTraceElements[i + 1].getMethodName();
        }
        return "";
    }

    private static boolean IsRookoutFrame(StackTraceElement stackTraceElements) {
        return stackTraceElements.getClassName().contains("rookout") && stackTraceElements.getFileName().equals("Assertions.java");
    }

    public static void HandleFailure(HashMap<String, Object> locals, Object expected, Object actual, String test_name) throws Throwable {
        try {
            Object instance_value = pInstance.get(null);
            pAssertExecute.invoke(instance_value, locals, expected, actual, test_name);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, String message, Object expected, Object actual) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, message, expected, actual);
            } else {
                methodToInvoke.invoke(null, expected, actual);
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, actual, expected, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, String message, Object expected, Object actual, double delta) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, message, expected, actual, delta);
            } else {
                methodToInvoke.invoke(null, expected, actual, delta);
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, actual, expected, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, String message, Object expected, Object actual, float delta) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, message, expected, actual, Float.valueOf(delta));
            } else {
                methodToInvoke.invoke(null, expected, actual, Float.valueOf(delta));
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, actual, expected, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, String message, boolean condition) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            methodToInvoke.invoke(null, message, condition);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, condition, true, testName);
            throw e.getTargetException();
        }
    }

    public static void assertTrue(String message, boolean condition, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertTrue", String.class, Boolean.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, condition);
    }

    public static void assertTrue(boolean condition, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertTrue("", condition, locals);
    }

    public static void assertFalse(String message, boolean condition, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertTrue(message, !condition, locals);
    }

    public static void assertEquals(String message, Object expected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, expected, actual);
    }

    public static void assertNotEquals(String message, Object unexpected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, unexpected, actual);
    }

    public static void assertNotEquals(String message, long unexpected, long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)unexpected, (Object)actual);
    }

    public static void assertNotEquals(String message, double unexpected, double actual, double delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", String.class, Double.TYPE, Double.TYPE, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)unexpected, (Object)actual, delta);
    }

    public static void assertArrayEquals(String message, Object[] expecteds, Object[] actuals, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("internalArrayEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, actuals);
    }

    public static void assertArrayEquals(Object[] expecteds, Object[] actuals, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals(null, expecteds, actuals, locals);
    }

    public static void assertArrayEquals(String message, boolean[] expecteds, boolean[] actuals, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("internalArrayEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, actuals);
    }

    public static void assertArrayEquals(boolean[] expecteds, boolean[] actuals, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals(null, expecteds, actuals, locals);
    }

    public static void assertArrayEquals(String message, byte[] expecteds, byte[] actuals, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("internalArrayEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, actuals);
    }

    public static void assertArrayEquals(byte[] expecteds, byte[] actuals, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals(null, expecteds, actuals, locals);
    }

    public static void assertArrayEquals(String message, char[] expecteds, char[] actuals, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("internalArrayEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, actuals);
    }

    public static void assertArrayEquals(char[] expecteds, char[] actuals, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals("", expecteds, actuals, locals);
    }

    public static void assertArrayEquals(String message, short[] expecteds, short[] actuals, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("internalArrayEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, actuals);
    }

    public static void assertArrayEquals(short[] expecteds, short[] actuals, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals("", expecteds, actuals, locals);
    }

    public static void assertArrayEquals(String message, int[] expecteds, int[] actuals, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("internalArrayEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, actuals);
    }

    public static void assertArrayEquals(int[] expecteds, int[] actuals, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals("", expecteds, actuals, locals);
    }

    public static void assertArrayEquals(String message, long[] expecteds, long[] actuals, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("internalArrayEquals", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, actuals);
    }

    public static void assertArrayEquals(long[] expecteds, long[] actuals, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals("", expecteds, actuals, locals);
    }

    public static void assertArrayEquals(String message, double[] expecteds, double[] actuals, double delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", String.class, double[].class, double[].class, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, (Object)actuals, delta);
    }

    public static void assertArrayEquals(double[] expecteds, double[] actuals, double delta, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals("", expecteds, actuals, delta, locals);
    }

    public static void assertArrayEquals(String message, float[] expecteds, float[] actuals, float delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", String.class, float[].class, float[].class, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expecteds, (Object)actuals, delta);
    }

    public static void assertArrayEquals(float[] expecteds, float[] actuals, float delta, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertArrayEquals("", expecteds, actuals, delta, locals);
    }

    public static void assertEquals(String message, double expected, double actual, double delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", String.class, Double.TYPE, Double.TYPE, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expected, (Object)actual, delta);
    }

    public static void assertEquals(String message, float expected, float actual, float delta, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertEquals(message, (double)expected, (double)actual, (double)delta, locals);
    }

    public static void assertNotEquals(String message, float unexpected, float actual, float delta, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertNotEquals(message, (double)unexpected, (double)actual, (double)delta, locals);
    }

    public static void assertEquals(String message, long expected, long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", String.class, Long.TYPE, Long.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, (Object)expected, (Object)actual);
    }

    public static void assertNotNull(String message, Object object, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertTrue(message, object != null, locals);
    }

    public static void assertNull(String message, Object object, HashMap<String, Object> locals) throws Throwable {
        Assertions.assertTrue(message, object == null, locals);
    }

    public static void assertSame(String message, Object expected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertSame", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, expected, actual);
    }

    public static void assertNotSame(String message, Object unexpected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotSame", String.class, Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, message, unexpected, actual);
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object actual) throws Throwable {
        try {
            methodToInvoke.invoke(null, actual);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, null, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object actual, String message) throws Throwable {
        try {
            methodToInvoke.invoke(null, actual, message);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, null, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object actual, Supplier message) throws Throwable {
        try {
            methodToInvoke.invoke(null, actual, message);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, null, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object expected, Object actual, Supplier message) throws Throwable {
        try {
            methodToInvoke.invoke(null, expected, actual, message);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, expected, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object expected, Object actual, String message) throws Throwable {
        try {
            methodToInvoke.invoke(null, expected, actual, message);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, expected, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object expected, Object actual) throws Throwable {
        try {
            methodToInvoke.invoke(null, expected, actual);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, expected, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object expected, Object actual, double delta, Supplier message) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, expected, actual, delta, message);
            } else {
                methodToInvoke.invoke(null, expected, actual, delta);
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, expected, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object expected, Object actual, double delta, String message) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, expected, actual, delta, message);
            } else {
                methodToInvoke.invoke(null, expected, actual, delta);
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, expected, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object expected, Object actual, double delta) throws Throwable {
        Assertions.GenericAssertCallback(methodToInvoke, locals, expected, actual, delta, (String)null);
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object expected, Object actual, float delta, Supplier message) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, expected, actual, Float.valueOf(delta), message);
            } else {
                methodToInvoke.invoke(null, expected, actual, Float.valueOf(delta));
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, expected, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, Object expected, Object actual, float delta, String message) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, expected, actual, Float.valueOf(delta), message);
            } else {
                methodToInvoke.invoke(null, expected, actual, Float.valueOf(delta));
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, expected, actual, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, boolean condition, Supplier message) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, condition, message);
            } else {
                methodToInvoke.invoke(null, condition);
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, condition, true, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, boolean condition, String message) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, condition, message);
            } else {
                methodToInvoke.invoke(null, condition);
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, condition, true, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, boolean condition) throws Throwable {
        Assertions.GenericAssertCallback(methodToInvoke, locals, condition, (String)null);
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, BooleanSupplier condition, Supplier message) throws Throwable {
        try {
            methodToInvoke.setAccessible(true);
            if (message != null) {
                methodToInvoke.invoke(null, condition, message);
            } else {
                methodToInvoke.invoke(null, condition);
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            StackTraceElement[] stackTraceElements = targetException.getStackTrace();
            String testName = Assertions.ExtractTestName(stackTraceElements);
            Assertions.HandleFailure(locals, condition, true, testName);
            throw e.getTargetException();
        }
    }

    public static void GenericAssertCallback(Method methodToInvoke, HashMap<String, Object> locals, BooleanSupplier condition) throws Throwable {
        Assertions.GenericAssertCallback(methodToInvoke, locals, (Object)condition, (String)null);
    }

    public static void assertTrue(boolean condition, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertTrue", Boolean.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, condition, messageSupplier);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertTrue", BooleanSupplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, booleanSupplier);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertTrue", BooleanSupplier.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)booleanSupplier, message);
    }

    public static void assertTrue(boolean condition, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertTrue", Boolean.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, condition, message);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertTrue", BooleanSupplier.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, booleanSupplier, messageSupplier);
    }

    public static void assertFalse(boolean condition, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertFalse", Boolean.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, condition);
    }

    public static void assertFalse(boolean condition, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertFalse", Boolean.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, condition, message);
    }

    public static void assertFalse(boolean condition, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertFalse", Boolean.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, condition, messageSupplier);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertFalse", BooleanSupplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, booleanSupplier);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertFalse", BooleanSupplier.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)booleanSupplier, message);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertFalse", BooleanSupplier.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, booleanSupplier, messageSupplier);
    }

    public static void assertNull(Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNull", Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, actual);
    }

    public static void assertNull(Object actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNull", Object.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, actual, message);
    }

    public static void assertNull(Object actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNull", Object.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, actual, messageSupplier);
    }

    public static void assertNotNull(Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotNull", Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, actual);
    }

    public static void assertNotNull(Object actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotNull", Object.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, actual, message);
    }

    public static void assertNotNull(Object actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotNull", Object.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, actual, messageSupplier);
    }

    public static void assertEquals(short expected, short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.TYPE, Short.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(short expected, Short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.TYPE, Short.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Short expected, short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.class, Short.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Short expected, Short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.class, Short.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(short expected, short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.TYPE, Short.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(short expected, Short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.TYPE, Short.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Short expected, short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.class, Short.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Short expected, Short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.class, Short.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(short expected, short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.TYPE, Short.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(short expected, Short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.TYPE, Short.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Short expected, short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.class, Short.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Short expected, Short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Short.class, Short.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(byte expected, byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.TYPE, Byte.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(byte expected, Byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.TYPE, Byte.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Byte expected, byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.class, Byte.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Byte expected, Byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.class, Byte.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(byte expected, byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.TYPE, Byte.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(byte expected, Byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.TYPE, Byte.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Byte expected, byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.class, Byte.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Byte expected, Byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.class, Byte.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(byte expected, byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.TYPE, Byte.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(byte expected, Byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.TYPE, Byte.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Byte expected, byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.class, Byte.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Byte expected, Byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Byte.class, Byte.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(int expected, int actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.TYPE, Integer.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(int expected, Integer actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.TYPE, Integer.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Integer expected, int actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.class, Integer.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Integer expected, Integer actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.class, Integer.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(int expected, int actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.TYPE, Integer.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(int expected, Integer actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.TYPE, Integer.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Integer expected, int actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.class, Integer.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Integer expected, Integer actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.class, Integer.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(int expected, int actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.TYPE, Integer.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(int expected, Integer actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.TYPE, Integer.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Integer expected, int actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.class, Integer.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Integer expected, Integer actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Integer.class, Integer.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(long expected, long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.TYPE, Long.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(long expected, Long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.TYPE, Long.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Long expected, long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.class, Long.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Long expected, Long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.class, Long.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(long expected, long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.TYPE, Long.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(long expected, Long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.TYPE, Long.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Long expected, long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.class, Long.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Long expected, Long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.class, Long.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(long expected, long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.TYPE, Long.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(long expected, Long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.TYPE, Long.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Long expected, long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.class, Long.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Long expected, Long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Long.class, Long.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(float expected, float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), Float.valueOf(actual));
    }

    public static void assertEquals(float expected, Float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), actual);
    }

    public static void assertEquals(Float expected, float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.class, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, Float.valueOf(actual));
    }

    public static void assertEquals(Float expected, Float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.class, Float.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(float expected, float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), message);
    }

    public static void assertEquals(float expected, Float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)actual, message);
    }

    public static void assertEquals(Float expected, float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.class, Float.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)Float.valueOf(actual), message);
    }

    public static void assertEquals(Float expected, Float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.class, Float.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(float expected, float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), messageSupplier);
    }

    public static void assertEquals(float expected, Float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)actual, messageSupplier);
    }

    public static void assertEquals(Float expected, float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.class, Float.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)Float.valueOf(actual), messageSupplier);
    }

    public static void assertEquals(Float expected, Float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.class, Float.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(float expected, float actual, float delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.TYPE, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), delta);
    }

    public static void assertEquals(float expected, float actual, float delta, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.TYPE, Float.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), delta, message);
    }

    public static void assertEquals(float expected, float actual, float delta, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Float.TYPE, Float.TYPE, Float.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), delta, messageSupplier);
    }

    public static void assertEquals(double expected, double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(double expected, Double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Double expected, double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.class, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(Double expected, Double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.class, Double.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(double expected, double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(double expected, Double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Double expected, double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.class, Double.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(Double expected, Double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.class, Double.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(double expected, double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(double expected, Double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Double expected, double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.class, Double.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Double expected, Double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.class, Double.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(double expected, double actual, double delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.TYPE, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, delta);
    }

    public static void assertEquals(double expected, double actual, double delta, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.TYPE, Double.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, delta, message);
    }

    public static void assertEquals(double expected, double actual, double delta, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Double.TYPE, Double.TYPE, Double.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, delta, messageSupplier);
    }

    public static void assertEquals(char expected, char actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.TYPE, Character.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), Character.valueOf(actual));
    }

    public static void assertEquals(char expected, Character actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.TYPE, Character.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), actual);
    }

    public static void assertEquals(Character expected, char actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.class, Character.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, Character.valueOf(actual));
    }

    public static void assertEquals(Character expected, Character actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.class, Character.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertEquals(char expected, char actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.TYPE, Character.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), (Object)Character.valueOf(actual), message);
    }

    public static void assertEquals(char expected, Character actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.TYPE, Character.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), (Object)actual, message);
    }

    public static void assertEquals(Character expected, char actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.class, Character.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)Character.valueOf(actual), message);
    }

    public static void assertEquals(Character expected, Character actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.class, Character.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertEquals(char expected, char actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.TYPE, Character.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), (Object)Character.valueOf(actual), messageSupplier);
    }

    public static void assertEquals(char expected, Character actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.TYPE, Character.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), (Object)actual, messageSupplier);
    }

    public static void assertEquals(Character expected, char actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.class, Character.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)Character.valueOf(actual), messageSupplier);
    }

    public static void assertEquals(Character expected, Character actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Character.class, Character.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertEquals(Object expected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Object.class, Object.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual, message);
    }

    public static void assertEquals(Object expected, Object actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertEquals", Object.class, Object.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(boolean expected, boolean actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Boolean.TYPE, Boolean.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual);
    }

    public static void assertArrayEquals(boolean expected, boolean actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Boolean.TYPE, Boolean.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertArrayEquals(boolean expected, boolean actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Boolean.TYPE, Boolean.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertArrayEquals(char expected, char actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Character.TYPE, Character.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), Character.valueOf(actual));
    }

    public static void assertArrayEquals(char expected, char actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Character.TYPE, Character.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), (Object)Character.valueOf(actual), message);
    }

    public static void assertArrayEquals(char expected, char actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Character.TYPE, Character.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(expected), (Object)Character.valueOf(actual), messageSupplier);
    }

    public static void assertArrayEquals(byte expected, byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Byte.TYPE, Byte.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertArrayEquals(byte expected, byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Byte.TYPE, Byte.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertArrayEquals(byte expected, byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Byte.TYPE, Byte.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertArrayEquals(short expected, short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Short.TYPE, Short.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertArrayEquals(short expected, short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Short.TYPE, Short.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertArrayEquals(short expected, short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Short.TYPE, Short.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertArrayEquals(int expected, int actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Integer.TYPE, Integer.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertArrayEquals(int expected, int actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Integer.TYPE, Integer.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertArrayEquals(int expected, int actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Integer.TYPE, Integer.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertArrayEquals(long expected, long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Long.TYPE, Long.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertArrayEquals(long expected, long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Long.TYPE, Long.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertArrayEquals(long expected, long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Long.TYPE, Long.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertArrayEquals(float expected, float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Float.TYPE, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), Float.valueOf(actual));
    }

    public static void assertArrayEquals(float expected, float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Float.TYPE, Float.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), message);
    }

    public static void assertArrayEquals(float expected, float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Float.TYPE, Float.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), messageSupplier);
    }

    public static void assertArrayEquals(float expected, float actual, float delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Float.TYPE, Float.TYPE, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), delta);
    }

    public static void assertArrayEquals(float expected, float actual, float delta, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Float.TYPE, Float.TYPE, Float.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), delta, message);
    }

    public static void assertArrayEquals(float expected, float actual, float delta, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Float.TYPE, Float.TYPE, Float.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(expected), (Object)Float.valueOf(actual), delta, messageSupplier);
    }

    public static void assertArrayEquals(double expected, double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Double.TYPE, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertArrayEquals(double expected, double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Double.TYPE, Double.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertArrayEquals(double expected, double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Double.TYPE, Double.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertArrayEquals(double expected, double actual, double delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Double.TYPE, Double.TYPE, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, delta);
    }

    public static void assertArrayEquals(double expected, double actual, double delta, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Double.TYPE, Double.TYPE, Double.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, delta, message);
    }

    public static void assertArrayEquals(double expected, double actual, double delta, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Double.TYPE, Double.TYPE, Double.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, delta, messageSupplier);
    }

    public static void assertArrayEquals(Object expected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual);
    }

    public static void assertArrayEquals(Object expected, Object actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Object.class, Object.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual, message);
    }

    public static void assertArrayEquals(Object expected, Object actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertArrayEquals", Object.class, Object.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual, messageSupplier);
    }

    public static void assertIterableEquals(Iterable expected, Iterable actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertIterableEquals", Iterable.class, Iterable.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, actual);
    }

    public static void assertIterableEquals(Iterable expected, Iterable actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertIterableEquals", Iterable.class, Iterable.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, message);
    }

    public static void assertIterableEquals(Iterable expected, Iterable actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertIterableEquals", Iterable.class, Iterable.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expected, (Object)actual, messageSupplier);
    }

    public static void assertLinesMatch(List expectedLines, List actualLines, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertLinesMatch", List.class, List.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedLines, actualLines);
    }

    public static void assertLinesMatch(List expectedLines, List actualLines, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertLinesMatch", List.class, List.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedLines, (Object)actualLines, message);
    }

    public static void assertLinesMatch(List expectedLines, List actualLines, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertLinesMatch", List.class, List.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedLines, (Object)actualLines, messageSupplier);
    }

    public static void assertLinesMatch(Stream expectedLines, Stream actualLines, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertLinesMatch", Stream.class, Stream.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedLines, actualLines);
    }

    public static void assertLinesMatch(Stream expectedLines, Stream actualLines, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertLinesMatch", Stream.class, Stream.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedLines, (Object)actualLines, message);
    }

    public static void assertLinesMatch(Stream expectedLines, Stream actualLines, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertLinesMatch", Stream.class, Stream.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedLines, (Object)actualLines, messageSupplier);
    }

    public static void assertNotEquals(byte unexpected, byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.TYPE, Byte.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(byte unexpected, Byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.TYPE, Byte.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Byte unexpected, byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.class, Byte.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Byte unexpected, Byte actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.class, Byte.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(byte unexpected, byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.TYPE, Byte.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(byte unexpected, Byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.TYPE, Byte.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Byte unexpected, byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.class, Byte.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Byte unexpected, Byte actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.class, Byte.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(byte unexpected, byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.TYPE, Byte.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(byte unexpected, Byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.TYPE, Byte.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Byte unexpected, byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.class, Byte.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Byte unexpected, Byte actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Byte.class, Byte.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(short unexpected, short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.TYPE, Short.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(short unexpected, Short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.TYPE, Short.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Short unexpected, short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.class, Short.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Short unexpected, Short actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.class, Short.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(short unexpected, short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.TYPE, Short.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(short unexpected, Short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.TYPE, Short.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Short unexpected, short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.class, Short.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Short unexpected, Short actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.class, Short.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(short unexpected, short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.TYPE, Short.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(short unexpected, Short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.TYPE, Short.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Short unexpected, short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.class, Short.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Short unexpected, Short actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Short.class, Short.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(int unexpected, int actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.TYPE, Integer.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(int unexpected, Integer actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.TYPE, Integer.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Integer unexpected, int actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.class, Integer.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Integer unexpected, Integer actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.class, Integer.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(int unexpected, int actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.TYPE, Integer.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(int unexpected, Integer actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.TYPE, Integer.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Integer unexpected, int actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.class, Integer.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Integer unexpected, Integer actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.class, Integer.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(int unexpected, int actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.TYPE, Integer.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(int unexpected, Integer actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.TYPE, Integer.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Integer unexpected, int actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.class, Integer.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Integer unexpected, Integer actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Integer.class, Integer.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(long unexpected, long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.TYPE, Long.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(long unexpected, Long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.TYPE, Long.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Long unexpected, long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.class, Long.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Long unexpected, Long actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.class, Long.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(long unexpected, long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.TYPE, Long.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(long unexpected, Long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.TYPE, Long.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Long unexpected, long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.class, Long.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Long unexpected, Long actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.class, Long.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(long unexpected, long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.TYPE, Long.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(long unexpected, Long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.TYPE, Long.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Long unexpected, long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.class, Long.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Long unexpected, Long actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Long.class, Long.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(float unexpected, float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), Float.valueOf(actual));
    }

    public static void assertNotEquals(float unexpected, Float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), actual);
    }

    public static void assertNotEquals(Float unexpected, float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.class, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, Float.valueOf(actual));
    }

    public static void assertNotEquals(Float unexpected, Float actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.class, Float.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(float unexpected, float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual), message);
    }

    public static void assertNotEquals(float unexpected, Float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), (Object)actual, message);
    }

    public static void assertNotEquals(Float unexpected, float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.class, Float.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)Float.valueOf(actual), message);
    }

    public static void assertNotEquals(Float unexpected, Float actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.class, Float.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(float unexpected, float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual), messageSupplier);
    }

    public static void assertNotEquals(float unexpected, Float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Float unexpected, float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.class, Float.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)Float.valueOf(actual), messageSupplier);
    }

    public static void assertNotEquals(Float unexpected, Float actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.class, Float.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(float unexpected, float actual, float delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.TYPE, Float.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual), delta);
    }

    public static void assertNotEquals(float unexpected, float actual, float delta, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.TYPE, Float.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual), delta, message);
    }

    public static void assertNotEquals(float unexpected, float actual, float delta, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Float.TYPE, Float.TYPE, Float.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Float.valueOf(unexpected), (Object)Float.valueOf(actual), delta, messageSupplier);
    }

    public static void assertNotEquals(double unexpected, double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(double unexpected, Double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Double unexpected, double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.class, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(Double unexpected, Double actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.class, Double.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(double unexpected, double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(double unexpected, Double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Double unexpected, double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.class, Double.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(Double unexpected, Double actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.class, Double.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(double unexpected, double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(double unexpected, Double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Double unexpected, double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.class, Double.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Double unexpected, Double actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.class, Double.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(double unexpected, double actual, double delta, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.TYPE, Double.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, delta);
    }

    public static void assertNotEquals(double unexpected, double actual, double delta, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.TYPE, Double.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, delta, message);
    }

    public static void assertNotEquals(double unexpected, double actual, double delta, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Double.TYPE, Double.TYPE, Double.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, delta, messageSupplier);
    }

    public static void assertNotEquals(char unexpected, char actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.TYPE, Character.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(unexpected), Character.valueOf(actual));
    }

    public static void assertNotEquals(char unexpected, Character actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.TYPE, Character.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(unexpected), actual);
    }

    public static void assertNotEquals(Character unexpected, char actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.class, Character.TYPE);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, Character.valueOf(actual));
    }

    public static void assertNotEquals(Character unexpected, Character actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.class, Character.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, actual);
    }

    public static void assertNotEquals(char unexpected, char actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.TYPE, Character.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(unexpected), (Object)Character.valueOf(actual), message);
    }

    public static void assertNotEquals(char unexpected, Character actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.TYPE, Character.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(unexpected), (Object)actual, message);
    }

    public static void assertNotEquals(Character unexpected, char actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.class, Character.TYPE, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)Character.valueOf(actual), message);
    }

    public static void assertNotEquals(Character unexpected, Character actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.class, Character.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, message);
    }

    public static void assertNotEquals(char unexpected, char actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.TYPE, Character.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(unexpected), (Object)Character.valueOf(actual), messageSupplier);
    }

    public static void assertNotEquals(char unexpected, Character actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.TYPE, Character.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)Character.valueOf(unexpected), (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Character unexpected, char actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.class, Character.TYPE, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)Character.valueOf(actual), messageSupplier);
    }

    public static void assertNotEquals(Character unexpected, Character actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Character.class, Character.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)unexpected, (Object)actual, messageSupplier);
    }

    public static void assertNotEquals(Object unexpected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, unexpected, actual);
    }

    public static void assertNotEquals(Object unexpected, Object actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Object.class, Object.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, unexpected, actual, message);
    }

    public static void assertNotEquals(Object unexpected, Object actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotEquals", Object.class, Object.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, unexpected, actual, messageSupplier);
    }

    public static void assertSame(Object expected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertSame", Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual);
    }

    public static void assertSame(Object expected, Object actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertSame", Object.class, Object.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual, message);
    }

    public static void assertSame(Object expected, Object actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertSame", Object.class, Object.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, expected, actual, messageSupplier);
    }

    public static void assertNotSame(Object unexpected, Object actual, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotSame", Object.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, unexpected, actual);
    }

    public static void assertNotSame(Object unexpected, Object actual, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotSame", Object.class, Object.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, unexpected, actual, message);
    }

    public static void assertNotSame(Object unexpected, Object actual, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertNotSame", Object.class, Object.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, unexpected, actual, messageSupplier);
    }

    public static void assertInstanceOf(Class expectedType, Object actualValue, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertInstanceOf", Class.class, Object.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedType, actualValue);
    }

    public static void assertInstanceOf(Class expectedType, Object actualValue, String message, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertInstanceOf", Class.class, Object.class, String.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedType, actualValue, message);
    }

    public static void assertInstanceOf(Class expectedType, Object actualValue, Supplier messageSupplier, HashMap<String, Object> locals) throws Throwable {
        Method pAssertEqual = pAssertClass.getDeclaredMethod("assertInstanceOf", Class.class, Object.class, Supplier.class);
        Assertions.GenericAssertCallback(pAssertEqual, locals, (Object)expectedType, actualValue, messageSupplier);
    }

    static {
        try {
            pAssertClass = ClassLoader.getSystemClassLoader().loadClass("org.junit.jupiter.api.Assertions");
        }
        catch (ClassNotFoundException e) {
            try {
                pAssertClass = ClassLoader.getSystemClassLoader().loadClass("org.junit.Assert");
            }
            catch (ClassNotFoundException ex) {
                pAssertClass = null;
            }
        }
        catch (Throwable t) {
            pAssertClass = null;
        }
        try {
            Class<?> pClass = ClassLoader.getSystemClassLoader().loadClass("com.rookout.rook.Services.Instrumentation.CallbackDispatcher");
            pAssertExecute = pClass.getDeclaredMethod("JunitExecuteCallback", HashMap.class, Object.class, Object.class, Object.class);
            pAssertExecute.setAccessible(true);
            pInstance = pClass.getDeclaredField("instance");
            pInstance.setAccessible(true);
        }
        catch (Throwable t) {
            pAssertExecute = null;
            pInstance = null;
        }
    }
}

