/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Config;
import com.rookout.rook.RookLogger;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class Utils {
    static final Pattern COMMAND_LINE_PARSER = Pattern.compile("\"(?:\\\\\"|[^\\\\(?=\")])*\"|[^ \"]+");
    public static final String ROOKOUT_PREFIX = "ROOKOUT_";
    public static final Set<String> SANITIZE_BLACKLIST = new HashSet<String>(Arrays.asList("ROOKOUT_LABELS"));
    private static final Pattern reSanitizer = Pattern.compile("^[\\s\"']*(?<value>\\S*?.*?\\S*?)[\\s\"'/]*$");

    public static String GetExecutalbePath() {
        ArrayList<String> commandLine = Utils.GetCommandLine();
        if (commandLine.size() > 0) {
            return commandLine.get(0);
        }
        return "";
    }

    public static ArrayList<String> GetCommandLine() {
        String commnadLine = System.getProperty("sun.java.command");
        if (null == commnadLine) {
            return new ArrayList<String>();
        }
        return Utils.ParseCommandLine(commnadLine);
    }

    public static ArrayList<String> ParseCommandLine(String commandLine) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = COMMAND_LINE_PARSER.matcher(commandLine);
        while (matcher.find()) {
            String match = matcher.group();
            String argument = match.replaceAll("\"$", "").replaceAll("^\"", "").replace("\\\"", "\"");
            result.add(argument);
        }
        return result;
    }

    public static byte[] getEntryBytes(JarFile file, ZipEntry entry) throws IOException {
        byte[] a_by = null;
        try (DataInputStream dis = new DataInputStream(file.getInputStream(entry));){
            long lSize = entry.getSize();
            a_by = new byte[(int)lSize];
            dis.readFully(a_by);
        }
        return a_by;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (byte b : bytes) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static Boolean IsJavaFile(String filePath) {
        return filePath.endsWith(".java");
    }

    public static Boolean IsColdFusionFile(String filePath) {
        return filePath.endsWith(".cfc") || filePath.endsWith(".cfm");
    }

    public static Boolean IsScalaFile(String filePath) {
        return filePath.endsWith(".scala");
    }

    public static Boolean isGroovyFile(String filePath) {
        return filePath.endsWith(".groovy");
    }

    public static Boolean IsClojureFile(String filePath) {
        return filePath.endsWith(".clj");
    }

    public static Boolean IsJRubyFile(String filePath) {
        return filePath.endsWith(".rb");
    }

    public static String GetNameWithoutExtension(String file) {
        Path filePath = Paths.get(file, new String[0]);
        String fileName = filePath.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    public static String GetClassNamePath(String className) {
        if (-1 != className.indexOf(36)) {
            className = className.substring(0, className.indexOf(36));
        }
        return className;
    }

    public static String getEnv(String envString, String defaultValue) {
        String env = System.getenv(envString);
        if (env != null) {
            return env;
        }
        return defaultValue;
    }

    public static String GetConfigurationString(String env) {
        String v = System.getProperty(env);
        if (v == null) {
            v = System.getenv(env);
        }
        return Utils.sanitizeIfNecessary(env, v);
    }

    private static String sanitizeIfNecessary(String env, String value) {
        Matcher matcher;
        if (env.startsWith(ROOKOUT_PREFIX) && !SANITIZE_BLACKLIST.contains(env) && value != null && (matcher = reSanitizer.matcher(value)).find()) {
            return matcher.group("value");
        }
        return value;
    }

    public static void GetAllFileInDirectory(List<String> fileNames, Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    Utils.GetAllFileInDirectory(fileNames, path);
                    continue;
                }
                fileNames.add(path.toString());
            }
        }
        catch (Exception e) {
            RookLogger.Instance().log(Level.SEVERE, "Failed to iterate file system: " + e.toString(), e, new Object[0]);
        }
    }

    public static long MSToNS(long milliseconds) {
        return milliseconds * 1000000L;
    }

    public static long DoubleMSToNS(double milliseconds) {
        return (long)(milliseconds * 1000000.0);
    }

    public static double getTimeInMillisDouble() {
        return System.nanoTime() / 1000000L;
    }

    public static void QuietPrint(String msg) {
        if (!Config.Instance().LoggingConfiguration$QUIET) {
            System.err.println(msg);
        }
    }
}

