/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs.Locations;

import com.rookout.rook.Augs.Locations.HashInfo;
import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.WarningReporter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Breakpoint
implements WarningReporter {
    private HashMap<String, LocationFileLine> logicalAugs = new HashMap();
    private HashInfo hashInfo;
    private final String filename;
    private final int lineno;
    private static int breakpointCounter = 0;
    private final int id;
    private HashMap<String, Boolean> classMatchCache = new HashMap();
    private State state;

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breakpoint that = (Breakpoint)o;
        return this.lineno == that.lineno && Objects.equals(this.filename, that.filename);
    }

    public synchronized int hashCode() {
        return Objects.hash(this.filename, this.lineno);
    }

    @Override
    public synchronized void SendWarning(RookError error) {
        for (Map.Entry<String, LocationFileLine> logicalEntry : this.logicalAugs.entrySet()) {
            logicalEntry.getValue().SendWarning(error);
        }
    }

    @Override
    public synchronized void SendError(RookError error) {
        for (Map.Entry<String, LocationFileLine> logicalEntry : this.logicalAugs.entrySet()) {
            logicalEntry.getValue().SendError(error);
        }
    }

    public synchronized void SetError(RookError error) {
        for (Map.Entry<String, LocationFileLine> logicalEntry : this.logicalAugs.entrySet()) {
            logicalEntry.getValue().SetError(error);
        }
    }

    public synchronized void SetActive() {
        if (this.state != State.Active) {
            this.state = State.Active;
            for (Map.Entry<String, LocationFileLine> logicalEntry : this.logicalAugs.entrySet()) {
                logicalEntry.getValue().SetActive();
            }
        }
    }

    public synchronized boolean IsWaitingForSingleActive() {
        return this.state == State.WaitingForActive && this.logicalAugs.size() == 1;
    }

    public synchronized boolean IsWaitingForDelete() {
        return this.state == State.WaitingForDelete;
    }

    public synchronized void SetRemoved() {
        if (this.state != State.Deleted) {
            this.state = State.Deleted;
            for (Map.Entry<String, LocationFileLine> logicalEntry : this.logicalAugs.entrySet()) {
                logicalEntry.getValue().MarkDeleted();
                logicalEntry.getValue().SetRemoved();
            }
            this.logicalAugs.clear();
        }
    }

    public Breakpoint(String filename, int lineno) {
        this.hashInfo = new HashInfo();
        this.filename = filename;
        this.lineno = lineno;
        this.id = ++breakpointCounter;
        this.state = State.Deleted;
    }

    public synchronized int ID() {
        return this.id;
    }

    public synchronized String GetFilename() {
        return this.filename;
    }

    public synchronized int GetLineno() {
        return this.lineno;
    }

    public synchronized boolean IsEmpty() {
        return this.logicalAugs.isEmpty();
    }

    public synchronized void AddLocation(LocationFileLine loc) throws Exceptions.ToolException {
        this.AssertConsistentLocation(loc);
        this.hashInfo.merge(loc.getHashInfo());
        this.logicalAugs.put(loc.getAugId(), loc);
        switch (this.state) {
            case WaitingForActive: {
                loc.SetPending();
                break;
            }
            case Active: {
                loc.SetActive();
                break;
            }
            case WaitingForDelete: {
                this.state = State.Active;
                loc.SetActive();
                break;
            }
            case Deleted: {
                this.state = State.WaitingForActive;
                loc.SetPending();
            }
        }
    }

    public synchronized void RemoveLocation(String augId) {
        LocationFileLine loc = this.GetLogicalByID(augId);
        if (loc == null) {
            return;
        }
        loc.MarkDeleted();
        loc.SetRemoved();
        this.logicalAugs.remove(augId);
        if (!this.IsEmpty()) {
            return;
        }
        switch (this.state) {
            case WaitingForActive: {
                this.state = State.Deleted;
                break;
            }
            case Active: {
                this.state = State.WaitingForDelete;
                break;
            }
        }
    }

    public synchronized Map<String, LocationFileLine> AllLocations() {
        return new HashMap<String, LocationFileLine>(this.logicalAugs);
    }

    public synchronized LocationFileLine GetLogicalByID(String augId) {
        return this.logicalAugs.get(augId);
    }

    public synchronized boolean HasId(String augId) {
        return this.logicalAugs.containsKey(augId);
    }

    public synchronized boolean IsDeleted() {
        return this.state == State.Deleted;
    }

    public synchronized boolean ShouldBeActive() {
        return this.state == State.Active || this.state == State.WaitingForActive;
    }

    public synchronized HashInfo GetHashInfo() {
        return this.hashInfo;
    }

    public synchronized Boolean GetClassMatchFromCache(URL rawClass) {
        return this.classMatchCache.get(rawClass.toString());
    }

    public synchronized void AddClassMatchToCache(URL rawClass, Boolean match) {
        this.classMatchCache.put(rawClass.toString(), match);
    }

    public synchronized String GetFileExtension() {
        String filename = this.GetFilename();
        int lastDot = filename.lastIndexOf(46);
        if (-1 == lastDot) {
            return "";
        }
        return filename.substring(lastDot);
    }

    public synchronized int GetNumberOfMatchesInCache() {
        return this.classMatchCache.size();
    }

    private void AssertConsistentLocation(LocationFileLine loc) throws Exceptions.RookInconsistentFileLine {
        if (!this.filename.equals(loc.getFilename())) {
            throw new Exceptions.RookInconsistentFileLine(this.filename, this.lineno, loc.getFilename(), loc.getLineno());
        }
        if (this.lineno != loc.getLineno()) {
            throw new Exceptions.RookInconsistentFileLine(this.filename, this.lineno, loc.getFilename(), loc.getLineno());
        }
    }

    private static enum State {
        WaitingForActive,
        Active,
        WaitingForDelete,
        Deleted;

    }
}

