/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.Breakpoint;
import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class Augs {
    BreakpointsInFiles breakpointsInFiles = new BreakpointsInFiles();
    private HashMap<Integer, Breakpoint> breakpointsByID = new HashMap();
    private HashMap<String, Breakpoint> breakpointsByAugID = new HashMap();

    Augs() {
    }

    final synchronized Breakpoint AddAug(LocationFileLine location) throws Exceptions.ToolException {
        int lineno;
        Breakpoint breakpoint;
        String fileName = location.getFilename().toLowerCase();
        BreakpointsInFile breakpointsInFile = (BreakpointsInFile)this.breakpointsInFiles.get(fileName);
        if (null == breakpointsInFile) {
            breakpointsInFile = new BreakpointsInFile();
            this.breakpointsInFiles.put(fileName, breakpointsInFile);
        }
        if (null == (breakpoint = (Breakpoint)breakpointsInFile.get(lineno = location.getLineno()))) {
            breakpoint = new Breakpoint(location.getFilename(), location.getLineno());
            this.breakpointsByID.put(breakpoint.ID(), breakpoint);
            breakpointsInFile.put(lineno, breakpoint);
        }
        breakpoint.AddLocation(location);
        this.breakpointsByAugID.put(location.getAugId(), breakpoint);
        return breakpoint;
    }

    final synchronized Breakpoint RemoveAug(String augId) {
        Breakpoint bp = this.breakpointsByAugID.remove(augId);
        if (bp == null) {
            return null;
        }
        bp.RemoveLocation(augId);
        return bp;
    }

    synchronized Breakpoint GetBreakpointByID(int breakpointID) {
        return this.breakpointsByID.get(breakpointID);
    }

    synchronized Breakpoint GetBreakpointByAugId(String augId) {
        return this.breakpointsByAugID.get(augId);
    }

    synchronized BreakpointsInFile GetAugs(String fileName) {
        String lowerCaseFileName = fileName.toLowerCase();
        BreakpointsInFile bps = null;
        if (Utils.IsClojureFile(lowerCaseFileName).booleanValue()) {
            for (Map.Entry classIterator : this.breakpointsInFiles.entrySet()) {
                if (!((String)classIterator.getKey()).endsWith(lowerCaseFileName)) continue;
                bps = (BreakpointsInFile)classIterator.getValue();
                break;
            }
        } else {
            bps = (BreakpointsInFile)this.breakpointsInFiles.get(lowerCaseFileName);
        }
        if (bps == null) {
            return new BreakpointsInFile();
        }
        return (BreakpointsInFile)bps.clone();
    }

    synchronized void RemoveBreakpoint(Breakpoint bp) {
        String filename = bp.GetFilename().toLowerCase();
        int lineno = bp.GetLineno();
        this.breakpointsByID.remove(bp.ID());
        for (String augId : bp.AllLocations().keySet()) {
            this.breakpointsByAugID.remove(augId);
        }
        BreakpointsInFile breakpointsInFile = (BreakpointsInFile)this.breakpointsInFiles.get(filename);
        if (breakpointsInFile == null) {
            return;
        }
        breakpointsInFile.remove(lineno);
        if (breakpointsInFile.isEmpty()) {
            this.breakpointsInFiles.remove(filename);
        }
    }

    synchronized Set<String> AllAugIds() {
        return new HashSet<String>(this.breakpointsByAugID.keySet());
    }

    static class BreakpointsInFiles
    extends HashMap<String, BreakpointsInFile> {
        BreakpointsInFiles() {
        }
    }

    static class BreakpointsInFile
    extends HashMap<Integer, Breakpoint> {
        BreakpointsInFile() {
        }
    }
}

