/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.Breakpoint;
import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Augs.Locations.LocationJunit;
import com.rookout.rook.LogCache;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Logging.LoggingService;
import java.util.HashMap;
import java.util.logging.Level;
import rook.org.objectweb.asm.Type;

public class CallbackDispatcher {
    private static CallbackDispatcher instance;
    private LogCache logCache;
    private final Augs augs;
    static final String CallbackDescriptor;

    static void CreateCallbackDispatcher(Augs augs) {
        if (null != instance) {
            throw new RuntimeException("Cannot create CallbackDispatcher twice");
        }
        instance = new CallbackDispatcher(augs);
    }

    static void Close() {
        instance = null;
    }

    public void JunitExecuteCallback(HashMap<String, Object> locals, Object expected, Object actual, Object test_name) throws Throwable {
        try {
            ContainerNamespace extracted = new ContainerNamespace();
            ContainerNamespace testInfo = new ContainerNamespace();
            testInfo.WriteAttribute("expected", new JavaObjectNamespace(expected));
            testInfo.WriteAttribute("actual", new JavaObjectNamespace(actual));
            testInfo.WriteAttribute("test_name", new JavaObjectNamespace(test_name));
            extracted.WriteAttribute("test_info", testInfo);
            LocationJunit.ExecuteLocation(locals, extracted);
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw e;
            }
            RookLogger.Instance().log(Level.SEVERE, "Error while calling aug", e, new Object[0]);
        }
    }

    public void Callback(int breakpointID, HashMap<String, Object> locals) throws Throwable {
        try {
            long now = System.nanoTime();
            Breakpoint bp = this.augs.GetBreakpointByID(breakpointID);
            if (bp == null) {
                String msg = "Failed to find breakpoint: " + breakpointID;
                if (!this.logCache.ShouldSilenceLog(msg)) {
                    RookLogger.Instance().fatal(msg, new Object[0]);
                }
                return;
            }
            for (LocationFileLine location : bp.AllLocations().values()) {
                if (null != location) {
                    location.Execute(locals, null, now);
                    continue;
                }
                String msg = "Got null LocationFileLine from breakpoint: " + breakpointID;
                if (this.logCache.ShouldSilenceLog(msg)) {
                    return;
                }
                RookLogger.Instance().fatal(msg, new Object[0]);
            }
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw e;
            }
            RookLogger.Instance().log(Level.SEVERE, "Error while calling aug", e, new Object[0]);
        }
    }

    public void LogCallback(Object _this, Object level, Object message, int type, String module, Object ... params) {
        try {
            long now = System.nanoTime();
            LoggingService.DispatchLog(now, _this, level, message, type, module, params);
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.SEVERE, "Error while calling aug", e, new Object[0]);
        }
    }

    private CallbackDispatcher(Augs augs) {
        this.augs = augs;
        this.logCache = new LogCache(10);
    }

    static {
        CallbackDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Integer.TYPE), Type.getType(HashMap.class));
    }
}

