/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.Breakpoint;
import com.rookout.rook.Services.Instrumentation.Files;
import java.util.HashMap;
import java.util.HashSet;
import rook.com.google.common.collect.ImmutableSet;
import rook.com.google.common.collect.Sets;

class ClassActiveBreakpoints {
    HashMap<Files.ClassObject, BreakpointSet> activeBreakpoints = new HashMap();

    ClassActiveBreakpoints() {
    }

    synchronized void AddBreakpoint(Breakpoint bp, Files.ClassObject cls) {
        BreakpointSet breakpoints = this.activeBreakpoints.get(cls);
        if (null == breakpoints) {
            breakpoints = new BreakpointSet();
            this.activeBreakpoints.put(cls, breakpoints);
        }
        if (!breakpoints.contains(bp)) {
            bp.SetActive();
            breakpoints.add(bp);
        }
    }

    synchronized void RemoveBreakpoint(Breakpoint breakpoint, Files.ClassObject cls) {
        BreakpointSet breakpoints = this.activeBreakpoints.get(cls);
        if (null == breakpoints) {
            return;
        }
        if (breakpoints.contains(breakpoint)) {
            breakpoint.SetRemoved();
            breakpoints.remove(breakpoint);
        }
        if (breakpoints.isEmpty()) {
            this.activeBreakpoints.remove(cls);
        }
    }

    synchronized boolean IsActive(Breakpoint breakpoint, Files.ClassObject cls) {
        BreakpointSet breakpoints = this.activeBreakpoints.get(cls);
        if (null == breakpoints) {
            return false;
        }
        return breakpoints.contains(breakpoint);
    }

    synchronized void SetAllBreakpoints(BreakpointSet newBreakpoints, Files.ClassObject cls) {
        BreakpointSet oldBreakpoints = this.activeBreakpoints.get(cls);
        if (null == oldBreakpoints) {
            if (newBreakpoints.isEmpty()) {
                return;
            }
            oldBreakpoints = new BreakpointSet();
            this.activeBreakpoints.put(cls, oldBreakpoints);
        }
        ImmutableSet<Breakpoint> additions = Sets.difference(newBreakpoints, oldBreakpoints).immutableCopy();
        ImmutableSet<Breakpoint> removals = Sets.difference(oldBreakpoints, newBreakpoints).immutableCopy();
        for (Breakpoint breakpoint : additions) {
            this.AddBreakpoint(breakpoint, cls);
        }
        for (Breakpoint breakpoint : removals) {
            this.RemoveBreakpoint(breakpoint, cls);
        }
    }

    static class BreakpointSet
    extends HashSet<Breakpoint> {
        BreakpointSet() {
        }
    }
}

