/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.Breakpoint;
import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.ClassTransformUserWarnings;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.ClassActiveBreakpoints;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.IClassReloader;
import com.rookout.rook.Services.Instrumentation.InstrumentationService;
import com.rookout.rook.Services.Instrumentation.RateLimiter;
import com.rookout.rook.Services.Instrumentation.VisitorFindLocation;
import com.rookout.rook.Services.StackTrace.StackWalkerLock;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;

public class ClassReloader
implements IClassReloader {
    private final int RETRANSFORM_TOKENS = 200;
    private final int PARSE_CLASS_TOKENS = 25;
    private Thread thread;
    private boolean closing = false;
    private final InstrumentationService inst;
    private final Augs augs;
    private final Files files;
    private final ClassActiveBreakpoints classActiveBreakpoints;
    private RateLimiter limiter = null;
    private Queue queue;

    ClassReloader(InstrumentationService inst, Augs augs, Files files, ClassActiveBreakpoints classActiveBreakpoints) {
        this.inst = inst;
        this.augs = augs;
        this.files = files;
        this.classActiveBreakpoints = classActiveBreakpoints;
        if (0 != Config.Instance().ClassReloaderConfiguration$CLASS_RELOADING_RATE_LIMITER_BEAT_PERIOD.get()) {
            this.limiter = new RateLimiter(Config.Instance().ClassReloaderConfiguration$CLASS_RELOADING_RATE_LIMITER_BEAT_PERIOD);
            this.queue = new Queue();
            this.thread = new Thread((Runnable)new WorkerRunnable(), Config.Instance().ClassReloaderConfiguration$THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    @Override
    public void Stop() {
        this.closing = true;
        if (null != this.queue) {
            this.queue.Stop();
        }
        try {
            if (null != this.thread) {
                this.thread.join();
                this.thread = null;
            }
        }
        catch (InterruptedException e) {
            RookLogger.Instance().log(Level.SEVERE, "Error while closing output", e, new Object[0]);
        }
        if (null != this.limiter) {
            try {
                this.limiter.close();
            }
            catch (Exception e) {
                RookLogger.Instance().log(Level.SEVERE, "Error while closing limiter", e, new Object[0]);
            }
            this.limiter = null;
        }
        this.queue = null;
    }

    @Override
    public synchronized void AddAug(LocationFileLine location) throws Exceptions.ToolException {
        try {
            this.inst.lockClassReloader();
            Breakpoint bp = this.augs.AddAug(location);
            if (bp.IsWaitingForSingleActive()) {
                this.InstructReload(bp);
            }
        }
        finally {
            this.inst.unlockClassReloader();
        }
    }

    @Override
    public synchronized void RemoveAug(String augId) {
        try {
            this.inst.lockClassReloader();
            Breakpoint bp = this.augs.RemoveAug(augId);
            if (bp == null) {
                return;
            }
            if (bp.IsWaitingForDelete()) {
                this.InstructReload(bp);
            } else if (bp.IsDeleted()) {
                this.augs.RemoveBreakpoint(bp);
            }
        }
        finally {
            this.inst.unlockClassReloader();
        }
    }

    private void InstructReload(Breakpoint bp) {
        if (null != this.queue && !this.closing) {
            this.queue.Insert(bp);
            return;
        }
        this.inst.unlockClassReloader();
        this.ApplyAugAndReloadClasses(bp);
    }

    private synchronized void ApplyAugAndReloadClasses(Breakpoint bp) {
        try (UserWarnings reporter = new UserWarnings(bp);){
            String fileName = bp.GetFilename();
            Set<Files.ClassObject> classes = this.files.GetClasses(fileName);
            HashSet<Files.ClassObject> filteredClasses = this.GetAllClassesToRetransform(classes, bp);
            if (filteredClasses.size() > Config.Instance().ClassReloaderConfiguration$MAX_CLASS_COUNT_FOR_BREAKPOINT) {
                UserWarnings.SendError(new RookError(new Exceptions.RookTooManyClassesForBreakpoint(Config.Instance().ClassReloaderConfiguration$MAX_CLASS_COUNT_FOR_BREAKPOINT, filteredClasses.size())));
                return;
            }
            for (Files.ClassObject cls : filteredClasses) {
                this.ReloadClass(bp, cls);
            }
            if (bp.IsDeleted()) {
                this.augs.RemoveBreakpoint(bp);
            }
        }
    }

    private HashSet<Files.ClassObject> GetAllClassesToRetransform(Set<Files.ClassObject> classes, Breakpoint breakpoint) {
        boolean addAction = breakpoint.ShouldBeActive();
        HashSet<Files.ClassObject> filteredClasses = new HashSet<Files.ClassObject>();
        for (Files.ClassObject cls : classes) {
            URL rawClass;
            ClassLoader classLoader = cls.getClassLoader();
            if (classLoader == null || this.classActiveBreakpoints.IsActive(breakpoint, cls) == addAction) continue;
            if (null != this.limiter && !Utils.IsClojureFile(breakpoint.GetFilename()).booleanValue()) {
                this.limiter.RemoveTokens(25);
            }
            if (null != (rawClass = classLoader.getResource(cls.getClassName() + ".class")) && !VisitorFindLocation.ContainLocation(rawClass, cls.getClassName(), classLoader, breakpoint)) continue;
            filteredClasses.add(cls);
        }
        return filteredClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ReloadClass(Breakpoint breakpoint, Files.ClassObject classObject) {
        Class<?> cls;
        String javaName = classObject.getClassName().replace("/", ".");
        try {
            cls = Class.forName(javaName, true, classObject.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (Error e) {
            RookLogger.Instance().log(Level.SEVERE, "Failed to get class", e, new Object[0]);
            return;
        }
        if (!this.inst.isModifiableClass(cls)) {
            return;
        }
        if (null != this.limiter) {
            this.limiter.RemoveTokens(200);
        }
        try {
            ClassTransformUserWarnings.newClassReload(classObject.getClassName(), breakpoint);
            RookLogger.Instance().info("Retransforming class: " + javaName, new Object[0]);
            StackWalkerLock.lock.writeLock().lock();
            this.inst.ReloadClass(cls);
        }
        catch (Throwable e) {
            String message = "Error while reloading file";
            RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
            ClassTransformUserWarnings.SendReloadError(new RookError(e, message));
        }
        finally {
            StackWalkerLock.lock.writeLock().unlock();
            ClassTransformUserWarnings.finishClassReload();
        }
    }

    private class Queue {
        boolean closing = false;
        LinkedHashSet<Breakpoint> instrumentationContextSet = new LinkedHashSet();

        Queue() {
        }

        synchronized void Stop() {
            this.closing = true;
            this.notify();
        }

        synchronized void Insert(Breakpoint item) {
            this.instrumentationContextSet.add(item);
            if (1 <= this.instrumentationContextSet.size()) {
                this.notify();
            }
        }

        synchronized Breakpoint Pop() {
            while (this.IsEmpty() && !this.closing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    RookLogger.Instance().log(Level.SEVERE, "Error while waiting", e, new Object[0]);
                }
            }
            if (this.closing) {
                return null;
            }
            Iterator i = this.instrumentationContextSet.iterator();
            Breakpoint next = (Breakpoint)i.next();
            i.remove();
            return next;
        }

        synchronized boolean IsEmpty() {
            return this.instrumentationContextSet.size() == 0;
        }
    }

    private class WorkerRunnable
    implements Runnable {
        private WorkerRunnable() {
        }

        @Override
        public void run() {
            while (!ClassReloader.this.closing) {
                Breakpoint context = ClassReloader.this.queue.Pop();
                if (null == context) {
                    return;
                }
                ClassReloader.this.ApplyAugAndReloadClasses(context);
            }
        }
    }
}

