/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Locations.Breakpoint;
import com.rookout.rook.Augs.Locations.HashInfo;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;

class HashCheck {
    HashCheck() {
    }

    static FileHashes getFileHashes(byte[] buffer) throws NoSuchAlgorithmException, IOException {
        String fileContents = new String(buffer).replace("\r\n", "\n").replace("\r\u0000\n\u0000", "\n\u0000").replace("\r", "\n");
        CRC32 checksum = new CRC32();
        String[] lines = fileContents.split("\n");
        Long[] linesHashes = new Long[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            checksum.update(lines[i].getBytes(), 0, lines[i].length());
            linesHashes[i] = checksum.getValue() & 0xFFFFFFFFFFFFFFFFL;
            checksum.reset();
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(fileContents.getBytes("UTF-8"));
        return new FileHashes(Utils.bytesToHex(hash), linesHashes);
    }

    static FileHashes getFileHashes(InputStream fileContents) throws NoSuchAlgorithmException, IOException {
        byte[] rawBuffer = new byte[fileContents.available()];
        fileContents.read(rawBuffer);
        return HashCheck.getFileHashes(rawBuffer);
    }

    static int findLineUsingCrc(Breakpoint breakpoint, FileHashes fileHashes) {
        Long actualCrc = 0L;
        HashInfo hashInfo = breakpoint.GetHashInfo();
        if (breakpoint.GetLineno() > 0 && breakpoint.GetLineno() <= fileHashes.lines_crcs.length) {
            actualCrc = fileHashes.lines_crcs[breakpoint.GetLineno() - 1];
        }
        if (fileHashes.lines_crcs.length >= breakpoint.GetLineno() && hashInfo.line_crc.equals(actualCrc)) {
            return breakpoint.GetLineno();
        }
        if (hashInfo.line_crc_unique == null || !hashInfo.line_crc_unique.booleanValue()) {
            breakpoint.SetError(new RookError(new Exceptions.RookCrcMismatchException(breakpoint.GetFilename(), hashInfo.line_crc, actualCrc)));
            return -1;
        }
        int firstIndex = -1;
        boolean secondFound = false;
        for (int i = 0; i < fileHashes.lines_crcs.length; ++i) {
            if (!fileHashes.lines_crcs[i].equals(hashInfo.line_crc)) continue;
            if (firstIndex == -1) {
                firstIndex = i;
                continue;
            }
            secondFound = true;
            break;
        }
        if (firstIndex != -1 && !secondFound) {
            int updatedLine = firstIndex + 1;
            breakpoint.SendWarning(new RookError(new Exceptions.RookLineMoved(breakpoint.GetFilename(), breakpoint.GetLineno(), updatedLine)));
            return updatedLine;
        }
        breakpoint.SetError(new RookError(new Exceptions.RookCrcMismatchException(breakpoint.GetFilename(), hashInfo.line_crc, actualCrc)));
        return -1;
    }

    static boolean shouldValidateHash(Breakpoint breakpoint) {
        HashInfo hashInfo = breakpoint.GetHashInfo();
        if (hashInfo == null) {
            return false;
        }
        return hashInfo.file_hash != null || hashInfo.line_crc != null;
    }

    static int GetUpdatedLineNumber(Breakpoint breakpoint, String className, ClassLoader classLoader) {
        className = Utils.GetClassNamePath(className);
        String sourceFileName = className + breakpoint.GetFileExtension();
        InputStream fileContents = null;
        try {
            fileContents = classLoader.getResourceAsStream(sourceFileName);
        }
        catch (Exception e) {
            breakpoint.SendWarning(new RookError(new Exceptions.RookLoadSourceFileException(sourceFileName, e)));
            return breakpoint.GetLineno();
        }
        if (null == fileContents) {
            breakpoint.SendWarning(new RookError(new Exceptions.RookSourceFileNotFound(sourceFileName)));
            return breakpoint.GetLineno();
        }
        FileHashes hashes = null;
        try {
            hashes = HashCheck.getFileHashes(fileContents);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            breakpoint.SendWarning(new RookError(new Exceptions.RookHashCalculationFailed(sourceFileName, className, (Throwable)e)));
            return breakpoint.GetLineno();
        }
        HashInfo hashInfo = breakpoint.GetHashInfo();
        if (hashInfo.line_crc != null) {
            return HashCheck.findLineUsingCrc(breakpoint, hashes);
        }
        if (hashes.file_hash.equals(hashInfo.file_hash)) {
            return breakpoint.GetLineno();
        }
        breakpoint.SetError(new RookError(new Exceptions.RookHashMismatchException(breakpoint.GetFilename(), hashInfo.file_hash, hashes.file_hash)));
        return -1;
    }

    public static class FileHashes {
        public String file_hash;
        public Long[] lines_crcs;

        public FileHashes(String file_hash, Long[] lines_crcs) {
            this.file_hash = file_hash;
            this.lines_crcs = lines_crcs;
        }
    }
}

