/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Operations.Operation;
import com.rookout.rook.Processor.ProcessorFactory;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.UserWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import rook.org.json.JSONArray;
import rook.org.json.JSONObject;

public class Processor {
    private List<Operation> operationList = new ArrayList<Operation>();

    public Processor(JSONArray configuration, ProcessorFactory factory) throws Exceptions.ToolException {
        for (Object rawOperation : configuration) {
            this.operationList.add(factory.getOperation((JSONObject)rawOperation));
        }
    }

    public void Process(Namespace namespace, String reportId) {
        for (Operation operation : this.operationList) {
            try {
                operation.Execute(namespace, reportId);
            }
            catch (Throwable e) {
                String message = "Error in operation";
                RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
                UserWarnings.SendWarning(new RookError(e, message));
                return;
            }
        }
    }
}

