/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Monitor;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class SystemUsageCollector {
    long lastTotalProcessorTime;
    long lastUpTime;
    Thread workerThread = null;
    Usage lastUsage = null;
    OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    Boolean stop = false;
    int availableProcessors;

    public SystemUsageCollector() {
        this.lastTotalProcessorTime = this.operatingSystemMXBean.getProcessCpuTime();
        this.lastUpTime = this.runtimeMXBean.getUptime();
        this.availableProcessors = this.operatingSystemMXBean.getAvailableProcessors();
    }

    public void Stop() {
        if (this.workerThread != null) {
            this.stop = true;
            try {
                this.workerThread.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void Start() {
        if (this.workerThread == null) {
            this.workerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!SystemUsageCollector.this.stop.booleanValue()) {
                            try {
                                SystemUsageCollector.this.CollectData();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Thread.sleep(500L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.workerThread.setDaemon(true);
            this.workerThread.start();
        }
    }

    public Usage GetUsage() {
        return this.lastUsage;
    }

    private void CollectData() {
        long currentUpTime = this.runtimeMXBean.getUptime();
        long currentProcessCpuTime = this.operatingSystemMXBean.getProcessCpuTime();
        long elapsedCpu = currentProcessCpuTime - this.lastTotalProcessorTime;
        long elapsedTime = currentUpTime - this.lastUpTime;
        double cpuUsage = Math.min(99.0f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)this.availableProcessors));
        this.lastUsage = new Usage(cpuUsage, this.operatingSystemMXBean.getCommittedVirtualMemorySize(), this.operatingSystemMXBean.getTotalPhysicalMemorySize(), this.operatingSystemMXBean.getTotalSwapSpaceSize(), this.runtimeMXBean.getStartTime(), this.runtimeMXBean.getUptime());
        this.lastTotalProcessorTime = currentProcessCpuTime;
        this.lastUpTime = currentUpTime;
    }

    public class Usage {
        public double cpu;
        public long virtualMemorySize;
        public long totalPhysicalMemorySize;
        public long totalSwapSpaceSize;
        public long processStartTime;
        public long systemUpTime;

        public Usage(double cpu, long virtualMemorySize, long totalPhysicalMemorySize, long totalSwapSpaceSize, long processStartTime, long systemUpTime) {
            this.cpu = cpu;
            this.virtualMemorySize = virtualMemorySize;
            this.totalPhysicalMemorySize = totalPhysicalMemorySize;
            this.totalSwapSpaceSize = totalSwapSpaceSize;
            this.processStartTime = processStartTime;
            this.systemUpTime = systemUpTime;
        }
    }
}

