/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Operations;

import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Operations.Operation;
import com.rookout.rook.Processor.Paths.Path;
import com.rookout.rook.Processor.ProcessorFactory;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.UserWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import rook.org.json.JSONObject;

public class Set
implements Operation {
    private List<PathPair> pathList;

    public Set(String configuration, ProcessorFactory factory) {
        this(new JSONObject(configuration), factory);
    }

    public Set(JSONObject configuration, ProcessorFactory factory) {
        JSONObject paths = configuration.getJSONObject("paths");
        this.pathList = new ArrayList<PathPair>();
        Iterator<String> keys = paths.keys();
        while (keys.hasNext()) {
            String dest = keys.next();
            Object source = paths.get(dest);
            PathPair pathPair = null;
            try {
                pathPair = new PathPair(factory.getPath(source), factory.getPath(dest));
            }
            catch (Throwable e) {
                String message = "Failed to load dest:source path pair";
                RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
                UserWarnings.SendWarning(new RookError(e, message));
                continue;
            }
            this.pathList.add(pathPair);
        }
    }

    @Override
    public void Execute(Namespace namespace, String reportId) {
        for (PathPair pathPair : this.pathList) {
            try {
                Namespace value = pathPair.source.ReadFrom(namespace);
                if (value instanceof JavaObjectNamespace && ((JavaObjectNamespace)value).IsDefaultDumpConfig()) {
                    ((JavaObjectNamespace)value).objectDumpConfig = JavaObjectNamespace.ObjectDumpConfig.TailorLimits(((JavaObjectNamespace)value).obj);
                }
                pathPair.dest.WriteTo(namespace, value);
            }
            catch (Throwable e) {
                String message = "Failed to execute dest:source path pair";
                RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
                UserWarnings.SendWarning(new RookError(e, message));
            }
        }
    }

    static class PathPair {
        private Path source;
        private Path dest;

        PathPair(Path source, Path dest) {
            this.source = source;
            this.dest = dest;
        }
    }
}

