/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services;

import com.rookout.org.apache.commons.lang3.reflect.MethodUtils;
import com.rookout.rook.Exceptions;
import com.rookout.rook.PlatformUtils;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.StackTrace.StackTrace;
import com.rookout.rook.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class Frame {
    public HashMap<String, Object> locals;
    public StackTrace stackTrace;
    private StackTraceElement baseFrame;
    static final boolean java9OrAbove = PlatformUtils.isJava9OrAbove();
    private static final String jrubySelfLocalName = "$self";
    private static final String jrubyClassLocalName = "$class";
    private static final String jrubyStaticScopeLocalName = "$scope";
    private static final String jrubyDynamicScopeLocalName = "$dynamicScope";
    private static final String jrubyArgsLocalName = "$args";
    private static final String jrubyArgLocalFormat = "$arg%d";
    private static final String jrubyTempVariableRegexFormat = "\\$t_%s_\\d+";

    public Frame(StackTrace stackTrace, HashMap<String, Object> locals) {
        this.stackTrace = stackTrace;
        this.setLocals(locals);
    }

    public Frame(Throwable throwable, HashMap<String, Object> locals) {
        this(new StackTrace(throwable), locals);
    }

    public Frame(HashMap<String, Object> locals) throws Exceptions.RookFailedToCollectStacktrace {
        this.stackTrace = new StackTrace(new Throwable());
        StackTraceElement[] traceback = this.stackTrace.getTraceback();
        for (int i = 0; i < traceback.length - 1; ++i) {
            if (!Frame.isCallbackFrame(traceback[i])) continue;
            this.baseFrame = traceback[i + 1];
            this.stackTrace.setBaseFrameIndex(i + 1);
            if (!Frame.isCallbackFrame(traceback[i + 1])) break;
        }
        this.setLocals(locals);
    }

    private void setLocals(HashMap<String, Object> locals) {
        String fileName = this.getBaseFrame().getFileName();
        if (fileName != null && Utils.IsJRubyFile(fileName).booleanValue()) {
            locals = Frame.parseJRubyLocals(locals);
        }
        this.locals = locals;
    }

    public StackTraceElement getBaseFrame() {
        if (this.baseFrame == null) {
            this.baseFrame = this.stackTrace.getBaseFrame();
        }
        return this.baseFrame;
    }

    public static boolean isCallbackFrame(StackTraceElement frame) {
        if (frame.getClassName().contains("com.rookout.agent.Assertions") && frame.getMethodName().contains("assert")) {
            return true;
        }
        if (java9OrAbove) {
            return frame.getClassName().equals("java.security.AccessController") && frame.getMethodName().equals("doPrivileged");
        }
        return frame.getClassName().equals("com.rookout.agent.StaticCallback") && frame.getMethodName().equals("Callback");
    }

    private static HashMap<String, Object> parseJRubyLocals(HashMap<String, Object> locals) {
        HashMap<String, Object> realLocals = new HashMap<String, Object>();
        if (locals.containsKey(jrubyStaticScopeLocalName)) {
            Object scope = locals.get(jrubyStaticScopeLocalName);
            if (locals.containsKey(jrubyDynamicScopeLocalName)) {
                realLocals.putAll(Frame.getJRubyDynamicScopeLocals(scope, locals.get(jrubyDynamicScopeLocalName)));
            } else {
                realLocals.putAll(Frame.getJRubyArgs(scope, locals));
                realLocals.putAll(Frame.getJRubyTempLocals(scope, locals));
            }
        }
        if (locals.containsKey(jrubySelfLocalName)) {
            Object self = locals.get(jrubySelfLocalName);
            realLocals.put("self", self);
        }
        return realLocals;
    }

    private static HashMap<String, Object> getJRubyInstanceVariables(Object staticScope, Object self, HashMap<String, Object> locals) {
        HashMap<String, Object> realLocals = new HashMap<String, Object>();
        if (locals.containsKey(jrubyClassLocalName)) {
            Object rubyClass = locals.get(jrubyClassLocalName);
            try {
                ArrayList instanceVariableNames = (ArrayList)MethodUtils.invokeMethod(staticScope, "getInstanceVariableNames", new Object[0]);
                Object varTableManager = MethodUtils.invokeMethod(rubyClass, "getVariableTableManager", new Object[0]);
                for (String instanceVarName : instanceVariableNames) {
                    try {
                        Object variableAccessor = MethodUtils.invokeMethod(varTableManager, "getVariableAccessorForRead", instanceVarName);
                        Object variable = MethodUtils.invokeMethod(variableAccessor, "get", new Object[]{self}, new Class[]{Object.class});
                        realLocals.put(instanceVarName, variable);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        RookLogger.Instance().warn("Unable to get instance variable (" + instanceVarName + "): " + e, new Object[0]);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                RookLogger.Instance().warn("Unable to get instance variables: " + e, new Object[0]);
            }
        }
        return realLocals;
    }

    private static HashMap<String, Object> getJRubyDynamicScopeLocals(Object staticScope, Object dynamicScope) {
        HashMap<String, Object> locals = new HashMap<String, Object>();
        try {
            Object irScope = MethodUtils.invokeMethod(staticScope, "getIRScope", new Object[0]);
            HashMap localVariables = (HashMap)MethodUtils.invokeMethod(irScope, "getLocalVariables", new Object[0]);
            Iterator iterator = localVariables.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entryObject;
                Map.Entry entry = entryObject = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                int offset = (Integer)MethodUtils.invokeMethod(value, "getOffset", new Object[0]);
                int scopeDepth = (Integer)MethodUtils.invokeMethod(value, "getScopeDepth", new Object[0]);
                locals.put((String)MethodUtils.invokeMethod(key, "idString", new Object[0]), MethodUtils.invokeMethod(dynamicScope, "getValue", offset, scopeDepth));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RookLogger.Instance().warn("Failed to get dynamic scope locals: " + e, new Object[0]);
        }
        return locals;
    }

    private static HashMap<String, Object> getJRubyTempLocals(Object staticScope, HashMap<String, Object> locals) {
        HashMap<String, Object> realLocals = new HashMap<String, Object>();
        try {
            String[] variables;
            for (String variableName : variables = (String[])MethodUtils.invokeMethod(staticScope, "getVariables", new Object[0])) {
                for (String localName : locals.keySet()) {
                    if (!localName.matches(String.format(jrubyTempVariableRegexFormat, variableName))) continue;
                    realLocals.put(variableName, locals.get(localName));
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RookLogger.Instance().warn("Failed to get temp variables: " + e, new Object[0]);
        }
        return realLocals;
    }

    private static HashMap<String, Object> getJRubyArgs(Object staticScope, HashMap<String, Object> locals) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            Object signature = MethodUtils.invokeMethod(staticScope, "getSignature", new Object[0]);
            if (signature == null) {
                return args;
            }
            int required = (Integer)MethodUtils.invokeMethod(signature, "required", new Object[0]);
            int opt = (Integer)MethodUtils.invokeMethod(signature, "opt", new Object[0]);
            boolean hasRest = (Boolean)MethodUtils.invokeMethod(signature, "hasRest", new Object[0]);
            boolean hasKwargsRest = (Boolean)MethodUtils.invokeMethod(signature, "restKwargs", new Object[0]);
            int keyRest = (Integer)MethodUtils.invokeMethod(signature, "keyRest", new Object[0]);
            String[] variables = (String[])MethodUtils.invokeMethod(staticScope, "getVariables", new Object[0]);
            int argIndex = 0;
            for (int i = 0; i < required + opt; ++i) {
                String argName = variables[i];
                Frame.tryAddJRubyArg(argIndex, argName, locals, args);
                ++argIndex;
            }
            if (hasRest) {
                try {
                    String restName = variables[argIndex];
                    args.put(restName, Frame.getJRubyRestArg(required, opt, hasKwargsRest, locals));
                }
                catch (Exceptions.RookJRubyArgNotFound e) {
                    RookLogger.Instance().warn(e.toString(), new Object[0]);
                }
            }
            if (hasKwargsRest) {
                try {
                    String kwargsName = variables[keyRest];
                    args.put(kwargsName, Frame.getJRubyKwargs(locals));
                }
                catch (Exceptions.RookJRubyArgNotFound e) {
                    RookLogger.Instance().warn(e.toString(), new Object[0]);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RookLogger.Instance().warn("Unable to get args: " + e, new Object[0]);
        }
        return args;
    }

    private static Object getJRubyRestArg(int required, int opt, boolean hasKwargsRest, HashMap<String, Object> locals) throws Exceptions.RookJRubyArgNotFound {
        if (locals.containsKey(jrubyArgsLocalName)) {
            Object[] args = (Object[])locals.get(jrubyArgsLocalName);
            int startIndex = required + opt;
            int endIndex = args.length;
            if (hasKwargsRest) {
                --endIndex;
            }
            Object[] rest = new Object[endIndex - startIndex];
            for (int i = startIndex; i < endIndex; ++i) {
                rest[i - startIndex] = args[startIndex];
            }
            return rest;
        }
        throw new Exceptions.RookJRubyArgNotFound("rest");
    }

    private static Object getJRubyKwargs(HashMap<String, Object> locals) throws Exceptions.RookJRubyArgNotFound {
        if (locals.containsKey(jrubyArgsLocalName)) {
            Object[] args = (Object[])locals.get(jrubyArgsLocalName);
            return args[args.length - 1];
        }
        throw new Exceptions.RookJRubyArgNotFound("kwargs");
    }

    private static void tryAddJRubyArg(int index, String name, HashMap<String, Object> locals, HashMap<String, Object> args) {
        try {
            args.put(name, Frame.getJRubyArg(index, locals));
        }
        catch (Exceptions.RookJRubyArgNotFound e) {
            RookLogger.Instance().debug("Unable to find arg %s [%d]\n", name, index);
        }
    }

    private static Object getJRubyArg(int index, HashMap<String, Object> locals) throws Exceptions.RookJRubyArgNotFound {
        if (locals.containsKey(jrubyArgsLocalName)) {
            return ((Object[])locals.get(jrubyArgsLocalName))[index];
        }
        for (String localName : locals.keySet()) {
            if (!Objects.equals(String.format(jrubyArgLocalFormat, index), localName)) continue;
            return locals.get(localName);
        }
        throw new Exceptions.RookJRubyArgNotFound(index);
    }
}

