/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.org.apache.commons.lang3.reflect.MethodUtils;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Services.AccessModifier.AccessModifier;
import com.rookout.rook.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class JavaObjectNamespace
extends Namespace {
    public Object obj;
    public ObjectDumpConfig objectDumpConfig;

    public JavaObjectNamespace(Object obj) {
        this.obj = obj;
        if (obj instanceof ThreadLocal) {
            this.obj = ((ThreadLocal)obj).get();
        }
        if (obj != null && obj.getClass().getName().equals("scala.Some")) {
            try {
                this.obj = MethodUtils.invokeMethod(obj, "get", new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.objectDumpConfig = ObjectDumpConfig.GetDefaultDumpConfig();
    }

    public JavaObjectNamespace(Object obj, ObjectDumpConfig objectDumpConfig) {
        this.obj = obj;
        this.objectDumpConfig = objectDumpConfig;
    }

    private int getScalaCollectionSize() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        boolean isTuple = this.obj.getClass().getName().startsWith("scala.Tuple");
        String sizeMethod = isTuple ? "productArity" : "size";
        return (Integer)MethodUtils.invokeMethod(this.obj, sizeMethod, new Object[0]);
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "type": {
                if (null != this.obj) {
                    return new JavaObjectNamespace(this.obj.getClass().toString());
                }
                throw new Exceptions.RookInvalidObjectForAccess(null, "type()");
            }
            case "size": {
                if (null != this.obj) {
                    if (this.obj.getClass().isArray()) {
                        return new JavaObjectNamespace(Array.getLength(this.obj));
                    }
                    if (this.obj instanceof Collection) {
                        return new JavaObjectNamespace(((Collection)this.obj).size());
                    }
                    if (this.obj instanceof Map) {
                        return new JavaObjectNamespace(((Map)this.obj).size());
                    }
                    if (this.obj instanceof String) {
                        return new JavaObjectNamespace(((String)this.obj).length());
                    }
                    if (this.obj.getClass().getName().startsWith("scala.")) {
                        try {
                            return new JavaObjectNamespace(this.getScalaCollectionSize());
                        }
                        catch (Exception ignored) {
                            throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "size()");
                        }
                    }
                    throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "size()");
                }
                throw new Exceptions.RookInvalidObjectForAccess(null, "size()");
            }
            case "depth": {
                try {
                    this.objectDumpConfig.max_depth = Integer.parseInt(args);
                }
                catch (NumberFormatException ex) {
                    throw new Exceptions.RookInvalidMethodArguments("depth()", args);
                }
                return this;
            }
            case "width": {
                try {
                    this.objectDumpConfig.max_width = Integer.parseInt(args);
                }
                catch (NumberFormatException ex) {
                    throw new Exceptions.RookInvalidMethodArguments("width()", args);
                }
                return this;
            }
            case "collection_dump": {
                try {
                    this.objectDumpConfig.max_collection_depth = Integer.parseInt(args);
                }
                catch (NumberFormatException ex) {
                    throw new Exceptions.RookInvalidMethodArguments("collection_dump()", args);
                }
                return this;
            }
            case "string": {
                try {
                    this.objectDumpConfig.max_string = Integer.parseInt(args);
                }
                catch (NumberFormatException ex) {
                    throw new Exceptions.RookInvalidMethodArguments("string()", args);
                }
                return this;
            }
            case "limit": {
                this.objectDumpConfig = ObjectDumpConfig.GetObjectDumpConfig(args.toLowerCase());
                if (this.objectDumpConfig == null) {
                    throw new Exceptions.RookInvalidMethodArguments("limit()", args);
                }
                return this;
            }
        }
        return super.CallMethod(name, args);
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        Field field = null;
        if (this.obj == null) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
        Class<?> cls = this.obj instanceof Class ? (Class<?>)this.obj : this.obj.getClass();
        while (true) {
            try {
                field = cls.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                if (null != (cls = cls.getSuperclass())) continue;
            }
            break;
        }
        if (field == null) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
        if (!AccessModifier.setAccessible(field, this.obj, this.obj.getClass())) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
        try {
            return new JavaObjectNamespace(field.get(this.obj));
        }
        catch (Throwable e) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
    }

    private static boolean DoesObjectSuperClassContain(Object object, String superClass) {
        for (Class<?> c = object.getClass(); c != null; c = c.getSuperclass()) {
            if (!c.getName().contains(superClass)) continue;
            return true;
        }
        return false;
    }

    private Namespace ReadScalaKey(Object key) throws Exceptions.ToolException {
        boolean isTuple = this.obj.getClass().getName().startsWith("scala.Tuple");
        if (isTuple || Utils.IsObjectSubClassOf(this.obj, "scala.collection.AbstractSeq") || JavaObjectNamespace.DoesObjectSuperClassContain(this.obj, "Seq")) {
            Object object;
            int objSize;
            String getMethod;
            String string = getMethod = isTuple ? "productElement" : "apply";
            if (!(key instanceof Integer)) {
                throw new Exceptions.RookInvalidKeyType(key, "Integer");
            }
            try {
                objSize = this.getScalaCollectionSize();
            }
            catch (Exception ignored) {
                throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "ReadKey");
            }
            if ((Integer)key >= objSize) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            try {
                object = MethodUtils.invokeMethod(this.obj, getMethod, key);
            }
            catch (Exception e) {
                throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "ReadKey");
            }
            return new JavaObjectNamespace(object);
        }
        if (Utils.IsObjectSubClassOf(this.obj, "scala.collection.AbstractMap") || JavaObjectNamespace.DoesObjectSuperClassContain(this.obj, "Map")) {
            Object object;
            boolean contains;
            try {
                contains = (Boolean)MethodUtils.invokeMethod(this.obj, "contains", key);
            }
            catch (Exception e) {
                throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "ReadKey");
            }
            if (!contains) {
                boolean keyFound = false;
                if (key instanceof String) {
                    try {
                        Object keysIterator = MethodUtils.invokeMethod(this.obj, "keysIterator", new Object[0]);
                        while (((Boolean)MethodUtils.invokeMethod(keysIterator, "hasNext", new Object[0])).booleanValue()) {
                            Object nextKey = MethodUtils.invokeMethod(keysIterator, "next", new Object[0]);
                            if (!nextKey.toString().equals(key)) continue;
                            key = nextKey;
                            keyFound = true;
                            break;
                        }
                    }
                    catch (Exception keysIterator) {
                        // empty catch block
                    }
                }
                if (!keyFound) {
                    throw new Exceptions.RookKeyNotFound(key);
                }
            }
            try {
                object = MethodUtils.invokeMethod(this.obj, "get", key);
            }
            catch (Exception e) {
                throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "ReadKey");
            }
            return new JavaObjectNamespace(object);
        }
        throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "ReadKey");
    }

    @Override
    public Namespace ReadKey(Object key) throws Exceptions.ToolException {
        if (this.obj == null) {
            throw new Exceptions.RookObjectIsNull(key);
        }
        if (this.obj.getClass().getName().startsWith("scala.")) {
            return this.ReadScalaKey(key);
        }
        if (this.obj.getClass().isArray()) {
            if (!(key instanceof Integer)) {
                throw new Exceptions.RookInvalidKeyType(key, "Integer");
            }
            int index = (Integer)key;
            if (index >= Array.getLength(this.obj)) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(Array.get(this.obj, index));
        }
        if (this.obj instanceof List) {
            List listObj = (List)this.obj;
            if (!(key instanceof Integer)) {
                throw new Exceptions.RookInvalidKeyType(key, "Integer");
            }
            int index = (Integer)key;
            if (index >= listObj.size()) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(listObj.get(index));
        }
        if (this.obj instanceof Map) {
            Map mapObj = (Map)this.obj;
            Object keyFound = null;
            if (mapObj.containsKey(key)) {
                keyFound = key;
            } else if (key instanceof String) {
                for (Object keyIterator : mapObj.keySet()) {
                    if (!keyIterator.toString().equals(key)) continue;
                    keyFound = keyIterator;
                    break;
                }
            }
            if (null != keyFound) {
                return new JavaObjectNamespace(mapObj.get(keyFound));
            }
            throw new Exceptions.RookKeyNotFound(key);
        }
        if (this.obj instanceof String) {
            String string = (String)this.obj;
            if (!(key instanceof Integer)) {
                throw new Exceptions.RookInvalidKeyType(key, "Integer");
            }
            int index = (Integer)key;
            if (index >= string.length()) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(Character.valueOf(string.charAt(index)));
        }
        throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "ReadKey");
    }

    public boolean IsDefaultDumpConfig() {
        return this.objectDumpConfig.max_depth == ObjectDumpConfig.DEFAULT_MAX_DEPTH.get() && this.objectDumpConfig.max_width == 15 && this.objectDumpConfig.max_collection_depth == ObjectDumpConfig.DEFAULT_MAX_COLLECTION_DEPTH.get() && this.objectDumpConfig.max_string == 512;
    }

    public static class ObjectDumpConfig {
        public static final int STRICT_MAX_DEPTH = 2;
        public static final int STRICT_MAX_WIDTH = 10;
        public static final int STRICT_MAX_COLLECTION_DEPTH = 2;
        public static final int STRICT_MAX_STRING = 128;
        public static AtomicInteger DEFAULT_MAX_DEPTH = new AtomicInteger(4);
        public static final int DEFAULT_MAX_WIDTH = 15;
        public static final AtomicInteger DEFAULT_MAX_COLLECTION_DEPTH = new AtomicInteger(4);
        public static final int DEFAULT_MAX_STRING = 512;
        public static AtomicInteger TOLERANT_MAX_DEPTH = new AtomicInteger(5);
        public static final int TOLERANT_MAX_WIDTH = 25;
        public static final AtomicInteger TOLERANT_MAX_COLLECTION_DEPTH = new AtomicInteger(5);
        public static final int TOLERANT_MAX_STRING = 4096;
        public static final int UNLIMITED_MAX_STRING = 65536;
        public static final int UNLIMITED_MAX_COLLECTION_WIDTH = 100;
        static final Map<String, Callable> dumpConfigs;
        public int max_depth;
        public int max_width;
        public int max_collection_depth;
        public int max_string;
        public boolean skip_stacktrace = false;

        public static ObjectDumpConfig GetObjectDumpConfig(String key) {
            return dumpConfigs.get(key).call();
        }

        public ObjectDumpConfig(int max_depth, int max_width, int max_collection_depth, int max_string) {
            this.max_depth = max_depth;
            this.max_width = max_width;
            this.max_collection_depth = max_collection_depth;
            this.max_string = max_string;
        }

        public static ObjectDumpConfig GetStrictDumpConfig() {
            return new ObjectDumpConfig(2, 10, 2, 128);
        }

        public static ObjectDumpConfig GetDefaultDumpConfig() {
            return new ObjectDumpConfig(DEFAULT_MAX_DEPTH.get(), 15, DEFAULT_MAX_COLLECTION_DEPTH.get(), 512);
        }

        public static ObjectDumpConfig GetTolerantDumpConfig() {
            return new ObjectDumpConfig(TOLERANT_MAX_DEPTH.get(), 25, TOLERANT_MAX_COLLECTION_DEPTH.get(), 4096);
        }

        public static ObjectDumpConfig TailorLimits(Object object) {
            if (object instanceof String) {
                return new ObjectDumpConfig(1, 0, 0, 65536);
            }
            if (object instanceof Collection && ((Collection)object).size() > 25 || object instanceof Map && ((Map)object).size() > 25) {
                return new ObjectDumpConfig(DEFAULT_MAX_DEPTH.get(), 100, DEFAULT_MAX_COLLECTION_DEPTH.get(), 512);
            }
            return ObjectDumpConfig.GetTolerantDumpConfig();
        }

        static {
            HashMap<String, Callable> modifiableMap = new HashMap<String, Callable>();
            modifiableMap.put("strict", new Callable(){

                @Override
                public ObjectDumpConfig call() {
                    return ObjectDumpConfig.GetStrictDumpConfig();
                }
            });
            modifiableMap.put("default", new Callable(){

                @Override
                public ObjectDumpConfig call() {
                    return ObjectDumpConfig.GetDefaultDumpConfig();
                }
            });
            modifiableMap.put("tolerant", new Callable(){

                @Override
                public ObjectDumpConfig call() {
                    return ObjectDumpConfig.GetTolerantDumpConfig();
                }
            });
            dumpConfigs = Collections.unmodifiableMap(modifiableMap);
        }

        public static interface Callable {
            public ObjectDumpConfig call();
        }
    }
}

