/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Utils;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import rook.com.google.common.collect.BiMap;
import rook.com.google.common.collect.HashBiMap;

public class Files {
    private final WeakHashMap<ClassLoader, HashSet<ClassObject>> classLoaderToObject = new WeakHashMap();
    FileMapping fileMapping = new FileMapping();
    FilePathMapping filePathMapping = new FilePathMapping();
    private static StringMapping stringMapping = new StringMapping();
    private static final int NO_PREFIX_FOUND = 0;

    public synchronized ClassObject AddClass(ClassLoader classLoader, String fileName, String className) {
        Set classSet;
        int fileNameHash = 0;
        if (Utils.IsClojureFile(fileName).booleanValue()) {
            classSet = (Set)this.filePathMapping.get(fileName);
        } else {
            fileNameHash = this.getFileNameHash(fileName);
            classSet = (Set)this.fileMapping.get(fileNameHash);
        }
        if (null == classSet) {
            classSet = Collections.newSetFromMap(new WeakHashMap());
            if (fileNameHash == 0) {
                this.filePathMapping.put(fileName, classSet);
            } else {
                this.fileMapping.put(fileNameHash, classSet);
            }
        }
        ClassObject classObject = new ClassObject(classLoader, className);
        classSet.add(classObject);
        HashSet<ClassObject> objects = this.classLoaderToObject.get(classLoader);
        if (objects == null) {
            objects = new HashSet();
        }
        objects.add(classObject);
        this.classLoaderToObject.put(classLoader, objects);
        return classObject;
    }

    public synchronized Set<ClassObject> GetClasses(String fileName) {
        if (Utils.IsClojureFile(fileName).booleanValue()) {
            if (this.filePathMapping.containsKey(fileName)) {
                return new HashSet<ClassObject>((Collection)this.filePathMapping.get(fileName));
            }
            for (Map.Entry entry : this.filePathMapping.entrySet()) {
                String classFilePath = (String)entry.getKey();
                if (!fileName.endsWith(classFilePath)) continue;
                return new HashSet<ClassObject>((Collection)entry.getValue());
            }
        } else {
            int fileNameHash = this.getFileNameHash(fileName);
            if (this.fileMapping.containsKey(fileNameHash)) {
                return new HashSet<ClassObject>((Collection)this.fileMapping.get(fileNameHash));
            }
        }
        return new HashSet<ClassObject>();
    }

    private int getFileNameHash(String fileName) {
        return fileName.toLowerCase().hashCode();
    }

    private static class StringMapping {
        private BiMap<ByteBuffer, Integer> mapping = HashBiMap.create();
        private AtomicInteger currentIndex = new AtomicInteger(1);

        StringMapping() {
        }

        int putStringAndGetId(String packageName) {
            ByteBuffer packageNameAsBuffer = ByteBuffer.wrap(packageName.getBytes(StandardCharsets.UTF_8));
            Integer prefixIdFromMap = (Integer)this.mapping.get(packageNameAsBuffer);
            if (prefixIdFromMap == null) {
                prefixIdFromMap = this.currentIndex.getAndIncrement();
                this.mapping.put(packageNameAsBuffer, prefixIdFromMap);
            }
            return prefixIdFromMap;
        }

        String getString(int prefixId) {
            return new String(((ByteBuffer)this.mapping.inverse().get(prefixId)).array(), StandardCharsets.UTF_8);
        }
    }

    static class FilePathMapping
    extends HashMap<String, Set<ClassObject>> {
        FilePathMapping() {
        }
    }

    static class FileMapping
    extends HashMap<Integer, Set<ClassObject>> {
        FileMapping() {
        }
    }

    public static class ClassObject {
        private final WeakReference<ClassLoader> classLoader;
        private final int prefixId;
        private final int classNameId;
        private final int classLoaderId;

        ClassObject(ClassLoader classLoader, String className) {
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            int baseClassNameIndex = className.lastIndexOf(47);
            if (baseClassNameIndex == -1) {
                baseClassNameIndex = 0;
                this.prefixId = 0;
            } else {
                String packageName = className.substring(0, baseClassNameIndex);
                this.prefixId = stringMapping.putStringAndGetId(packageName);
            }
            className = className.substring(baseClassNameIndex);
            this.classNameId = stringMapping.putStringAndGetId(className);
            this.classLoaderId = classLoader.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassObject)) {
                return false;
            }
            ClassObject other = (ClassObject)obj;
            return this.classLoaderId == other.classLoaderId && this.prefixId == other.prefixId && this.classNameId == other.classNameId;
        }

        public int hashCode() {
            return Objects.hash(this.classLoaderId, this.prefixId, this.classNameId);
        }

        public String getClassName() {
            String decodedBaseClassName = stringMapping.getString(this.classNameId);
            if (this.prefixId == 0) {
                return decodedBaseClassName;
            }
            return stringMapping.getString(this.prefixId) + decodedBaseClassName;
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)this.classLoader.get();
        }
    }
}

