/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Services.Instrumentation.AssertInsnHookInfo;
import com.rookout.rook.Services.Instrumentation.BaseVisitor;
import com.rookout.rook.Services.Instrumentation.CollectionNodesMap;
import com.rookout.rook.Services.Instrumentation.InstrumentationService;
import com.rookout.rook.Services.Instrumentation.LocalVariableInfo;
import com.rookout.rook.Services.Instrumentation.VisitorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import rook.org.objectweb.asm.AnnotationVisitor;
import rook.org.objectweb.asm.ClassVisitor;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.AbstractInsnNode;
import rook.org.objectweb.asm.tree.InsnList;
import rook.org.objectweb.asm.tree.InsnNode;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.MethodNode;
import rook.org.objectweb.asm.tree.TypeInsnNode;

public class TestsVisitor
extends BaseVisitor {
    private boolean isHooked = false;
    Type superType = null;
    ArrayList<AssertInsnHookInfo> hookInfos = new ArrayList();
    static List<String> testClassesToHook = new ArrayList<String>();

    public static void AddTestToHook(HashMap<String, Object> locals) {
        String classPath = "";
        Class testClass = null;
        try {
            classPath = (String)locals.get("testClassName");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            testClass = (Class)locals.get("testClass");
            classPath = testClass.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            testClass = (Class)locals.get("testClass");
            classPath = testClass.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        classPath = classPath.replace(".", "/");
        testClassesToHook.add(classPath);
        if (testClass != null) {
            InstrumentationService.instance.ReloadClass(testClass);
        }
    }

    public static boolean ShouldHook(String className) {
        return testClassesToHook.contains(className);
    }

    TestsVisitor(String className, ClassLoader classLoader, ClassVisitor augVisitor) {
        super(589824, classLoader, className, augVisitor);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superType = superName == null ? null : Type.getObjectType(superName);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        final MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodNode(327680, access, name, descriptor, signature, exceptions){
            private boolean shouldHook;
            {
                super(x0, x1, x2, x3, x4, x5);
                this.shouldHook = false;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (descriptor.equals("Lorg/junit/Test;") || descriptor.equals("Lorg/junit/jupiter/api/Test;")) {
                    this.shouldHook = true;
                }
                return super.visitAnnotation(descriptor, visible);
            }

            private boolean shouldHookMethod(String name, String owner) {
                return name.contains("assert") && !name.contains("Throws") && !name.contains("assertAll") && !name.contains("assertTimeout") && !name.contains("assertTimeoutPreemptively") && (owner.equals("org/junit/Assert") || owner.equals("org/junit/jupiter/api/Assertions"));
            }

            @Override
            public void visitMethodInsn(int opcodeAndSource, String owner, String name, String descriptor, boolean isInterface) {
                if (!this.shouldHook) {
                    super.visitMethodInsn(opcodeAndSource, owner, name, descriptor, isInterface);
                    return;
                }
                Type[] argumentTypes = Type.getArgumentTypes(descriptor);
                Type[] callbackArgumentsTypes = new Type[argumentTypes.length + 1];
                System.arraycopy(argumentTypes, 0, callbackArgumentsTypes, 0, argumentTypes.length);
                callbackArgumentsTypes[argumentTypes.length] = Type.getType(HashMap.class);
                String CallbackDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, callbackArgumentsTypes);
                if (this.shouldHookMethod(name, owner)) {
                    super.visitMethodInsn(184, "com/rookout/agent/Assertions", name, CallbackDescriptor, false);
                    AssertInsnHookInfo hookInfo = new AssertInsnHookInfo();
                    hookInfo.assertInsn = this.instructions.getLast();
                    hookInfo.preAssertInsn = this.instructions.get(this.instructions.size() - 2);
                    TestsVisitor.this.hookInfos.add(hookInfo);
                } else {
                    super.visitMethodInsn(opcodeAndSource, owner, name, descriptor, isInterface);
                }
            }

            private InsnList BuildHook(AbstractInsnNode assertInsn) {
                InsnList hook = new InsnList();
                hook.add(new TypeInsnNode(187, Type.getInternalName(HashMap.class)));
                hook.add(new InsnNode(89));
                hook.add(new MethodInsnNode(183, Type.getInternalName(HashMap.class), "<init>", "()V", false));
                LocalVariableInfo[] variables = new LocalVariableInfo[this.maxLocals];
                for (int i = 0; i < variables.length; ++i) {
                    variables[i] = new LocalVariableInfo();
                }
                VisitorUtils.LoadArguments(variables, this.name, this.desc, this.access);
                this.ScanMethod(assertInsn, variables);
                CollectionNodesMap newCollectionNodes = VisitorUtils.CollectVariables(variables, hook, false);
                return hook;
            }

            private void ScanMethod(AbstractInsnNode assertInsn, LocalVariableInfo[] variables) {
                AbstractInsnNode insnIterator;
                Iterator it = this.instructions.iterator();
                while (it.hasNext() && (insnIterator = (AbstractInsnNode)it.next()) != assertInsn) {
                    VisitorUtils.ParseVariblesFromNodes(insnIterator, variables, this.localVariables, this.name, TestsVisitor.this.superType);
                }
            }

            @Override
            public void visitEnd() {
                if (!this.shouldHook) {
                    super.visitEnd();
                    this.accept(methodVisitor);
                    return;
                }
                for (AssertInsnHookInfo hookInfo : TestsVisitor.this.hookInfos) {
                    InsnList hook = this.BuildHook(hookInfo.assertInsn);
                    this.instructions.insert(hookInfo.preAssertInsn, hook);
                }
                this.maxStack += 6;
                TestsVisitor.this.verify(this);
                TestsVisitor.this.isHooked = true;
                super.visitEnd();
                this.accept(methodVisitor);
            }
        };
    }

    @Override
    boolean isHooked() {
        return this.isHooked;
    }
}

