/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.javarook.protobuf.Messages;
import com.rookout.rook.AugManager;
import com.rookout.rook.ComWs.AgentComWs;
import com.rookout.rook.Config;
import com.rookout.rook.RookLogger;
import java.util.HashMap;
import java.util.logging.Level;
import rook.com.google.protobuf.Any;
import rook.com.google.protobuf.InvalidProtocolBufferException;
import rook.org.json.JSONObject;

public class CommandHandler {
    private AgentComWs agentCom;
    private AugManager augManager;

    public CommandHandler(AgentComWs agentCom, final AugManager augManager) {
        this.agentCom = agentCom;
        this.augManager = augManager;
        this.agentCom.on("InitialAugsCommand", new AgentComWs.Callable(){

            @Override
            public void call(Any any) {
                try {
                    HashMap<String, JSONObject> augs = new HashMap<String, JSONObject>();
                    Messages.InitialAugsCommand initialAugsCommand = Messages.InitialAugsCommand.parseFrom(any.getValue());
                    Config.UpdateConfig(initialAugsCommand.getSdkConfigurationMap());
                    for (String aug : initialAugsCommand.getAugsList()) {
                        JSONObject augConfig = new JSONObject(aug);
                        String augId = augConfig.getString("id");
                        augs.put(augId, augConfig);
                    }
                    augManager.InitializeAugs(augs);
                }
                catch (InvalidProtocolBufferException exc) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to create message", exc, new Object[0]);
                }
            }
        });
        this.agentCom.on("RemoveAugCommand", new AgentComWs.Callable(){

            @Override
            public void call(Any any) {
                try {
                    Messages.RemoveAugCommand removeAugCommand = Messages.RemoveAugCommand.parseFrom(any.getValue());
                    augManager.RemoveAug(removeAugCommand.getAugId());
                }
                catch (InvalidProtocolBufferException exc) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to create message", exc, new Object[0]);
                }
            }
        });
        this.agentCom.on("AddAugCommand", new AgentComWs.Callable(){

            @Override
            public void call(Any any) {
                try {
                    Messages.AddAugCommand addAugCommand = Messages.AddAugCommand.parseFrom(any.getValue());
                    augManager.AddAug(new JSONObject(addAugCommand.getAugJson()));
                }
                catch (InvalidProtocolBufferException exc) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to create message", exc, new Object[0]);
                }
            }
        });
    }
}

