/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.javarook.protobuf.AgentInfo;
import com.rookout.javarook.protobuf.EnvelopeOuterClass;
import com.rookout.javarook.protobuf.Messages;
import com.rookout.rook.ComWs.AgentComWs;
import com.rookout.rook.ComWs.ComUtils;
import com.rookout.rook.ComWs.EnvelopeWrapper;
import com.rookout.rook.ComWs.Information;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.rookout.java_websocket.client.WebSocketClient;
import org.rookout.java_websocket.handshake.ServerHandshake;
import rook.com.google.protobuf.Any;
import rook.com.google.protobuf.InvalidProtocolBufferException;

public class RookoutWebSocketClient {
    private RookLogger logger;
    private Config config;
    private AgentComWs agentCom;
    private URI agentUri;
    private Information agentInfo;
    private CountDownLatch gotInitialAugs;
    private int httpStatusCodeIfError;
    private WebSocketClient client;
    private boolean usedOnce;

    RookoutWebSocketClient(URI agentUri, String token, AgentComWs agentCom, Information agentInfo, SocketFactory socketFactory) throws GeneralSecurityException, IOException {
        this.agentUri = agentUri;
        this.logger = RookLogger.Instance();
        this.config = Config.Instance();
        this.agentCom = agentCom;
        this.agentInfo = agentInfo;
        this.gotInitialAugs = new CountDownLatch(1);
        this.httpStatusCodeIfError = 0;
        this.usedOnce = false;
        final RookoutWebSocketClient self = this;
        this.client = new WebSocketClient(agentUri, this.config.AgentCom$CONNECTION_TIMEOUT * 1000, 1, 1){

            @Override
            public void onOpen(ServerHandshake handshakedata) {
            }

            @Override
            public void onMessage(String message) {
                self.logger.warn("Got string message - unexpected", new Object[0]);
            }

            @Override
            public void onMessage(ByteBuffer message) {
                try {
                    EnvelopeOuterClass.Envelope envelope = EnvelopeOuterClass.Envelope.parseFrom(message);
                    Any msg = envelope.getMsg();
                    if (msg.is(Messages.InitialAugsCommand.class)) {
                        RookLogger.Instance().debug("Finished initialization", new Object[0]);
                        self.gotInitialAugs.countDown();
                    }
                    self.agentCom.handleIncomingMessage(envelope.getMsg());
                }
                catch (InvalidProtocolBufferException e) {
                    self.logger.warn("Got invalid message", new Object[0]);
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (reason != null && reason.startsWith("Invalid status code received: 403")) {
                    self.httpStatusCodeIfError = 403;
                } else if (reason != null && reason.contains("400")) {
                    self.httpStatusCodeIfError = 400;
                } else {
                    self.logger.warn("Unexpected websocket close, code: " + code, new Object[0]);
                }
            }

            @Override
            public void onError(Exception ex) {
                self.logger.warn("WebSocket error: %s: %s", ex.getClass().getName(), ex.getMessage());
                this.close();
            }
        };
        this.client.setConnectionLostTimeout(this.config.AgentCom$PING_TIMEOUT / 1000);
        this.client.addHeader("User-Agent", String.format("RookoutAgent/%s+%s", Config.Instance().VersionConfiguration$VERSION, Config.Instance().VersionConfiguration$COMMIT));
        if (token != null) {
            this.client.addHeader("X-Rookout-Token", token);
        }
        if (socketFactory != null) {
            this.client.setSocketFactory(socketFactory);
        } else {
            String scheme = agentUri.getScheme();
            if (scheme.equals("wss")) {
                this.client.setSocketFactory(ComUtils.CreateSslSocketFactory());
            }
        }
    }

    public boolean isOpen() {
        return this.client.isOpen();
    }

    public void send(byte[] buf) throws InterruptedException {
        this.client.send(buf);
    }

    public void close() {
        this.client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConnectionAttempt() throws Exceptions.RookInvalidToken, Exceptions.RookWebSocketError, IOException, InterruptedException {
        boolean useReconnect = false;
        RookoutWebSocketClient rookoutWebSocketClient = this;
        synchronized (rookoutWebSocketClient) {
            if (this.usedOnce) {
                useReconnect = true;
            }
            this.usedOnce = true;
        }
        this.gotInitialAugs = new CountDownLatch(1);
        this.httpStatusCodeIfError = 0;
        this.logger.info("Connecting to %s", this.agentUri);
        try {
            boolean connectResult = false;
            connectResult = useReconnect ? this.client.reconnectBlocking() : this.client.connectBlocking();
            if (!connectResult) {
                if (this.httpStatusCodeIfError == 403) {
                    Exceptions.RookInvalidToken rookInvalidToken = new Exceptions.RookInvalidToken();
                    this.logger.warn(rookInvalidToken.getMessage(), new Object[0]);
                    throw rookInvalidToken;
                }
                if (this.httpStatusCodeIfError == 400) {
                    throw new Exceptions.RookWebSocketError(400);
                }
                throw new IOException("Failed to connect to the controller. Will keep trying");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (!this.doHandshake()) {
            try {
                this.client.closeBlocking();
            }
            catch (InterruptedException e) {
                return;
            }
            throw new IOException("Failed to connect to the controller. Will keep trying");
        }
    }

    private Messages.NewAgentMessage getRegistrationMessage(Information agentInfo) {
        AgentInfo.AgentInformation packedInfo = Information.PackAgentInfo(agentInfo);
        Messages.NewAgentMessage.Builder m = Messages.NewAgentMessage.newBuilder();
        m.setAgentInfo(packedInfo);
        return m.build();
    }

    private boolean doHandshake() throws InterruptedException {
        this.client.send(EnvelopeWrapper.envelope(this.getRegistrationMessage(this.agentInfo)).toByteArray());
        return this.gotInitialAugs.await(this.config.AgentCom$CONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS);
    }
}

