/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor;

import com.rookout.javarook.protobuf.Variant2OuterClass;
import com.rookout.javarook.protobuf.VariantOuterClass;
import com.rookout.org.apache.commons.lang3.ArrayUtils;
import com.rookout.org.apache.commons.lang3.reflect.MethodUtils;
import com.rookout.rook.Blacklist;
import com.rookout.rook.Exceptions;
import com.rookout.rook.LogCache;
import com.rookout.rook.Processor.FieldGetterMap;
import com.rookout.rook.Processor.NamespaceSerializerBase;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.ListNamespace;
import com.rookout.rook.Processor.Namespaces.LogRecordNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.TracebackNamespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.AccessModifier.AccessModifier;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import rook.com.google.common.base.Joiner;
import rook.com.google.protobuf.ByteString;
import rook.com.google.protobuf.RookoutBinaryWriter;
import rook.com.google.protobuf.RookoutUtils;

public class NamespaceSerializer2
extends NamespaceSerializerBase {
    static final int MAX_VARINT32_SIZE = 5;
    Variant2OuterClass.Variant2 variantNotSupported = Variant2OuterClass.Variant2.newBuilder().setVariantTypeMaxDepth(11).build();
    private HashMap<ByteBuffer, Integer> bufferCache = new HashMap();
    private List<Integer> bufferIndexes = new LinkedList<Integer>();
    private List<ByteString> buffers = new LinkedList<ByteString>();
    private static LogCache logCache = new LogCache(10);

    public NamespaceSerializer2() {
        super(true);
    }

    public byte[] Dump(Namespace namespace, boolean logErrors) {
        RookoutBinaryWriter writer = RookoutUtils.GetBinaryWriter();
        this.Dump(namespace, writer, logErrors);
        return RookoutUtils.BinaryWriterToArray(writer);
    }

    public byte[] Dump(Namespace namespace) {
        return this.Dump(namespace, true);
    }

    public byte[] Dump(RookError error) {
        RookoutBinaryWriter writer = RookoutUtils.GetBinaryWriter();
        this.Dump(error, writer);
        return RookoutUtils.BinaryWriterToArray(writer);
    }

    public void Dump(Namespace namespace, RookoutBinaryWriter writer, boolean logErrors) {
        block7: {
            int startPosition = writer.getTotalBytesWritten();
            try {
                if (namespace instanceof ContainerNamespace) {
                    this.DumpContainerNamespace((ContainerNamespace)namespace, writer, logErrors);
                    break block7;
                }
                if (namespace instanceof JavaObjectNamespace) {
                    JavaObjectNamespace jons = (JavaObjectNamespace)namespace;
                    this.DumpJavaObject(jons.obj, writer, 0, jons.objectDumpConfig, logErrors);
                    break block7;
                }
                if (namespace instanceof ListNamespace) {
                    this.DumpListNamespace((ListNamespace)namespace, writer, logErrors);
                    break block7;
                }
                if (namespace instanceof TracebackNamespace) {
                    this.DumpTracebackNamespace((TracebackNamespace)namespace, writer);
                    break block7;
                }
                if (namespace instanceof LogRecordNamespace) {
                    this.DumpLogRecordNamespace((LogRecordNamespace)namespace, writer);
                    break block7;
                }
                throw new RuntimeException("Namespace not supported! " + namespace.getClass().toString());
            }
            catch (Throwable e) {
                writer.resetPosition(startPosition);
                this.SafeError(writer, "Failed to serialize namespace", e, logErrors, namespace);
            }
        }
    }

    public void Dump(RookError error, RookoutBinaryWriter writer) {
        int messagePosition = writer.getTotalBytesWritten();
        try {
            writer.writeString(1, error.getMessage());
        }
        catch (Throwable e) {
            writer.resetPosition(messagePosition);
        }
        int typePosition = writer.getTotalBytesWritten();
        try {
            writer.writeString(2, error.getType());
        }
        catch (Throwable e) {
            writer.resetPosition(typePosition);
        }
        int parametersPosition = writer.getTotalBytesWritten();
        try {
            this.writeObject(writer, 3, error.getParameters(), 0, JavaObjectNamespace.ObjectDumpConfig.GetDefaultDumpConfig(), false);
        }
        catch (Throwable e) {
            writer.resetPosition(parametersPosition);
        }
        int throwablePosition = writer.getTotalBytesWritten();
        try {
            JavaObjectNamespace.ObjectDumpConfig tailoredDumpConfig = JavaObjectNamespace.ObjectDumpConfig.GetDefaultDumpConfig();
            tailoredDumpConfig.skip_stacktrace = true;
            this.writeObject(writer, 4, error.getThrowable(), 0, tailoredDumpConfig, false);
        }
        catch (Throwable e) {
            writer.resetPosition(throwablePosition);
        }
        int tracebackPosition = writer.getTotalBytesWritten();
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            error.getThrowable().printStackTrace(pw);
            String traceback = sw.toString();
            this.writeObject(writer, 5, traceback, 0, JavaObjectNamespace.ObjectDumpConfig.TailorLimits(traceback), false);
        }
        catch (Throwable e) {
            writer.resetPosition(tracebackPosition);
        }
    }

    public static void WriteVariantType(RookoutBinaryWriter writer, VariantOuterClass.Variant.Type type) throws IOException {
        writer.writeUInt32(1, type.ordinal() << 1);
    }

    public static void WriteVariantTypeWithMaxDepth(RookoutBinaryWriter writer, VariantOuterClass.Variant.Type type) throws IOException {
        writer.writeUInt32(1, type.ordinal() << 1 | 1);
    }

    private void DumpContainerNamespace(ContainerNamespace namespace, RookoutBinaryWriter writer, boolean logErrors) throws IOException {
        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_NAMESPACE);
        LinkedList<Integer> attributeNames = new LinkedList<Integer>();
        for (Map.Entry<String, Namespace> entry : namespace.namespaces.entrySet()) {
            attributeNames.addFirst(this.GetStringIndexInCache(entry.getKey()));
            this.writeNamespace(writer, 4, entry.getValue(), logErrors);
        }
        writer.writeUInt32List(3, attributeNames, true);
    }

    private void DumpJavaObject(Object object, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) {
        int startPosition = writer.getTotalBytesWritten();
        try {
            this.DumpJavaObjectUnsafe(object, writer, currentDepth, objectDumpConfig, logErrors);
        }
        catch (Throwable e) {
            writer.resetPosition(startPosition);
            this.SafeError(writer, "Failed to serialize Java Object", e, logErrors, object);
        }
    }

    private void DumpJavaObjectUnsafe(Object object, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        if (null == object) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_NONE);
        } else if (object instanceof Enum) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_ENUM);
            writer.writeUInt32(2, this.GetStringIndexInCache(object.getClass().getSimpleName()));
            Enum enm = (Enum)object;
            writer.writeUInt32(6, enm.ordinal());
            writer.writeUInt32(7, this.GetStringIndexInCache(enm.name()));
        } else if (object instanceof ThreadLocal) {
            this.DumpJavaObjectUnsafe(((ThreadLocal)object).get(), writer, currentDepth, objectDumpConfig, logErrors);
        } else {
            Class<?> cls = object.getClass();
            String className = cls.getName();
            writer.writeUInt32(2, this.GetStringIndexInCache(className));
            if (null != java8 && java8.isSupported(object)) {
                java8.DumpJavaObject(object, writer, currentDepth, objectDumpConfig);
            } else if (object instanceof Boolean) {
                NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LONG);
                writer.writeUInt32(6, (Boolean)object != false ? 1 : 0);
            } else if (object instanceof Number) {
                this.dumpNumber((Number)object, writer);
            } else if (object instanceof String || object instanceof Character) {
                this.dumpStringObject(object.toString(), writer, objectDumpConfig);
            } else if (object instanceof Date) {
                NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_TIME);
                writer.writeMessage(12, RookoutUtils.dateToTimestamp((Date)object));
            } else if (cls.isArray()) {
                if (object instanceof byte[]) {
                    NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_BINARY);
                    byte[] binary = (byte[])object;
                    int size = Math.min(binary.length, objectDumpConfig.max_string);
                    if (size != binary.length) {
                        writer.writeUInt32(5, binary.length);
                    }
                    ByteBuffer buffer = ByteBuffer.wrap(binary, 0, size);
                    writer.writeUInt32(7, this.GetBufferIndexInCache(buffer));
                } else if (object instanceof char[]) {
                    this.dumpStringObject(String.valueOf((char[])object), writer, objectDumpConfig);
                } else if (object instanceof Character[]) {
                    this.dumpStringObject(String.valueOf(ArrayUtils.toPrimitive((Character[])object)), writer, objectDumpConfig);
                } else {
                    this.DumpArray(object, writer, currentDepth, objectDumpConfig, logErrors);
                }
            } else if (object instanceof Map) {
                this.DumpMap((Map)object, writer, currentDepth, objectDumpConfig, logErrors);
            } else if (object instanceof Throwable) {
                this.DumpThrowable((Throwable)object, writer, currentDepth, objectDumpConfig, logErrors);
            } else if (object instanceof Collection) {
                NamespaceSerializerBase.isListOfCharsOptions listOfChars = NamespaceSerializer2.isListOfChars(object);
                if (listOfChars == NamespaceSerializerBase.isListOfCharsOptions.TRUE) {
                    this.dumpStringObject(Joiner.on("").join((Iterable)object), writer, objectDumpConfig);
                } else if (listOfChars == NamespaceSerializerBase.isListOfCharsOptions.CONCURRENTLY_MODIFIED) {
                    this.dumpStringObject("Failed to process list, because it was concurrently modified", writer, objectDumpConfig);
                } else {
                    this.DumpCollection((Collection)object, writer, currentDepth, objectDumpConfig, logErrors);
                }
            } else if (NamespaceSerializer2.isJRubyObject(object)) {
                this.DumpJRubyObject(object, writer, currentDepth, objectDumpConfig, logErrors);
            } else {
                FieldGetterMap javaTimeGetter;
                if (className.startsWith("scala.")) {
                    if (className.startsWith("scala.Tuple")) {
                        this.DumpCustomCollection(object, writer, currentDepth, objectDumpConfig, logErrors, "productIterator", "productArity");
                        return;
                    }
                    if (className.startsWith("scala.Some")) {
                        Object internalObject = MethodUtils.invokeMethod(object, "get", new Object[0]);
                        this.DumpJavaObject(internalObject, writer, currentDepth, objectDumpConfig, logErrors);
                        return;
                    }
                    if (Utils.IsObjectSubClassOf(object, "scala.collection.AbstractMap") || className.equals("scala.collection.immutable.TreeMap") || className.equals("scala.collection.mutable.TreeMap") || className.equals("scala.collection.immutable.TreeSeqMap")) {
                        this.DumpCustomMap(object, writer, currentDepth, objectDumpConfig, logErrors, "keysIterator", "size", "get");
                        return;
                    }
                    if (Utils.IsObjectSubClassOf(object, "scala.collection.AbstractIterable") || className.equals("scala.collection.immutable.TreeSet") || className.equals("scala.collection.mutable.TreeSet")) {
                        this.DumpCustomCollection(object, writer, currentDepth, objectDumpConfig, logErrors, "iterator", "size");
                        return;
                    }
                }
                if (className.startsWith("java.time") && (javaTimeGetter = (FieldGetterMap)classGettersMap.get(className)) != null) {
                    this.DumpUserObjectWithGetters(object, writer, currentDepth, objectDumpConfig, logErrors, (FieldGetterMap)classGettersMap.get(className));
                    return;
                }
                if (className.startsWith("org.apache.spark.sql")) {
                    if (className.equals("org.apache.spark.sql.DataFrame") || className.equals("org.apache.spark.sql.Dataset")) {
                        this.DumpSparkDataFrame(object, writer, currentDepth, objectDumpConfig, logErrors);
                        return;
                    }
                    if (className.equals("org.apache.spark.sql.Row") || className.equals("org.apache.spark.sql.catalyst.expressions.GenericRow") || className.equals("org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema")) {
                        this.DumpSparkRow(object, writer, currentDepth, objectDumpConfig, logErrors);
                        return;
                    }
                }
                if (otherStringsList.contains(className)) {
                    this.dumpStringObject(object.toString(), writer, objectDumpConfig);
                    return;
                }
                if (currentDepth > 0 && Blacklist.Instance().isBlacklisted(className)) {
                    NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
                    return;
                }
                this.DumpUserObject(object, writer, currentDepth, objectDumpConfig, logErrors);
            }
        }
    }

    private void dumpNumber(Number number, RookoutBinaryWriter writer) throws IOException {
        if (number instanceof Float || number instanceof Double) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_DOUBLE);
            writer.writeDouble(10, number.doubleValue());
        } else {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LONG);
            writer.writeUInt64(6, number.longValue());
        }
    }

    private void dumpStringObject(String string, RookoutBinaryWriter writer, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig) throws IOException {
        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_STRING);
        if (string.length() > objectDumpConfig.max_string) {
            writer.writeUInt32(5, string.length());
            string = string.substring(0, objectDumpConfig.max_string);
        }
        writer.writeUInt32(7, this.GetStringIndexInCache(string));
    }

    private static boolean isJRubyObject(Object object) {
        return object != null && object.getClass().getName().startsWith("org.jruby");
    }

    private void DumpJRubyObject(Object object, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        block26: {
            Class<?> c = object.getClass();
            String className = c.getName();
            try {
                switch (className) {
                    case "org.jruby.RubyNil": {
                        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_NONE);
                        break;
                    }
                    case "org.jruby.RubyBoolean$False": {
                        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LONG);
                        writer.writeUInt32(6, 0);
                        break;
                    }
                    case "org.jruby.RubyBoolean$True": {
                        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LONG);
                        writer.writeUInt32(6, 1);
                        break;
                    }
                    case "org.jruby.RubyBignum": {
                        BigInteger bigValue = (BigInteger)MethodUtils.invokeMethod(object, "getBigIntegerValue", new Object[0]);
                        long value = bigValue.longValue();
                        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LONG);
                        writer.writeUInt64(6, value);
                        break;
                    }
                    case "org.jruby.RubyFixnum": {
                        long value = (Long)MethodUtils.invokeMethod(object, "getLongValue", new Object[0]);
                        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LONG);
                        writer.writeUInt64(6, value);
                    }
                    case "org.jruby.RubyFloat": {
                        double d = (Double)MethodUtils.invokeMethod(object, "getDoubleValue", new Object[0]);
                        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_DOUBLE);
                        writer.writeDouble(10, d);
                        break;
                    }
                    case "org.jruby.RubySymbol": 
                    case "org.jruby.RubyString": {
                        this.dumpStringObject(object.toString(), writer, objectDumpConfig);
                        break;
                    }
                    case "org.jruby.RubyDate": 
                    case "org.jruby.RubyDateTime": {
                        Date date = (Date)MethodUtils.invokeMethod(object, "toDate", new Object[0]);
                        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_TIME);
                        writer.writeMessage(12, RookoutUtils.dateToTimestamp(date));
                        break;
                    }
                    case "org.jruby.RubyTime": {
                        Date date = (Date)MethodUtils.invokeMethod(object, "getJavaDate", new Object[0]);
                        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_TIME);
                        writer.writeMessage(12, RookoutUtils.dateToTimestamp(date));
                        break;
                    }
                    default: {
                        this.DumpJRubyUserObject(object, writer, currentDepth, objectDumpConfig, logErrors);
                        break;
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                if (!logErrors) break block26;
                RookLogger.Instance().warn("Unable to convert to java object: " + e, new Object[0]);
            }
        }
    }

    private void DumpJRubyUserObject(Object object, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        int weightedChildrenDepth = currentDepth + 1;
        LinkedList<Integer> attributeNames = new LinkedList<Integer>();
        boolean hasVariables = (Boolean)MethodUtils.invokeMethod(object, "hasVariables", new Object[0]);
        if (hasVariables) {
            List variables = (List)MethodUtils.invokeMethod(object, "getVariableList", new Object[0]);
            for (Object field : variables) {
                if (weightedChildrenDepth > objectDumpConfig.max_depth) {
                    NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
                    return;
                }
                String fieldName = (String)MethodUtils.invokeMethod(field, "getName", new Object[0]);
                attributeNames.addFirst(this.GetStringIndexInCache(fieldName));
                this.writeObject(writer, 4, MethodUtils.invokeMethod(field, "getValue", new Object[0]), weightedChildrenDepth, objectDumpConfig, logErrors);
            }
        }
        if (!attributeNames.isEmpty()) {
            writer.writeUInt32List(3, attributeNames, true);
        }
        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
    }

    private void DumpUserObject(Object object, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        int weightedChildrenDepth = currentDepth + 1;
        LinkedList<Integer> attributeNames = new LinkedList<Integer>();
        Class<?> cls = object.getClass();
        do {
            for (Field field : cls.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getName().equals("$outer")) continue;
                if (weightedChildrenDepth > objectDumpConfig.max_depth) {
                    NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
                    return;
                }
                attributeNames.addFirst(this.GetStringIndexInCache(field.getName()));
                if (AccessModifier.setAccessible(field, object, cls)) {
                    this.writeObject(writer, 4, field.get(object), weightedChildrenDepth, objectDumpConfig, logErrors);
                    continue;
                }
                writer.writeMessage(4, this.variantNotSupported);
            }
        } while (null != (cls = cls.getSuperclass()) && Object.class != cls);
        if (!attributeNames.isEmpty()) {
            writer.writeUInt32List(3, attributeNames, true);
        }
        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
    }

    private void DumpUserObjectWithGetters(Object object, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors, FieldGetterMap classGetters) throws Exception {
        int weightedChildrenDepth = currentDepth + 1;
        LinkedList<Integer> attributeNames = new LinkedList<Integer>();
        for (Map.Entry entry : classGetters.entrySet()) {
            attributeNames.addFirst(this.GetStringIndexInCache((String)entry.getKey()));
            Object value = MethodUtils.invokeMethod(object, (String)entry.getValue(), new Object[0]);
            this.writeObject(writer, 4, value, weightedChildrenDepth, objectDumpConfig, logErrors);
        }
        if (!attributeNames.isEmpty()) {
            writer.writeUInt32List(3, attributeNames, true);
        }
        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
    }

    private void DumpArray(Object collection, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws IOException {
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LIST);
            int length = Array.getLength(collection);
            int max_items = Math.min(length, objectDumpConfig.max_width);
            if (max_items != length) {
                writer.writeUInt32(5, Array.getLength(collection));
            }
            for (int i = 0; i < max_items; ++i) {
                this.writeObject(writer, 9, Array.get(collection, i), currentDepth + 1, objectDumpConfig, logErrors);
            }
        } else {
            NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_LIST);
            writer.writeUInt32(5, Array.getLength(collection));
        }
    }

    private void DumpCollection(Collection collection, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws IOException {
        if (collection.getClass().getPackage().getName().startsWith("org.hibernate.")) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_DYNAMIC);
            return;
        }
        VariantOuterClass.Variant.Type type = collection instanceof Set ? VariantOuterClass.Variant.Type.VARIANT_SET : VariantOuterClass.Variant.Type.VARIANT_LIST;
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            NamespaceSerializer2.WriteVariantType(writer, type);
            Iterator it = collection.iterator();
            for (int index = 0; index < objectDumpConfig.max_width && it.hasNext(); ++index) {
                this.writeObject(writer, 9, it.next(), currentDepth + 1, objectDumpConfig, logErrors);
            }
            if (it.hasNext()) {
                writer.writeUInt32(5, collection.size());
            }
        } else {
            NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, type);
            writer.writeUInt32(5, collection.size());
        }
    }

    private void DumpMap(Map collection, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        if (collection.getClass().getPackage().getName().startsWith("org.hibernate.")) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_DYNAMIC);
            return;
        }
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_MAP);
            Iterator it = collection.entrySet().iterator();
            for (int index = 0; index < objectDumpConfig.max_width && it.hasNext(); ++index) {
                Map.Entry entry = it.next();
                this.writeObject(writer, 8, entry.getKey(), currentDepth + 1, objectDumpConfig, logErrors);
                this.writeObject(writer, 9, entry.getValue(), currentDepth + 1, objectDumpConfig, logErrors);
            }
            if (it.hasNext()) {
                writer.writeUInt32(5, collection.size());
            }
        } else {
            NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_MAP);
            writer.writeUInt32(5, collection.size());
        }
    }

    private void DumpThrowable(Throwable exception, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
        LinkedList<Integer> attributeNames = new LinkedList<Integer>();
        attributeNames.addFirst(this.GetStringIndexInCache("detailMessage"));
        this.writeObject(writer, 4, exception.getMessage(), currentDepth + 1, objectDumpConfig, logErrors);
        Throwable cause = exception.getCause();
        if (cause == exception) {
            cause = null;
        }
        attributeNames.addFirst(this.GetStringIndexInCache("cause"));
        this.writeObject(writer, 4, cause, currentDepth + 1, objectDumpConfig, logErrors);
        if (!objectDumpConfig.skip_stacktrace) {
            attributeNames.addFirst(this.GetStringIndexInCache("stackTrace"));
            this.writeObject(writer, 4, exception.getStackTrace(), currentDepth + 1, objectDumpConfig, logErrors);
        }
        writer.writeUInt32List(3, attributeNames, true);
    }

    private void DumpListNamespace(ListNamespace namespace, RookoutBinaryWriter writer, boolean logErrors) throws IOException {
        NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LIST);
        Iterator<Namespace> it = namespace.list.iterator();
        while (it.hasNext()) {
            this.writeNamespace(writer, 9, it.next(), logErrors);
        }
    }

    private void DumpTracebackNamespace(TracebackNamespace namespace, RookoutBinaryWriter writer) throws Exception {
        namespace.dump(writer, new TracebackNamespace.Callable(){

            @Override
            public int call(String str) {
                return NamespaceSerializer2.this.GetStringIndexInCache(str);
            }
        });
    }

    private void DumpLogRecordNamespace(LogRecordNamespace namespace, RookoutBinaryWriter writer) throws Exception {
        Variant2OuterClass.Variant2.Builder variant = Variant2OuterClass.Variant2.newBuilder();
        namespace.dumpToVariant(variant);
        byte[] bytes = variant.build().toByteArray();
        writer.write(bytes, 0, bytes.length);
    }

    private void DumpSparkDataFrame(Object dataFrame, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        Class<?> dataFrameClass = dataFrame.getClass();
        Method count = dataFrameClass.getMethod("count", new Class[0]);
        Long length = (Long)count.invoke(dataFrame, new Object[0]);
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LIST);
            Method head = dataFrameClass.getMethod("head", Integer.TYPE);
            Object[] rows = (Object[])head.invoke(dataFrame, objectDumpConfig.max_width);
            if (length != (long)rows.length) {
                writer.writeUInt64(5, length);
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                this.writeObject(writer, 9, rows[i], currentDepth + 1, objectDumpConfig, logErrors);
            }
        } else {
            NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_LIST);
            writer.writeUInt64(5, length);
        }
    }

    private void DumpSparkRow(Object row, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        Class<?> rowClass = row.getClass();
        Method apply = rowClass.getMethod("apply", Integer.TYPE);
        Object structType = rowClass.getMethod("schema", new Class[0]).invoke(row, new Object[0]);
        String[] names = (String[])structType.getClass().getMethod("fieldNames", new Class[0]).invoke(structType, new Object[0]);
        if (names.length > 0) {
            int weightedChildrenDepth = currentDepth + 1;
            if (weightedChildrenDepth > objectDumpConfig.max_depth) {
                NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
                return;
            }
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
            LinkedList<Integer> attributeNames = new LinkedList<Integer>();
            for (int i = names.length; i >= 0; --i) {
                attributeNames.addFirst(this.GetStringIndexInCache(names[i]));
                this.writeObject(writer, 4, apply.invoke(row, i), weightedChildrenDepth, objectDumpConfig, logErrors);
            }
            writer.writeUInt32List(3, attributeNames, true);
        } else {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_OBJECT);
        }
    }

    private void DumpCustomCollection(Object collection, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors, String iteratorGetter, String sizeGetter) throws Exception {
        Object iterObject = MethodUtils.invokeMethod(collection, iteratorGetter, new Object[0]);
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_LIST);
            for (int index = 0; index < objectDumpConfig.max_width && ((Boolean)MethodUtils.invokeMethod(iterObject, "hasNext", new Object[0])).booleanValue(); ++index) {
                Object nextObject = MethodUtils.invokeMethod(iterObject, "next", new Object[0]);
                this.writeObject(writer, 9, nextObject, currentDepth + 1, objectDumpConfig, logErrors);
            }
            if (((Boolean)MethodUtils.invokeMethod(iterObject, "hasNext", new Object[0])).booleanValue()) {
                writer.writeUInt32(5, (Integer)MethodUtils.invokeMethod(collection, sizeGetter, new Object[0]));
            }
        } else {
            NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_LIST);
            writer.writeUInt32(5, (Integer)MethodUtils.invokeMethod(collection, sizeGetter, new Object[0]));
        }
    }

    private void DumpCustomMap(Object map, RookoutBinaryWriter writer, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors, String keysIteratorGetter, String sizeGetter, String valueGetter) throws Exception {
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_MAP);
            Object iterObject = MethodUtils.invokeMethod(map, keysIteratorGetter, new Object[0]);
            for (int index = 0; index < objectDumpConfig.max_width && ((Boolean)MethodUtils.invokeMethod(iterObject, "hasNext", new Object[0])).booleanValue(); ++index) {
                Object keyObject = MethodUtils.invokeMethod(iterObject, "next", new Object[0]);
                this.writeObject(writer, 8, keyObject, currentDepth + 1, objectDumpConfig, logErrors);
                this.writeObject(writer, 9, MethodUtils.invokeMethod(map, valueGetter, keyObject), currentDepth + 1, objectDumpConfig, logErrors);
            }
            if (((Boolean)MethodUtils.invokeMethod(iterObject, "hasNext", new Object[0])).booleanValue()) {
                writer.writeUInt32(5, (Integer)MethodUtils.invokeMethod(map, sizeGetter, new Object[0]));
            }
        } else {
            NamespaceSerializer2.WriteVariantTypeWithMaxDepth(writer, VariantOuterClass.Variant.Type.VARIANT_MAP);
            writer.writeUInt32(5, (Integer)MethodUtils.invokeMethod(map, sizeGetter, new Object[0]));
        }
    }

    private void SafeError(RookoutBinaryWriter writer, String message, Throwable t, boolean logErrors, Object object) {
        try {
            try {
                NamespaceSerializer2.WriteVariantType(writer, VariantOuterClass.Variant.Type.VARIANT_ERROR);
            }
            catch (IOException e) {
                return;
            }
            if (logErrors) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                String traceback = sw.toString();
                String msg = message + " ; " + traceback;
                if (!logCache.ShouldSilenceLog(msg)) {
                    Class<?> cls;
                    String objectType = "";
                    if (object != null && (cls = object.getClass()) != null) {
                        objectType = cls.getName();
                    }
                    UserWarnings.SendWarning(new RookError(new Exceptions.RookFailedToSerializeObject(objectType)));
                    RookLogger.Instance().log(Level.SEVERE, msg, t, new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void writeNamespace(RookoutBinaryWriter writer, int fieldNumber, Namespace namespace, boolean logErrors) throws IOException {
        int prevBytes = writer.getTotalBytesWritten();
        this.Dump(namespace, writer, logErrors);
        int length = writer.getTotalBytesWritten() - prevBytes;
        writer.requireSpace(10);
        writer.writeVarint32(length);
        writer.writeTag(fieldNumber, 2);
    }

    public void writeObject(RookoutBinaryWriter writer, int fieldNumber, Object object, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws IOException {
        int prevBytes = writer.getTotalBytesWritten();
        this.DumpJavaObject(object, writer, currentDepth, objectDumpConfig, logErrors);
        int length = writer.getTotalBytesWritten() - prevBytes;
        writer.requireSpace(10);
        writer.writeVarint32(length);
        writer.writeTag(fieldNumber, 2);
    }

    void writeError(RookoutBinaryWriter writer, int fieldNumber, RookError error) throws IOException {
        int prevBytes = writer.getTotalBytesWritten();
        this.Dump(error, writer);
        int length = writer.getTotalBytesWritten() - prevBytes;
        writer.requireSpace(10);
        writer.writeVarint32(length);
        writer.writeTag(fieldNumber, 2);
    }

    private int GetBufferIndexInCache(ByteBuffer buffer) {
        if (this.bufferCache.containsKey(buffer)) {
            return this.bufferCache.get(buffer);
        }
        this.estimatedPendingBytes += buffer.limit() - buffer.position() + 5;
        int currentSize = this.bufferCache.size();
        this.bufferCache.put(buffer, currentSize);
        return currentSize;
    }

    public void FinalizeBufferCache() {
        if (this.bufferCache != null) {
            for (Map.Entry<ByteBuffer, Integer> entry : this.bufferCache.entrySet()) {
                this.bufferIndexes.add(entry.getValue());
                this.buffers.add(ByteString.copyFrom(entry.getKey()));
            }
            this.bufferCache = null;
        }
    }

    public List<Integer> getBufferIndices() {
        return this.bufferIndexes;
    }

    public List<ByteString> getBuffers() {
        return this.buffers;
    }
}

