/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.javarook.protobuf.Variant2OuterClass;
import com.rookout.javarook.protobuf.VariantOuterClass;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Services.AccessModifier.AccessModifier;
import com.rookout.rook.Services.Instrumentation.LogRecord;
import java.lang.reflect.Field;

public class LogRecordNamespace
extends Namespace {
    public final LogRecord logRecordInstance;
    private static final String lineNumberField = "lineno";
    private static final String filenameField = "filename";
    private static final String functionField = "function";
    private static final String messageField = "msg";
    private static final String levelNameField = "levelname";
    private static final String logContextField = "log_context";

    public LogRecordNamespace(LogRecord logRecord) {
        this.logRecordInstance = logRecord;
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        Field field;
        this.PrepareLogRecordForReadingAttribute(name);
        Class<?> cls = this.logRecordInstance.getClass();
        try {
            field = cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
        if (!AccessModifier.setAccessible(field, this.logRecordInstance, this.logRecordInstance.getClass())) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
        try {
            return new JavaObjectNamespace(field.get(this.logRecordInstance));
        }
        catch (Throwable e) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
    }

    private void PrepareLogRecordForReadingAttribute(String name) throws Exceptions.RookFailedToCollectStacktrace {
        switch (name) {
            case "filename": 
            case "lineno": 
            case "function": {
                this.logRecordInstance.setLogCallerInfo();
                break;
            }
            case "msg": {
                this.logRecordInstance.formatLog();
                break;
            }
            case "levelname": {
                this.logRecordInstance.getLevelName();
                break;
            }
            case "log_context": {
                this.logRecordInstance.setMdcData();
            }
        }
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "format": {
                return this.format();
            }
        }
        return super.CallMethod(name, args);
    }

    public JavaObjectNamespace format() {
        return new JavaObjectNamespace(this.logRecordInstance.getMessage());
    }

    public void dumpToVariant(VariantOuterClass.Variant.Builder variant) throws Exceptions.ToolException {
        variant.setVariantType(VariantOuterClass.Variant.Type.VARIANT_LIVETAIL);
        this.logRecordInstance.setLogCallerInfo();
        this.logRecordInstance.setMdcData();
        VariantOuterClass.Variant.LiveTailMessage.Builder log_record = VariantOuterClass.Variant.LiveTailMessage.newBuilder();
        log_record.setFilename(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.filename, "unavailable"));
        log_record.setFunction(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.function, "unavailable"));
        log_record.setLineno(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.lineno, -1));
        log_record.setTime(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.time, -1.0));
        log_record.setFormattedMessage(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getMessage(), "unavailable"));
        log_record.setModule(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.module, "unavailable"));
        log_record.setMsg(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getMessage(), "unavailable"));
        log_record.setLevelName(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getLevelName(), "unavailable"));
        log_record.setThreadId(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.thread_id, -1L));
        log_record.setThreadName(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.thread_name, "unavailable"));
        if (this.logRecordInstance.log_context != null) {
            log_record.putAllLogContext(this.logRecordInstance.log_context);
        }
        variant.setLivetail(log_record);
    }

    public void dumpToVariant(Variant2OuterClass.Variant2.Builder variant) throws Exceptions.ToolException {
        variant.setVariantTypeMaxDepth(VariantOuterClass.Variant.Type.VARIANT_LIVETAIL.ordinal() << 1);
        this.logRecordInstance.setLogCallerInfo();
        this.logRecordInstance.setMdcData();
        VariantOuterClass.Variant.LiveTailMessage.Builder log_record = VariantOuterClass.Variant.LiveTailMessage.newBuilder();
        log_record.setFilename(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.filename, "unavailable"));
        log_record.setFunction(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.function, "unavailable"));
        log_record.setLineno(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.lineno, -1));
        log_record.setTime(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.time, -1.0));
        log_record.setFormattedMessage(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getMessage(), "unavailable"));
        log_record.setModule(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.module, "unavailable"));
        log_record.setMsg(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getMessage(), "unavailable"));
        log_record.setLevelName(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.getLevelName(), "unavailable"));
        log_record.setThreadId(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.thread_id, -1L));
        log_record.setThreadName(LogRecordNamespace.getValueOrDefault(this.logRecordInstance.thread_name, "unavailable"));
        if (this.logRecordInstance.log_context != null) {
            log_record.putAllLogContext(this.logRecordInstance.log_context);
        }
        variant.setLivetail(log_record);
    }

    public static <T> T getValueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }
}

