/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class API {
    private static boolean loaded = false;

    public static void Load() {
        if (loaded) {
            return;
        }
        try {
            File currentJarFile = API.getJavaAgent();
            API.LoadRookToJvm(currentJarFile.getPath(), currentJarFile.getParent());
        }
        catch (Throwable e) {
            System.out.println("Failed to load Rookout javaagent!");
            e.printStackTrace();
        }
    }

    private static File getJavaAgent() throws Exception {
        File currentJarFile = null;
        URL sourceLocation = API.class.getProtectionDomain().getCodeSource().getLocation();
        URLConnection sourceConnection = sourceLocation.openConnection();
        currentJarFile = sourceConnection instanceof JarURLConnection ? API.extractJavaAgent(sourceConnection.getInputStream()) : new File(sourceLocation.toURI());
        return currentJarFile;
    }

    private static File extractJavaAgent(InputStream is) throws IOException {
        int nBytes;
        File outFile = Files.createTempFile("rook", ".jar", new FileAttribute[0]).toFile();
        BufferedInputStream in = new BufferedInputStream(is);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        byte[] buffer = new byte[4096];
        while ((nBytes = in.read(buffer)) > 0) {
            out.write(buffer, 0, nBytes);
        }
        out.flush();
        out.close();
        outFile.deleteOnExit();
        return outFile;
    }

    public static void Flush() {
        try {
            SingletonAccessor.Flush();
        }
        catch (Throwable e) {
            System.out.println("Failed to flush Rook!");
            e.printStackTrace();
        }
    }

    public static void Load(String token) {
        System.setProperty("rookout.rook.token", token);
        API.Load();
    }

    private static String GetPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        return nameOfRunningVM.substring(0, nameOfRunningVM.indexOf(64));
    }

    private static String FetchToolsJarPath(String currentJarFolder) throws Exception {
        Path toolJar;
        String javaHome = System.getProperty("java.home", null);
        if (null != javaHome && (toolJar = Paths.get(javaHome, "..", "lib", "tools.jar")).toFile().exists()) {
            return toolJar.toAbsolutePath().toString();
        }
        File dir = new File(currentJarFolder);
        File[] foundFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("tools") && name.endsWith(".jar");
            }
        });
        if (0 == foundFiles.length) {
            throw new Exception("Did not find tools.jar in the Rook's folder");
        }
        if (foundFiles.length > 1) {
            StringBuilder fileList = new StringBuilder();
            for (int i = 0; i < foundFiles.length; ++i) {
                fileList.append(foundFiles[i].getName()).append(" ");
            }
            throw new Exception("Tools.jar could not be resolved : " + fileList.toString());
        }
        return foundFiles[0].getPath();
    }

    private static Class<?> getVirtualMachine(String currentJarFolder) throws Exception {
        Class<?> virtualMachine = null;
        try {
            virtualMachine = Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException e) {
            String toolsJarFolder = API.FetchToolsJarPath(currentJarFolder);
            URLClassLoader loader = new URLClassLoader(new URL[]{new URL("file:///" + toolsJarFolder)}, API.class.getClassLoader());
            virtualMachine = Class.forName("com.sun.tools.attach.VirtualMachine", true, loader);
        }
        return virtualMachine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void LoadRookToJvm(String currentJarPath, String currentJarFolder) throws Exception {
        Object vm = null;
        Class<?> virtualMachine = null;
        try {
            virtualMachine = API.getVirtualMachine(currentJarFolder);
            Class[] cArg = new Class[]{String.class};
            Method attach = virtualMachine.getDeclaredMethod("attach", cArg);
            vm = attach.invoke(null, API.GetPid());
            Method loadAgent = virtualMachine.getDeclaredMethod("loadAgent", cArg);
            loadAgent.invoke(vm, currentJarPath);
            loaded = true;
            if (null == vm) return;
        }
        catch (Throwable throwable) {
            if (null == vm) throw throwable;
            Method detach = virtualMachine.getDeclaredMethod("detach", new Class[0]);
            detach.invoke(vm, new Object[0]);
            throw throwable;
        }
        Method detach = virtualMachine.getDeclaredMethod("detach", new Class[0]);
        detach.invoke(vm, new Object[0]);
    }

    public static class SingletonAccessor {
        public static void Flush() {
            Singleton.Instance().Flush();
        }
    }
}

