/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.AugManager;
import com.rookout.rook.Com.AgentCom;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Output;
import com.rookout.rook.RookLogger;
import com.rookout.rook.RuntimeVersionVerifier;
import com.rookout.rook.Services.Instrumentation.InstrumentationService;
import com.rookout.rook.TriggerServices;
import java.lang.instrument.Instrumentation;
import java.util.logging.Level;

public class Singleton {
    private static Singleton instance;
    private Output output = new Output();
    private boolean servicesStarted = false;
    private TriggerServices triggerServices = null;
    private AugManager augManager = null;
    private AgentCom agentCom = null;

    static void Main(String agentArgs, Instrumentation instrumentation, boolean shouldReloadAllClassesOnStart) throws Exceptions.RookUnSupportedEnvironment {
        RookLogger.Instance().info("Rookout Singleton Starting");
        RuntimeVersionVerifier.CheckVersionSupported();
        if (null != instance) {
            throw new RuntimeException("Rook started multiple times!");
        }
        InstrumentationService.SetInstrumentation(instrumentation, shouldReloadAllClassesOnStart);
        if (null != agentArgs && agentArgs.equals("test")) {
            return;
        }
        try {
            Singleton.Instance().Connect();
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.WARNING, "Rook failed to connect to the agent - will continue attempting in the background.", e);
        }
    }

    public static Singleton Instance() {
        if (null == instance) {
            instance = new Singleton();
        }
        return instance;
    }

    private Singleton() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RookLogger.Instance().log(Level.INFO, "Exit handler called - flushing");
                    Singleton.this.Flush();
                }
                catch (Throwable t) {
                    RookLogger.Instance().log(Level.WARNING, "Flush failed", t);
                }
                RookLogger.Instance().log(Level.INFO, "Exit handler finished");
            }
        }));
    }

    public void StartServices() {
        if (this.servicesStarted) {
            return;
        }
        this.triggerServices = new TriggerServices();
        this.augManager = new AugManager(this.triggerServices, this.output);
        this.servicesStarted = true;
    }

    public void StopServices() {
        if (!this.servicesStarted) {
            return;
        }
        this.augManager = null;
        this.triggerServices.Close();
        this.triggerServices = null;
        this.servicesStarted = false;
    }

    void Connect() throws Exception {
        String token;
        String host = System.getenv("ROOKOUT_AGENT_HOST");
        if (null == host) {
            host = Config.Instance().AgentAddress$HOST;
        }
        String portString = System.getenv("ROOKOUT_AGENT_PORT");
        int port = Config.Instance().AgentAddress$PORT;
        if (null != portString) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (Exception e) {
                RookLogger.Instance().warning("Port specified is not a valid integer: " + portString + " - using default port");
            }
        }
        if ((token = System.getProperty("rookout.rook.token")) == null) {
            token = System.getenv("ROOKOUT_TOKEN");
        }
        this.StartServices();
        RookLogger.Instance().info("Connecting to agent");
        this.agentCom = new AgentCom(this.augManager, this.output, host, port, token);
        this.output.setAgentCom(this.agentCom);
        this.agentCom.ConnectToAgent();
    }

    public void Flush() {
        if (null != this.output) {
            this.output.FlushMessages();
        }
    }

    public TriggerServices getTriggerServices() {
        return this.triggerServices;
    }
}

