/*
 * Decompiled with CFR 0.152.
 */
package rook.io.grpc;

import java.util.concurrent.Executor;
import rook.com.google.common.base.MoreObjects;
import rook.com.google.common.base.Preconditions;
import rook.io.grpc.Attributes;
import rook.io.grpc.CallCredentials;
import rook.io.grpc.ExperimentalApi;
import rook.io.grpc.Metadata;
import rook.io.grpc.MethodDescriptor;
import rook.io.grpc.SecurityLevel;
import rook.io.grpc.Status;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4901")
public abstract class CallCredentials2
implements CallCredentials {
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1914")
    public abstract void applyRequestMetadata(CallCredentials.RequestInfo var1, Executor var2, MetadataApplier var3);

    @Override
    public final void applyRequestMetadata(final MethodDescriptor<?, ?> method, final Attributes attrs, Executor appExecutor, final CallCredentials.MetadataApplier applier) {
        final String authority = (String)Preconditions.checkNotNull(attrs.get(ATTR_AUTHORITY), "authority");
        final SecurityLevel securityLevel = MoreObjects.firstNonNull(attrs.get(ATTR_SECURITY_LEVEL), SecurityLevel.NONE);
        CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

            @Override
            public MethodDescriptor<?, ?> getMethodDescriptor() {
                return method;
            }

            @Override
            public SecurityLevel getSecurityLevel() {
                return securityLevel;
            }

            @Override
            public String getAuthority() {
                return authority;
            }

            @Override
            public Attributes getTransportAttrs() {
                return attrs;
            }
        };
        MetadataApplier applierAdapter = new MetadataApplier(){

            @Override
            public void apply(Metadata headers) {
                applier.apply(headers);
            }

            @Override
            public void fail(Status status) {
                applier.fail(status);
            }
        };
        this.applyRequestMetadata(requestInfo, appExecutor, applierAdapter);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1914")
    public static abstract class MetadataApplier
    implements CallCredentials.MetadataApplier {
    }
}

