/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import sun.net.www.protocol.file.FileURLConnection;

class HashCheck {
    HashCheck() {
    }

    static String getBufferHash(byte[] buffer) throws NoSuchAlgorithmException, IOException {
        String fileContents = new String(buffer).replace("\r\n", "\n").replace("\r\u0000\n\u0000", "\n\u0000").replace("\r", "\n");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(fileContents.getBytes("UTF-8"));
        return Utils.bytesToHex(hash);
    }

    static String getFileHash(String filename) throws NoSuchAlgorithmException, IOException {
        return HashCheck.getBufferHash(Files.readAllBytes(Paths.get(filename, new String[0])));
    }

    static String getJarFileHash(JarFile jar, JarEntry filename) throws NoSuchAlgorithmException, IOException {
        return HashCheck.getBufferHash(Utils.getEntryBytes(jar, filename));
    }

    static ArrayList<String> getJarHashes(JarFile jar, String fileName) throws NoSuchAlgorithmException, IOException {
        ArrayList<String> hashes = new ArrayList<String>();
        Enumeration<JarEntry> elements = jar.entries();
        while (elements.hasMoreElements()) {
            JarEntry entry = elements.nextElement();
            if (!entry.getName().endsWith(fileName)) continue;
            hashes.add(HashCheck.getJarFileHash(jar, entry));
        }
        return hashes;
    }

    static boolean CheckHash(Aug aug, String hash, URL sourceLocation, String fileName) {
        if (fileName == null || sourceLocation == null) {
            return false;
        }
        if (hash == null) {
            return true;
        }
        ArrayList<String> hashes = new ArrayList<String>();
        try {
            if (Utils.IsColdFusionFile(fileName).booleanValue()) {
                String filePath = sourceLocation.getPath();
                String localHash = HashCheck.getFileHash(filePath);
                if (!localHash.equals(hash)) {
                    aug.SetError(new RookError(new Exceptions.RookHashMismatchException(filePath, hash, localHash)));
                    return false;
                }
                return true;
            }
            URLConnection connection = sourceLocation.openConnection();
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)connection;
                URL url = new URL(sourceLocation.getPath().substring(0, sourceLocation.getPath().indexOf(33)));
                hashes.addAll(HashCheck.getJarHashes(new JarFile(url.getFile()), fileName));
            } else if (connection instanceof FileURLConnection) {
                FileURLConnection fileURLConnection = (FileURLConnection)connection;
                if (fileURLConnection.getURL().getFile().endsWith(".jar")) {
                    JarFile jar = new JarFile(fileURLConnection.getURL().getFile());
                    hashes.addAll(HashCheck.getJarHashes(jar, fileName));
                }
            } else if (sourceLocation.getPath().endsWith("/") || sourceLocation.getPath().endsWith("\\")) {
                aug.SendWarning(new RookError(new Exceptions.RookSourceFileNotFound(fileName)));
                return true;
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            RookLogger.Instance().log(Level.FINE, "Failed to calculate hash", e);
            return false;
        }
        if (hashes.isEmpty()) {
            aug.SendWarning(new RookError(new Exceptions.RookSourceFileNotFound(fileName)));
            return true;
        }
        int count = 0;
        for (String h : hashes) {
            if (!h.equals(hash)) continue;
            ++count;
        }
        if (count == 0) {
            aug.SendWarning(new RookError(new Exceptions.RookSourceFileNotFound(fileName)));
            return false;
        }
        if (count == 1) {
            return true;
        }
        aug.SendWarning(new RookError(new Exceptions.RookMultipleSoruceFilesFound(fileName)));
        return true;
    }
}

