/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Utils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import rook.org.json.JSONObject;

public class Config {
    public String LoggingConfiguration$LOGGER_NAME = null;
    public String LoggingConfiguration$FILE_NAME = "rookout/java-rook.log";
    public boolean LoggingConfiguration$LOG_TO_STDERR = false;
    public String LoggingConfiguration$LOG_LEVEL = "INFO";
    public boolean LoggingConfiguration$PROPAGATE_LOGS = false;
    public String VersionConfiguration$VERSION = "inner-999.0.787";
    public String VersionConfiguration$COMMIT = "181da17361dbd8160f27310d8ad59c9691132fa0";
    public String DefaultConfiguration$DEFAULT_CONFIG_FILE_NAME = "rookout-config.json";
    public boolean DefaultConfiguration$LOAD_FROM_APP_FOLDER = true;
    public String DefaultConfiguration$USER_CONFIGURATION_FILE = "rookout/rookout-config.json";
    public int ErrorConfiguration$STACK_DEPTH = 10;
    public String AgentAddress$HOST = "cloud.agent.rookout.com";
    public int AgentAddress$PORT = 443;
    public Long AgentComConfiguration$RETRY_TOTAL = 0x100000L;
    public Double AgentComConfiguration$BACK_OFF = 1.0;
    public Double AgentComConfiguration$MAX_SLEEP = 300.0;
    public Integer AgentCom$MAX_MESSAGE_LENGTH = 0x6400000;
    public Integer AgentCom$GRPC_TIMEOUT = 5;
    public Integer AgentCom$SEND_ROOK_MESSAGES_TIMEOUT = 30;
    public Double OutputConfiguration$FLUSH_TIME_INTERVAL = 0.25;
    public String OutputConfiguration$THREAD_NAME = "rookout_output_thread";
    public int OutputConfiguration$MAX_ITEMS = 40;
    public int OutputConfiguration$MAX_LOG_ITEMS = 100;
    public int OutputConfiguration$MAX_STATUS_UPDATES = 100;
    public Integer ClassReloaderConfiguration$SLEEP_TIME_INTERVAL_IN_MS = 250;
    private String ClassReloaderKeyName = "ROOKOUT_RELOAD_CLASSES_INTERVAL";
    public String ClassReloaderConfiguration$THREAD_NAME = "rookout_class_reloader_thread";
    public boolean LoggingServiceConfig$IGNORE_EXCEPTIONS = true;
    private String ColdFusionConfigurationKeyName = "ROOKOUT_COLD_FUSION_FOLDER";
    public String ColdFusionConfiguration$WWW_ROOT_FOLDER;
    public long InstrumentationConfig$MIN_TIME_BETWEEN_HITS_MS = 100L;
    private static Config instance = null;

    public static Config Instance() {
        if (null == instance) {
            instance = new Config();
        }
        return instance;
    }

    private Config() {
        String classReloaderInterval;
        String rate_limit;
        this.LoadGlobalConfigurationFile();
        this.VersionConfiguration$VERSION = this.getJarVersion();
        this.ColdFusionConfiguration$WWW_ROOT_FOLDER = System.getenv(this.ColdFusionConfigurationKeyName);
        if (this.ColdFusionConfiguration$WWW_ROOT_FOLDER == null) {
            this.ColdFusionConfiguration$WWW_ROOT_FOLDER = "";
        }
        if (this.DefaultConfiguration$LOAD_FROM_APP_FOLDER) {
            Path app = Paths.get(Utils.GetExecutalbePath(), new String[0]);
            Path appConfig = app.toAbsolutePath().getParent().resolve(this.DefaultConfiguration$DEFAULT_CONFIG_FILE_NAME);
            this.LoadConfigurationFile(appConfig);
        }
        if ((rate_limit = System.getenv("ROOK_RULE_RATE_LIMIT")) != null) {
            try {
                this.InstrumentationConfig$MIN_TIME_BETWEEN_HITS_MS = Long.parseLong(rate_limit);
            }
            catch (NumberFormatException appConfig) {
                // empty catch block
            }
        }
        if ((classReloaderInterval = System.getenv(this.ClassReloaderKeyName)) != null) {
            try {
                this.ClassReloaderConfiguration$SLEEP_TIME_INTERVAL_IN_MS = Integer.parseInt(classReloaderInterval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    String getJarVersion() {
        try {
            File currentJarFile = new File(Config.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            JarFile currentJar = new JarFile(currentJarFile);
            Manifest currentJarManifest = currentJar.getManifest();
            String implementationVersion = (String)currentJarManifest.getMainAttributes().get(Attributes.Name.IMPLEMENTATION_VERSION);
            if (implementationVersion != null) {
                return implementationVersion;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    void LoadGlobalConfigurationFile() {
        String baseFilePath = this.DefaultConfiguration$USER_CONFIGURATION_FILE;
        if ("".equals(baseFilePath)) {
            return;
        }
        Path configFilePath = Paths.get(baseFilePath, new String[0]);
        if (!configFilePath.isAbsolute()) {
            String osName = System.getProperty("os.name").toLowerCase();
            configFilePath = osName.contains("mac") ? Paths.get(System.getenv("HOME"), baseFilePath) : (osName.contains("win") ? Paths.get(System.getenv("USERPROFILE"), baseFilePath) : Paths.get("/etc", baseFilePath));
        }
        this.LoadConfigurationFile(configFilePath);
    }

    void LoadConfigurationFile(Path filePath) {
        try {
            if (!Files.exists(filePath, new LinkOption[0])) {
                return;
            }
            String rawFile = new String(Files.readAllBytes(filePath));
            this.LoadObject(new JSONObject(rawFile), null);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.SEVERE, "Error when loading configuration file- " + filePath, e);
            return;
        }
    }

    private void LoadObject(JSONObject object, String prefix) throws Exception {
        for (String name : object.keySet()) {
            Object value = object.get(name);
            if (value instanceof JSONObject) {
                this.LoadObject((JSONObject)value, this.GetName(prefix, name));
                continue;
            }
            this.SetValue(this.GetName(prefix, name), value);
        }
    }

    private String GetName(String prefix, String name) {
        if (null != prefix && !prefix.equals("")) {
            return prefix + "$" + name;
        }
        return name;
    }

    private void SetValue(String name, Object value) throws Exception {
        this.getClass().getDeclaredField(name).set(this, value);
    }
}

