/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Files;
import java.lang.instrument.Instrumentation;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;

public class ClassReloader {
    private long sleepInterval;
    private Thread thread;
    private boolean closing;
    private Instrumentation inst;
    private Queue queue;

    ClassReloader(Instrumentation inst) {
        this.sleepInterval = Config.Instance().ClassReloaderConfiguration$SLEEP_TIME_INTERVAL_IN_MS.intValue();
        this.closing = false;
        this.inst = inst;
        if (this.sleepInterval > 0L) {
            this.queue = new Queue();
            this.thread = new Thread((Runnable)new WorkerRunnable(inst), Config.Instance().ClassReloaderConfiguration$THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    void Stop() {
        this.closing = true;
        if (null != this.queue) {
            this.queue.Stop();
        }
        try {
            if (null != this.thread) {
                this.thread.join();
                this.thread = null;
            }
        }
        catch (InterruptedException e) {
            RookLogger.Instance().log(Level.SEVERE, "Error while closing output", e);
        }
        this.queue = null;
    }

    void ReloadClassInBackground(Files.ClassObject classObject) throws Exception {
        if (this.sleepInterval > 0L) {
            this.queue.Insert(classObject);
        } else {
            ClassReloader.ReloadClass(classObject, this.inst);
        }
    }

    private static boolean ReloadClass(Files.ClassObject classObject, Instrumentation inst) throws Exception {
        Class<?> cls;
        String javaName = classObject.className.replace("/", ".");
        try {
            cls = Class.forName(javaName, true, classObject.classLoader);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Error e) {
            throw new Exceptions.RookFailedToGetClass(e);
        }
        if (!inst.isModifiableClass(cls)) {
            return false;
        }
        try {
            inst.retransformClasses(cls);
        }
        catch (Exception e) {
            RookLogger.Instance().log(Level.SEVERE, "Error while re-transforming class", e);
        }
        return true;
    }

    private class Queue {
        boolean closing = false;
        LinkedHashSet classesSet = new LinkedHashSet();

        Queue() {
        }

        synchronized void Stop() {
            this.closing = true;
            this.notify();
        }

        synchronized void Insert(Files.ClassObject item) {
            this.classesSet.add(item);
            if (1 <= this.classesSet.size()) {
                this.notify();
            }
        }

        synchronized Files.ClassObject Pop() {
            while (this.IsEmpty() && !this.closing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    RookLogger.Instance().log(Level.SEVERE, "Error while waiting", e);
                }
            }
            if (this.closing) {
                return null;
            }
            Iterator i = this.classesSet.iterator();
            Files.ClassObject next = (Files.ClassObject)i.next();
            i.remove();
            return next;
        }

        synchronized boolean IsEmpty() {
            return this.classesSet.size() == 0;
        }
    }

    private class WorkerRunnable
    implements Runnable {
        private Instrumentation inst;

        WorkerRunnable(Instrumentation inst) {
            this.inst = inst;
        }

        @Override
        public void run() {
            while (!ClassReloader.this.closing) {
                try {
                    Files.ClassObject classObject = ClassReloader.this.queue.Pop();
                    if (null == classObject) {
                        return;
                    }
                    if (!ClassReloader.ReloadClass(classObject, this.inst)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    RookLogger.Instance().log(Level.SEVERE, "Error while handling class queue", e);
                }
                try {
                    Thread.sleep(ClassReloader.this.sleepInterval);
                }
                catch (InterruptedException e) {
                    RookLogger.Instance().log(Level.SEVERE, "Error while sleeping", e);
                }
            }
        }
    }
}

