/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.HashCheck;
import com.rookout.rook.Utils;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import rook.org.objectweb.asm.ClassVisitor;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.AbstractInsnNode;
import rook.org.objectweb.asm.tree.InsnList;
import rook.org.objectweb.asm.tree.InsnNode;
import rook.org.objectweb.asm.tree.IntInsnNode;
import rook.org.objectweb.asm.tree.LdcInsnNode;
import rook.org.objectweb.asm.tree.LineNumberNode;
import rook.org.objectweb.asm.tree.LocalVariableNode;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.MethodNode;
import rook.org.objectweb.asm.tree.TypeInsnNode;
import rook.org.objectweb.asm.tree.VarInsnNode;

class Visitor
extends ClassVisitor {
    private Files files;
    private Augs augs;
    private ClassLoader classLoader;
    private String fileName;
    private String className;
    private URL sourceLocation;
    private boolean isCfm = false;
    private boolean hookedClass = false;
    private Augs.AugsInFile validAugs;

    Visitor(Files files, Augs augs, ClassLoader classLoader, String className, URL sourceLocation, ClassVisitor nextVisitor) {
        super(327680, nextVisitor);
        this.files = files;
        this.augs = augs;
        this.classLoader = classLoader;
        this.className = className;
        this.sourceLocation = sourceLocation;
        this.validAugs = new Augs.AugsInFile();
    }

    boolean isHooked() {
        return this.hookedClass;
    }

    @Override
    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
        if (null != file) {
            if (file.startsWith("<")) {
                this.fileName = file;
            } else {
                try {
                    Path filePath = Paths.get(file, new String[0]);
                    this.fileName = filePath.getFileName().toString();
                }
                catch (InvalidPathException e) {
                    this.fileName = file;
                }
            }
            this.files.AddClass(this.classLoader, this.fileName, this.className);
            this.isCfm = Utils.IsColdFusionFile(this.fileName);
        }
        for (Map.Entry e : this.augs.GetAugs(this.fileName).entrySet()) {
            Augs.AugList augList = (Augs.AugList)e.getValue();
            for (Augs.HashedAug aug : augList) {
                if (aug.fileHash != null && !HashCheck.CheckHash(aug.aug, aug.fileHash, this.className, this.sourceLocation, this.fileName)) continue;
                Augs.AugList augs = (Augs.AugList)this.validAugs.get(e.getKey());
                if (augs != null) {
                    augs.add(aug);
                    continue;
                }
                Augs.AugList newAugList = new Augs.AugList();
                newAugList.add(aug);
                this.validAugs.put(e.getKey(), newAugList);
            }
        }
        if (this.validAugs.isEmpty()) {
            throw new IgnoreClassException();
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (null == this.fileName || this.validAugs.isEmpty()) {
            throw new IgnoreClassException();
        }
        return new MethodNode(327680, access, name, desc, signature, exceptions){

            @Override
            public void visitEnd() {
                boolean hookedMethod = false;
                int lastLine = 0;
                ListIterator insn = this.instructions.iterator();
                while (insn.hasNext()) {
                    AbstractInsnNode node = (AbstractInsnNode)insn.next();
                    if (node.getType() != 15) continue;
                    LineNumberNode lineNumberNode = (LineNumberNode)node;
                    if (lineNumberNode.line == lastLine) continue;
                    lastLine = lineNumberNode.line;
                    Augs.AugList augList = (Augs.AugList)Visitor.this.validAugs.get(lineNumberNode.line);
                    if (augList == null || augList.isEmpty()) continue;
                    if (this.instructions.get(insn.nextIndex()).getType() == 14) {
                        node = (AbstractInsnNode)insn.next();
                    }
                    InsnList hook = this.BuildHook(lineNumberNode);
                    this.instructions.insert(node, hook);
                    for (Augs.HashedAug aug : augList) {
                        aug.aug.SetActive();
                    }
                    hookedMethod = true;
                    Visitor.this.hookedClass = true;
                }
                if (hookedMethod) {
                    this.maxStack += 6;
                }
                this.accept(methodVisitor);
            }

            private InsnList BuildHook(LineNumberNode hookNode) {
                int i;
                InsnList hook = new InsnList();
                hook.add(new LdcInsnNode(Visitor.this.fileName));
                hook.add(new LdcInsnNode((Object)hookNode.line));
                hook.add(new TypeInsnNode(187, Type.getInternalName(HashMap.class)));
                hook.add(new InsnNode(89));
                hook.add(new MethodInsnNode(183, Type.getInternalName(HashMap.class), "<init>", "()V", false));
                LocalState[] states = new LocalState[this.maxLocals];
                for (i = 0; i < states.length; ++i) {
                    states[i] = new LocalState();
                }
                this.LoadArguments(states);
                this.ScanMethod(hookNode, states);
                for (i = 0; i < states.length; ++i) {
                    if (!states[i].inScope || !states[i].isStore || Visitor.this.isCfm && !states[i].desc.equals("Lcoldfusion/runtime/Variable;") && !states[i].name.equals("this")) continue;
                    hook.add(new InsnNode(89));
                    hook.add(new LdcInsnNode(states[i].name));
                    hook.add(this.GetValue(states[i].desc, i));
                    hook.add(new MethodInsnNode(182, Type.getInternalName(HashMap.class), "put", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Object.class), Type.getType(Object.class)), false));
                    hook.add(new InsnNode(87));
                }
                hook.add(new MethodInsnNode(184, "com/rookout/agent/StaticCallback", "Callback", CallbackDispatcher.CallbackDescriptor, false));
                return hook;
            }

            private void LoadArguments(LocalState[] states) {
                Type[] argumentsTypes;
                int argumentIndex = 0;
                if ((this.access & 8) == 0) {
                    states[argumentIndex].isStore = true;
                    ++argumentIndex;
                }
                for (Type argumentsType : argumentsTypes = Type.getArgumentTypes(this.desc)) {
                    states[argumentIndex].isStore = true;
                    String descriptor = argumentsType.getDescriptor();
                    if (descriptor.equals("D") || descriptor.equals("J")) {
                        argumentIndex += 2;
                        continue;
                    }
                    ++argumentIndex;
                }
            }

            private void ScanMethod(LineNumberNode hookNode, LocalState[] states) {
                AbstractInsnNode insnIterator;
                ListIterator it = this.instructions.iterator();
                while (it.hasNext() && (insnIterator = (AbstractInsnNode)it.next()) != hookNode) {
                    if (insnIterator.getType() == 8) {
                        for (Object iterator : this.localVariables) {
                            LocalVariableNode localVariableNode = (LocalVariableNode)iterator;
                            if (localVariableNode.start == insnIterator) {
                                states[localVariableNode.index].inScope = true;
                                states[localVariableNode.index].name = localVariableNode.name;
                                states[localVariableNode.index].desc = localVariableNode.desc;
                                continue;
                            }
                            if (localVariableNode.end != insnIterator) continue;
                            states[localVariableNode.index].inScope = false;
                            states[localVariableNode.index].isStore = false;
                            states[localVariableNode.index].name = null;
                            states[localVariableNode.index].desc = null;
                        }
                        continue;
                    }
                    if (insnIterator.getType() != 2) continue;
                    VarInsnNode varInsnNode = (VarInsnNode)insnIterator;
                    if (varInsnNode.getOpcode() == 54 || varInsnNode.getOpcode() == 56 || varInsnNode.getOpcode() == 58) {
                        states[varInsnNode.var].isStore = true;
                        continue;
                    }
                    if (varInsnNode.getOpcode() != 57 && varInsnNode.getOpcode() != 55) continue;
                    states[varInsnNode.var].isStore = true;
                    states[varInsnNode.var + 1].isStore = false;
                }
            }

            private InsnList GetValue(String desc, int index) {
                switch (desc) {
                    case "B": {
                        return this.PrimitiveToObject(index, Type.BYTE_TYPE, Byte.class, 21);
                    }
                    case "C": {
                        return this.PrimitiveToObject(index, Type.CHAR_TYPE, Character.class, 21);
                    }
                    case "D": {
                        return this.PrimitiveToObject(index, Type.DOUBLE_TYPE, Double.class, 24);
                    }
                    case "F": {
                        return this.PrimitiveToObject(index, Type.FLOAT_TYPE, Float.class, 23);
                    }
                    case "I": {
                        return this.PrimitiveToObject(index, Type.INT_TYPE, Integer.class, 21);
                    }
                    case "J": {
                        return this.PrimitiveToObject(index, Type.LONG_TYPE, Long.class, 22);
                    }
                    case "S": {
                        return this.PrimitiveToObject(index, Type.SHORT_TYPE, Short.class, 21);
                    }
                    case "Z": {
                        return this.PrimitiveToObject(index, Type.BOOLEAN_TYPE, Boolean.class, 21);
                    }
                }
                InsnList valueGetter = new InsnList();
                if (desc.startsWith("L") || desc.startsWith("[")) {
                    valueGetter.add(new IntInsnNode(25, index));
                } else {
                    RookLogger.Instance().warning("Unknown variable desc: " + desc);
                    valueGetter.add(new LdcInsnNode("Rookout: Unsupported Primitive Type: " + desc));
                }
                return valueGetter;
            }

            private InsnList PrimitiveToObject(int index, Type primitiveType, Class classType, int loadOpcode) {
                InsnList converter = new InsnList();
                converter.add(new IntInsnNode(loadOpcode, index));
                converter.add(new MethodInsnNode(184, Type.getInternalName(classType), "valueOf", Type.getMethodDescriptor(Type.getType(classType), primitiveType), false));
                return converter;
            }

            class LocalState {
                public boolean inScope;
                public boolean isStore;
                public String name;
                public String desc;

                LocalState() {
                }
            }
        };
    }

    class IgnoreClassException
    extends AssertionError {
        IgnoreClassException() {
        }
    }
}

