/*
 * Decompiled with CFR 0.152.
 */
package rook.io.opencensus.tags;

import java.util.logging.Level;
import java.util.logging.Logger;
import rook.com.google.common.annotations.VisibleForTesting;
import rook.io.opencensus.internal.Provider;
import rook.io.opencensus.tags.NoopTags;
import rook.io.opencensus.tags.Tagger;
import rook.io.opencensus.tags.TaggingState;
import rook.io.opencensus.tags.TagsComponent;
import rook.io.opencensus.tags.propagation.TagPropagationComponent;
import rook.javax.annotation.Nullable;

public final class Tags {
    private static final Logger logger = Logger.getLogger(Tags.class.getName());
    private static final TagsComponent tagsComponent = Tags.loadTagsComponent(TagsComponent.class.getClassLoader());

    private Tags() {
    }

    public static Tagger getTagger() {
        return tagsComponent.getTagger();
    }

    public static TagPropagationComponent getTagPropagationComponent() {
        return tagsComponent.getTagPropagationComponent();
    }

    public static TaggingState getState() {
        return tagsComponent.getState();
    }

    @Deprecated
    public static void setState(TaggingState state) {
        tagsComponent.setState(state);
    }

    @VisibleForTesting
    static TagsComponent loadTagsComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("rook.io.opencensus.impl.tags.TagsComponentImpl", true, classLoader), TagsComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for TagsComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("rook.io.opencensus.impllite.tags.TagsComponentImplLite", true, classLoader), TagsComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for TagsComponent, now using default implementation for TagsComponent.", e2);
                return NoopTags.newNoopTagsComponent();
            }
        }
    }
}

