/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.ClassReloader;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.Visitor;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Set;
import java.util.logging.Level;
import rook.org.objectweb.asm.ClassReader;
import rook.org.objectweb.asm.ClassWriter;

public class InstrumentationService
implements ClassFileTransformer {
    private Augs augs = new Augs();
    private Files files = new Files();
    public static InstrumentationService instance;
    private static Instrumentation inst;
    private ClassReloader classReloader = null;
    private static boolean shouldReloadAllClassesOnStart;
    private final CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();

    public static void SetInstrumentation(Instrumentation instrumentation, boolean shouldReloadAllClassesOnStartArg) {
        inst = instrumentation;
        shouldReloadAllClassesOnStart = shouldReloadAllClassesOnStartArg;
    }

    public static InstrumentationService Build() {
        if (null == inst) {
            RookLogger.Instance().log(Level.WARNING, "Java agent was not initialized, instrumentation not available");
            return null;
        }
        if (null != instance) {
            throw new RuntimeException("Cannot create multiple instances!");
        }
        instance = new InstrumentationService();
        return instance;
    }

    public void ResetClassReloader() {
        if (null != this.classReloader) {
            this.classReloader.Stop();
            this.classReloader = null;
        }
        this.classReloader = new ClassReloader(inst, this.augs, this.files);
    }

    public void Close() {
        this.classReloader.Stop();
        this.ClearAugs();
        inst.removeTransformer(this);
        CallbackDispatcher.Close();
        instance = null;
    }

    public void AddAug(String fileName, int lineno, String hash, Aug aug) throws Exception {
        this.classReloader.AddAug(fileName, lineno, hash, aug);
    }

    public void RemoveAug(String augId) {
        this.classReloader.RemoveAug(augId);
    }

    public void ClearAugs() {
        Set<String> augIds = this.augs.AllAugIds();
        for (String augId : augIds) {
            try {
                this.RemoveAug(augId);
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Error while removing aug", e);
            }
        }
    }

    private InstrumentationService() {
        CallbackDispatcher.CreateCallbackDispatcher(this.augs);
        inst.addTransformer(this, true);
        if (shouldReloadAllClassesOnStart) {
            this.ReloadAllClasses();
        }
        this.ResetClassReloader();
    }

    private void ReloadAllClasses() {
        Class[] classes;
        for (Class cls : classes = inst.getAllLoadedClasses()) {
            String className = "";
            try {
                if (null == cls.getName() || !inst.isModifiableClass(cls) || cls.getProtectionDomain() == null || cls.getProtectionDomain().getCodeSource() == this.codeSource || null == (className = cls.getName()) || className.startsWith("com.sun.") || className.startsWith("java.") || className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("lambdainternal.") || className.startsWith("worker.org.gradle") || className.endsWith("rook.io.netty.util.internal.logging.Log4JLogger") || className.startsWith("org.springframework")) continue;
                inst.retransformClasses(cls);
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed to retransform class: " + className, e);
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        try {
            if (null == className || null == protectionDomain || protectionDomain.getCodeSource() == this.codeSource) {
                return null;
            }
            URL location = null;
            if (protectionDomain.getCodeSource() != null) {
                location = protectionDomain.getCodeSource().getLocation();
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(reader, 0);
            Visitor visitor = new Visitor(this.files, this.augs, classLoader, className, location, writer);
            try {
                reader.accept(visitor, 0);
            }
            catch (Visitor.IgnoreClassException e) {
                return null;
            }
            if (!visitor.isHooked()) {
                return null;
            }
            return writer.toByteArray();
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.WARNING, "Failed to transform class: " + className, e);
            return null;
        }
    }

    static {
        shouldReloadAllClassesOnStart = false;
    }
}

