/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Paths;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.Actions;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.TreeNode;
import com.rookout.rook.Processor.Paths.Array;
import com.rookout.rook.Processor.Paths.BasicPath;
import com.rookout.rook.Processor.Paths.Bool;
import com.rookout.rook.Processor.Paths.Char;
import com.rookout.rook.Processor.Paths.FloatNumber;
import com.rookout.rook.Processor.Paths.Marker;
import com.rookout.rook.Processor.Paths.NamespaceResult;
import com.rookout.rook.Processor.Paths.Number;
import com.rookout.rook.Processor.Paths.Opt;
import com.rookout.rook.Processor.Paths.Text;
import com.rookout.rook.Processor.Paths.ToolException;
import java.util.ArrayList;
import java.util.List;

class MapsActions
implements Actions {
    private Namespace namespace;

    MapsActions(Namespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public TreeNode make_namespace(String input, int start, int end, List<TreeNode> elements) {
        try {
            BasicPath a = new BasicPath(input.substring(start, end));
            Namespace result = a.ReadFrom(this.namespace);
            return new NamespaceResult(result);
        }
        catch (Exceptions.ToolException e) {
            return new ToolException(e);
        }
    }

    @Override
    public Text make_string(String input, int start, int end, List<TreeNode> elements) {
        return new Text(elements.get((int)2).text);
    }

    @Override
    public Array make_list(String input, int start, int end, List<TreeNode> elements) {
        TreeFlatter treeFlatter = new TreeFlatter();
        List<TreeNode> list = treeFlatter.run(elements.get(3));
        return new Array(list, input.substring(start, end));
    }

    @Override
    public TreeNode make_comp_exp(String input, int start, int end, List<TreeNode> elements) {
        if (elements.get((int)1).elements.size() == 0) {
            return elements.get(0);
        }
        ArrayList<TreeNode> flatElements = new ArrayList<TreeNode>();
        flatElements.add(elements.get(0));
        for (TreeNode nn : elements.get((int)1).elements) {
            flatElements.add(nn.elements.get(0));
            flatElements.add(nn.elements.get(1));
        }
        while (flatElements.size() > 1) {
            boolean shouldStop = false;
            block2: for (int level = 0; level < 5 && !shouldStop; ++level) {
                for (int i = 1; i < flatElements.size(); i += 2) {
                    Opt currentOpt = (Opt)flatElements.get(i);
                    if (currentOpt.level != level) continue;
                    TreeNode result = currentOpt.executeOperation((TreeNode)flatElements.get(i - 1), (TreeNode)flatElements.get(i + 1));
                    flatElements.set(i - 1, result);
                    flatElements.remove(i + 1);
                    flatElements.remove(i);
                    shouldStop = true;
                    continue block2;
                }
            }
        }
        return (TreeNode)flatElements.get(0);
    }

    @Override
    public TreeNode make_comp_exp_ex(String input, int start, int end, List<TreeNode> elements) {
        return elements.get(2);
    }

    @Override
    public FloatNumber make_float(String input, int start, int end, List<TreeNode> elements) {
        return new FloatNumber(input.substring(start, end).replace(" ", ""));
    }

    @Override
    public Number make_number(String input, int start, int end, List<TreeNode> elements) {
        return new Number(input.substring(start, end).replace(" ", ""));
    }

    @Override
    public Char make_char(String input, int start, int end, List<TreeNode> elements) {
        return new Char(Character.valueOf(input.charAt(start + 1)));
    }

    @Override
    public Bool make_bool(String input, int start, int end, List<TreeNode> elements) {
        return new Bool(input.substring(start, end).replaceAll(" ", ""));
    }

    @Override
    public TreeNode make_opt(String input, int start, int end, List<TreeNode> elements) {
        try {
            return new Opt(input.substring(start, end).replaceAll(" ", ""));
        }
        catch (Exceptions.NewRookInvalidArithmeticPathException e) {
            return new ToolException(e);
        }
    }

    class TreeFlatter {
        List<TreeNode> flatList = new ArrayList<TreeNode>();

        TreeFlatter() {
        }

        List<TreeNode> run(TreeNode currentElements) {
            if (currentElements instanceof Marker) {
                this.flatList.add(currentElements);
            }
            for (TreeNode temp : currentElements.elements) {
                if (temp instanceof Marker) {
                    this.flatList.add(temp);
                    continue;
                }
                this.run(temp);
            }
            return this.flatList;
        }
    }
}

