/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Services.Frame;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FrameNamespace
extends Namespace {
    protected static Pattern localVariable = Pattern.compile("(?:^(\\w+)\\$(?:\\d\\w*)$)");
    private HashMap<String, Object> locals;
    private StackTraceElement stackTraceElement;

    public FrameNamespace(HashMap<String, Object> locals, StackTraceElement stackTraceElement) {
        this.locals = locals;
        this.stackTraceElement = stackTraceElement;
    }

    public FrameNamespace(Frame frame) {
        this.locals = frame.locals;
        this.stackTraceElement = frame.stackTrace.at(0);
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        if (this.locals.containsKey(name)) {
            return new JavaObjectNamespace(this.locals.get(name));
        }
        if (null != this.stackTraceElement.getFileName() && this.stackTraceElement.getFileName().endsWith(".scala")) {
            for (Map.Entry<String, Object> entry : this.locals.entrySet()) {
                Matcher m = localVariable.matcher(entry.getKey());
                if (!m.matches()) continue;
                return new JavaObjectNamespace(entry.getValue());
            }
        }
        throw new Exceptions.RookAttributeNotFound("No such variable: " + name);
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "filename": {
                return new JavaObjectNamespace(this.stackTraceElement.getFileName());
            }
            case "line": {
                return new JavaObjectNamespace(this.stackTraceElement.getLineNumber());
            }
            case "function": 
            case "method": {
                return new JavaObjectNamespace(this.stackTraceElement.getMethodName());
            }
            case "module": 
            case "class": {
                return new JavaObjectNamespace(this.stackTraceElement.getClassName());
            }
            case "locals": {
                return this.GetLocals(args);
            }
            case "dump": {
                return this.GetDump(args);
            }
        }
        return super.CallMethod(name, args);
    }

    private ContainerNamespace GetLocals(String args) throws Exceptions.ToolException {
        Integer max_depth = null;
        if (args.length() > 0) {
            try {
                max_depth = Integer.parseInt(args);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.RookInvalidMethodArguments("locals()", args);
            }
        }
        ContainerNamespace containerNamespace = new ContainerNamespace();
        for (Map.Entry<String, Object> local : this.locals.entrySet()) {
            Matcher m;
            String name = local.getKey();
            if (name.equals("$outer")) continue;
            if (null != this.stackTraceElement.getFileName() && this.stackTraceElement.getFileName().endsWith(".scala") && (m = localVariable.matcher(name)).matches()) {
                name = m.group(1);
            }
            JavaObjectNamespace obj = new JavaObjectNamespace(local.getValue());
            if (max_depth != null) {
                obj.objectDumpConfig.max_depth = max_depth;
            }
            containerNamespace.WriteAttribute(name, obj);
        }
        return containerNamespace;
    }

    private ContainerNamespace GetDump(String args) throws Exceptions.ToolException {
        ContainerNamespace containerNamespace = new ContainerNamespace();
        containerNamespace.WriteAttribute("locals", this.GetLocals(args));
        containerNamespace.WriteAttribute("module", new JavaObjectNamespace(this.stackTraceElement.getClassName()));
        containerNamespace.WriteAttribute("filename", new JavaObjectNamespace(this.stackTraceElement.getFileName()));
        containerNamespace.WriteAttribute("line", new JavaObjectNamespace(this.stackTraceElement.getLineNumber()));
        containerNamespace.WriteAttribute("function", new JavaObjectNamespace(this.stackTraceElement.getMethodName()));
        return containerNamespace;
    }
}

