/*
 * Decompiled with CFR 0.152.
 */
package rook.io.grpc;

import java.util.Collections;
import java.util.List;
import rook.com.google.common.base.MoreObjects;
import rook.com.google.common.base.Objects;
import rook.com.google.common.base.Preconditions;
import rook.io.grpc.Attributes;
import rook.io.grpc.CallOptions;
import rook.io.grpc.ClientStreamTracer;
import rook.io.grpc.ConnectivityState;
import rook.io.grpc.ConnectivityStateInfo;
import rook.io.grpc.EquivalentAddressGroup;
import rook.io.grpc.ExperimentalApi;
import rook.io.grpc.ManagedChannel;
import rook.io.grpc.Metadata;
import rook.io.grpc.MethodDescriptor;
import rook.io.grpc.NameResolver;
import rook.io.grpc.Status;
import rook.javax.annotation.Nonnull;
import rook.javax.annotation.Nullable;
import rook.javax.annotation.concurrent.Immutable;
import rook.javax.annotation.concurrent.NotThreadSafe;
import rook.javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
@NotThreadSafe
public abstract class LoadBalancer {
    public abstract void handleResolvedAddressGroups(List<EquivalentAddressGroup> var1, Attributes var2);

    public abstract void handleNameResolutionError(Status var1);

    public abstract void handleSubchannelState(Subchannel var1, ConnectivityStateInfo var2);

    public abstract void shutdown();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @ThreadSafe
    public static abstract class Factory {
        public abstract LoadBalancer newLoadBalancer(Helper var1);
    }

    @ThreadSafe
    public static abstract class Subchannel {
        public abstract void shutdown();

        public abstract void requestConnection();

        public EquivalentAddressGroup getAddresses() {
            List<EquivalentAddressGroup> groups = this.getAllAddresses();
            Preconditions.checkState(groups.size() == 1, "Does not have exactly one group");
            return groups.get(0);
        }

        public List<EquivalentAddressGroup> getAllAddresses() {
            throw new UnsupportedOperationException();
        }

        public abstract Attributes getAttributes();
    }

    @ThreadSafe
    public static abstract class Helper {
        public Subchannel createSubchannel(EquivalentAddressGroup addrs, Attributes attrs) {
            Preconditions.checkNotNull(addrs, "addrs");
            return this.createSubchannel(Collections.singletonList(addrs), attrs);
        }

        public Subchannel createSubchannel(List<EquivalentAddressGroup> addrs, Attributes attrs) {
            throw new UnsupportedOperationException();
        }

        public void updateSubchannelAddresses(Subchannel subchannel, EquivalentAddressGroup addrs) {
            Preconditions.checkNotNull(addrs, "addrs");
            this.updateSubchannelAddresses(subchannel, Collections.singletonList(addrs));
        }

        public void updateSubchannelAddresses(Subchannel subchannel, List<EquivalentAddressGroup> addrs) {
            throw new UnsupportedOperationException();
        }

        public abstract ManagedChannel createOobChannel(EquivalentAddressGroup var1, String var2);

        public void updateOobChannelAddresses(ManagedChannel channel, EquivalentAddressGroup eag) {
            throw new UnsupportedOperationException();
        }

        public abstract void updateBalancingState(@Nonnull ConnectivityState var1, @Nonnull SubchannelPicker var2);

        public abstract void runSerialized(Runnable var1);

        public abstract NameResolver.Factory getNameResolverFactory();

        public abstract String getAuthority();
    }

    @Immutable
    public static final class PickResult {
        private static final PickResult NO_RESULT = new PickResult(null, null, Status.OK, false);
        @Nullable
        private final Subchannel subchannel;
        @Nullable
        private final ClientStreamTracer.Factory streamTracerFactory;
        private final Status status;
        private final boolean drop;

        private PickResult(@Nullable Subchannel subchannel, @Nullable ClientStreamTracer.Factory streamTracerFactory, Status status, boolean drop) {
            this.subchannel = subchannel;
            this.streamTracerFactory = streamTracerFactory;
            this.status = Preconditions.checkNotNull(status, "status");
            this.drop = drop;
        }

        public static PickResult withSubchannel(Subchannel subchannel, @Nullable ClientStreamTracer.Factory streamTracerFactory) {
            return new PickResult(Preconditions.checkNotNull(subchannel, "subchannel"), streamTracerFactory, Status.OK, false);
        }

        public static PickResult withSubchannel(Subchannel subchannel) {
            return PickResult.withSubchannel(subchannel, null);
        }

        public static PickResult withError(Status error) {
            Preconditions.checkArgument(!error.isOk(), "error status shouldn't be OK");
            return new PickResult(null, null, error, false);
        }

        public static PickResult withDrop(Status status) {
            Preconditions.checkArgument(!status.isOk(), "drop status shouldn't be OK");
            return new PickResult(null, null, status, true);
        }

        public static PickResult withNoResult() {
            return NO_RESULT;
        }

        @Nullable
        public Subchannel getSubchannel() {
            return this.subchannel;
        }

        @Nullable
        public ClientStreamTracer.Factory getStreamTracerFactory() {
            return this.streamTracerFactory;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isDrop() {
            return this.drop;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("subchannel", this.subchannel).add("streamTracerFactory", this.streamTracerFactory).add("status", this.status).add("drop", this.drop).toString();
        }

        public int hashCode() {
            return Objects.hashCode(this.subchannel, this.status, this.streamTracerFactory, this.drop);
        }

        public boolean equals(Object other) {
            if (!(other instanceof PickResult)) {
                return false;
            }
            PickResult that = (PickResult)other;
            return Objects.equal(this.subchannel, that.subchannel) && Objects.equal(this.status, that.status) && Objects.equal(this.streamTracerFactory, that.streamTracerFactory) && this.drop == that.drop;
        }
    }

    public static abstract class PickSubchannelArgs {
        public abstract CallOptions getCallOptions();

        public abstract Metadata getHeaders();

        public abstract MethodDescriptor<?, ?> getMethodDescriptor();
    }

    @ThreadSafe
    public static abstract class SubchannelPicker {
        public abstract PickResult pickSubchannel(PickSubchannelArgs var1);

        public void requestConnection() {
        }
    }
}

