/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.FrameNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.ListNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.Services.StackTrace;
import java.util.ArrayList;
import java.util.HashMap;

public class StackNamespace
extends Namespace {
    private static final int DEFAULT_TRACEBACK_DEPTH = 1000;
    private static final int DEFAULT_FRAMES_DEPTH = 100;
    HashMap<String, Object> locals;
    StackTrace stackTrace;
    StackTraceElement[] stackTraceElements = null;

    public StackNamespace(Frame frame) {
        this.locals = frame.locals;
        this.stackTrace = frame.stackTrace;
    }

    public StackNamespace(StackTrace stackTrace) {
        this.locals = new HashMap();
        this.stackTrace = stackTrace;
    }

    public StackNamespace(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
        this.locals = new HashMap();
    }

    public StackNamespace(HashMap<String, Object> locals, StackTrace stackTrace) {
        this.locals = locals;
        this.stackTrace = stackTrace;
    }

    @Override
    public Namespace ReadKey(Object key) {
        return new FrameNamespace(new HashMap<String, Object>(), this.GetFrame((Integer)key));
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "traceback": {
                return this.Traceback(args);
            }
            case "frames": {
                return this.Frames(args);
            }
        }
        return super.CallMethod(name, args);
    }

    public Namespace Traceback(String args) throws Exceptions.ToolException {
        int depth = 0;
        if (args.length() > 0) {
            try {
                depth = Integer.parseInt(args);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.RookInvalidMethodArguments("traceback()", args);
            }
        } else {
            depth = 1000;
        }
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        depth = Math.min(depth, this.GetStackDepth());
        for (int i = 0; i < depth && null != this.GetFrame(i); ++i) {
            ContainerNamespace frame = new ContainerNamespace();
            StackTraceElement frameElement = this.GetFrame(i);
            frame.WriteAttribute("module", new JavaObjectNamespace(frameElement.getClassName()));
            frame.WriteAttribute("filename", new JavaObjectNamespace(frameElement.getFileName()));
            frame.WriteAttribute("line", new JavaObjectNamespace(frameElement.getLineNumber()));
            frame.WriteAttribute("function", new JavaObjectNamespace(frameElement.getMethodName()));
            result.add(frame);
        }
        return new ListNamespace(result);
    }

    public Namespace Frames(String args) throws Exceptions.ToolException {
        int depth = 0;
        if (args.length() > 0) {
            try {
                depth = Integer.parseInt(args);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.RookInvalidMethodArguments("frames()", args);
            }
        } else {
            depth = 100;
        }
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        depth = Math.min(depth, this.GetStackDepth());
        if (depth > 0) {
            result.add(new FrameNamespace(this.locals, this.GetFrame(0)).CallMethod("dump", ""));
            for (int i = 1; i < depth && null != this.GetFrame(i); ++i) {
                result.add(new FrameNamespace(new HashMap<String, Object>(), this.GetFrame(i)).CallMethod("dump", ""));
            }
        }
        return new ListNamespace(result);
    }

    private StackTraceElement GetFrame(int i) {
        if (this.stackTraceElements != null) {
            return this.stackTraceElements[i];
        }
        return this.stackTrace.at(i);
    }

    private int GetStackDepth() {
        if (this.stackTraceElements != null) {
            return this.stackTraceElements.length;
        }
        return this.stackTrace.depth;
    }
}

