/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.CallbackDispatcher;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.Services.Instrumentation.HashCheck;
import com.rookout.rook.Utils;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import rook.org.objectweb.asm.ClassVisitor;
import rook.org.objectweb.asm.MethodVisitor;
import rook.org.objectweb.asm.Type;
import rook.org.objectweb.asm.tree.AbstractInsnNode;
import rook.org.objectweb.asm.tree.InsnList;
import rook.org.objectweb.asm.tree.InsnNode;
import rook.org.objectweb.asm.tree.LdcInsnNode;
import rook.org.objectweb.asm.tree.LineNumberNode;
import rook.org.objectweb.asm.tree.LocalVariableNode;
import rook.org.objectweb.asm.tree.MethodInsnNode;
import rook.org.objectweb.asm.tree.MethodNode;
import rook.org.objectweb.asm.tree.TypeInsnNode;
import rook.org.objectweb.asm.tree.VarInsnNode;
import rook.org.objectweb.asm.tree.analysis.Analyzer;
import rook.org.objectweb.asm.tree.analysis.AnalyzerException;
import rook.org.objectweb.asm.tree.analysis.BasicValue;
import rook.org.objectweb.asm.tree.analysis.BasicVerifier;

class Visitor
extends ClassVisitor {
    private Files files;
    private Augs augs;
    List<Type> interfaces;
    Type superType;
    private ClassLoader classLoader;
    private String fileName;
    private String className;
    private URL sourceLocation;
    private boolean isCfm = false;
    private boolean hookedClass = false;
    private Augs.AugsInFile validAugs;

    Visitor(Files files, Augs augs, ClassLoader classLoader, String className, URL sourceLocation, ClassVisitor nextVisitor) {
        super(327680, nextVisitor);
        this.files = files;
        this.augs = augs;
        this.interfaces = null;
        this.superType = null;
        this.classLoader = classLoader;
        this.className = className;
        this.sourceLocation = sourceLocation;
        this.validAugs = new Augs.AugsInFile();
    }

    boolean isHooked() {
        return this.hookedClass;
    }

    @Override
    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
        if (null != file) {
            if (file.startsWith("<")) {
                this.fileName = file;
            } else {
                try {
                    Path filePath = Paths.get(file, new String[0]);
                    this.fileName = filePath.getFileName().toString();
                }
                catch (InvalidPathException e) {
                    this.fileName = file;
                }
            }
            this.files.AddClass(this.classLoader, this.fileName, this.className);
            this.isCfm = Utils.IsColdFusionFile(this.fileName);
        }
        for (Map.Entry entry : this.augs.GetAugs(this.fileName).entrySet()) {
            Augs.AugList augList = (Augs.AugList)entry.getValue();
            for (Augs.HashedAug aug : augList) {
                try {
                    if (aug.fileHash != null && !HashCheck.CheckHash(aug.aug, aug.fileHash, this.className, this.sourceLocation, this.fileName)) continue;
                    Augs.AugList augs = (Augs.AugList)this.validAugs.get(entry.getKey());
                    if (augs != null) {
                        augs.add(aug);
                        continue;
                    }
                    Augs.AugList newAugList = new Augs.AugList();
                    newAugList.add(aug);
                    this.validAugs.put(entry.getKey(), newAugList);
                }
                catch (Throwable e) {
                    String message = "Exception while initializing aug during visitSource on aug";
                    RookLogger.Instance().log(Level.SEVERE, message, e);
                    aug.aug.SetError(new RookError(e, message));
                }
            }
        }
        if (this.validAugs.isEmpty()) {
            throw new IgnoreClassException();
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superType = superName == null ? null : Type.getObjectType(superName);
        this.interfaces = new ArrayList<Type>();
        for (int i = 0; i < interfaces.length; ++i) {
            this.interfaces.add(Type.getObjectType(interfaces[i]));
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (null == this.fileName || this.validAugs.isEmpty()) {
            throw new IgnoreClassException();
        }
        return new MethodNode(327680, access, name, desc, signature, exceptions){

            @Override
            public void visitEnd() {
                boolean isCtor = this.name.equals("<init>");
                boolean firstInsnFound = false;
                boolean hookedMethod = false;
                ArrayList<Integer> hookedLines = new ArrayList<Integer>();
                boolean lastLine = false;
                ListIterator<AbstractInsnNode> insn = this.instructions.iterator();
                while (insn.hasNext()) {
                    AbstractInsnNode node = insn.next();
                    if (node.getType() == 15) {
                        Augs.AugList augList;
                        LineNumberNode lineNumberNode = (LineNumberNode)node;
                        if (hookedLines.contains(lineNumberNode.line) || (augList = (Augs.AugList)Visitor.this.validAugs.get(lineNumberNode.line)) == null || augList.isEmpty()) continue;
                        if (isCtor && !firstInsnFound) {
                            for (Augs.HashedAug aug : augList) {
                                aug.aug.SetError(new RookError(new Exceptions.RookInvalidPositionException()));
                            }
                            continue;
                        }
                        if (this.instructions.get(insn.nextIndex()).getType() == 14) {
                            node = insn.next();
                        }
                        InsnList hook = this.BuildHook(lineNumberNode);
                        this.instructions.insert(node, hook);
                        for (Augs.HashedAug aug : augList) {
                            aug.aug.SetActive();
                        }
                        hookedMethod = true;
                        Visitor.this.hookedClass = true;
                        hookedLines.add(lineNumberNode.line);
                        continue;
                    }
                    if (node.getType() == 14 || node.getType() == 8) continue;
                    firstInsnFound = true;
                }
                if (hookedMethod) {
                    this.maxStack += 6;
                    this.verify();
                }
                this.accept(methodVisitor);
            }

            private void verify() {
                BasicVerifier verifier = new BasicVerifier();
                Analyzer<BasicValue> a = new Analyzer<BasicValue>(verifier);
                try {
                    a.analyze(Visitor.this.className, this);
                }
                catch (AnalyzerException e) {
                    throw new BytecodeVerificationException("Error while transforming method", e);
                }
            }

            private InsnList BuildHook(LineNumberNode hookNode) {
                int i;
                InsnList hook = new InsnList();
                hook.add(new LdcInsnNode(Visitor.this.fileName));
                hook.add(new LdcInsnNode((Object)hookNode.line));
                hook.add(new TypeInsnNode(187, Type.getInternalName(HashMap.class)));
                hook.add(new InsnNode(89));
                hook.add(new MethodInsnNode(183, Type.getInternalName(HashMap.class), "<init>", "()V", false));
                LocalVariables[] variables = new LocalVariables[this.maxLocals];
                for (i = 0; i < variables.length; ++i) {
                    variables[i] = new LocalVariables();
                }
                this.LoadArguments(variables);
                this.ScanMethod(hookNode, variables);
                for (i = 0; i < variables.length; ++i) {
                    if (!variables[i].inScope || !variables[i].isStore || Visitor.this.isCfm && !variables[i].desc.equals("Lcoldfusion/runtime/Variable;") && !variables[i].name.equals("this")) continue;
                    hook.add(new InsnNode(89));
                    hook.add(new LdcInsnNode(variables[i].name));
                    hook.add(this.GetValue(variables[i].desc, i));
                    hook.add(new MethodInsnNode(182, Type.getInternalName(HashMap.class), "put", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Object.class), Type.getType(Object.class)), false));
                    hook.add(new InsnNode(87));
                }
                hook.add(new MethodInsnNode(184, "com/rookout/agent/StaticCallback", "Callback", CallbackDispatcher.CallbackDescriptor, false));
                return hook;
            }

            private void LoadArguments(LocalVariables[] variables) {
                Type[] argumentsTypes;
                int argumentIndex = 0;
                if ((this.access & 8) == 0) {
                    variables[argumentIndex].isStore = true;
                    ++argumentIndex;
                }
                for (Type argumentsType : argumentsTypes = Type.getArgumentTypes(this.desc)) {
                    variables[argumentIndex].isStore = true;
                    String descriptor = argumentsType.getDescriptor();
                    if (descriptor.equals("D") || descriptor.equals("J")) {
                        argumentIndex += 2;
                        continue;
                    }
                    ++argumentIndex;
                }
            }

            private void ScanMethod(LineNumberNode hookNode, LocalVariables[] variables) {
                AbstractInsnNode insnIterator;
                ListIterator<AbstractInsnNode> it = this.instructions.iterator();
                while (it.hasNext() && (insnIterator = it.next()) != hookNode) {
                    if (insnIterator.getType() == 8) {
                        for (Object iterator : this.localVariables) {
                            LocalVariableNode localVariableNode = (LocalVariableNode)iterator;
                            if (localVariableNode.start == insnIterator) {
                                variables[localVariableNode.index].inScope = true;
                                variables[localVariableNode.index].name = localVariableNode.name;
                                variables[localVariableNode.index].desc = localVariableNode.desc;
                                continue;
                            }
                            if (localVariableNode.end != insnIterator) continue;
                            variables[localVariableNode.index].inScope = false;
                            variables[localVariableNode.index].isStore = false;
                            variables[localVariableNode.index].name = null;
                            variables[localVariableNode.index].desc = null;
                        }
                        continue;
                    }
                    if (insnIterator.getType() != 2) continue;
                    VarInsnNode varInsnNode = (VarInsnNode)insnIterator;
                    if (varInsnNode.getOpcode() == 54 || varInsnNode.getOpcode() == 56 || varInsnNode.getOpcode() == 58) {
                        variables[varInsnNode.var].isStore = true;
                        continue;
                    }
                    if (varInsnNode.getOpcode() != 57 && varInsnNode.getOpcode() != 55) continue;
                    variables[varInsnNode.var].isStore = true;
                    variables[varInsnNode.var + 1].isStore = false;
                }
            }

            private InsnList GetValue(String desc, int index) {
                switch (desc) {
                    case "B": {
                        return this.PrimitiveToObject(index, Type.BYTE_TYPE, Byte.class, 21);
                    }
                    case "C": {
                        return this.PrimitiveToObject(index, Type.CHAR_TYPE, Character.class, 21);
                    }
                    case "D": {
                        return this.PrimitiveToObject(index, Type.DOUBLE_TYPE, Double.class, 24);
                    }
                    case "F": {
                        return this.PrimitiveToObject(index, Type.FLOAT_TYPE, Float.class, 23);
                    }
                    case "I": {
                        return this.PrimitiveToObject(index, Type.INT_TYPE, Integer.class, 21);
                    }
                    case "J": {
                        return this.PrimitiveToObject(index, Type.LONG_TYPE, Long.class, 22);
                    }
                    case "S": {
                        return this.PrimitiveToObject(index, Type.SHORT_TYPE, Short.class, 21);
                    }
                    case "Z": {
                        return this.PrimitiveToObject(index, Type.BOOLEAN_TYPE, Boolean.class, 21);
                    }
                }
                InsnList valueGetter = new InsnList();
                if (desc.startsWith("L") || desc.startsWith("[")) {
                    valueGetter.add(new VarInsnNode(25, index));
                } else {
                    RookLogger.Instance().warning("Unknown variable desc: " + desc);
                    valueGetter.add(new LdcInsnNode("Rookout: Unsupported Primitive Type: " + desc));
                }
                return valueGetter;
            }

            private InsnList PrimitiveToObject(int index, Type primitiveType, Class classType, int loadOpcode) {
                InsnList converter = new InsnList();
                converter.add(new VarInsnNode(loadOpcode, index));
                converter.add(new MethodInsnNode(184, Type.getInternalName(classType), "valueOf", Type.getMethodDescriptor(Type.getType(classType), primitiveType), false));
                return converter;
            }

            class LocalVariables {
                public boolean inScope;
                public boolean isStore;
                public String name;
                public String desc;

                LocalVariables() {
                }
            }
        };
    }

    class BytecodeVerificationException
    extends AssertionError {
        BytecodeVerificationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    class IgnoreClassException
    extends AssertionError {
        IgnoreClassException() {
        }
    }
}

