/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;

class HashCheck {
    HashCheck() {
    }

    static String getBufferHash(byte[] buffer) throws NoSuchAlgorithmException, IOException {
        String fileContents = new String(buffer).replace("\r\n", "\n").replace("\r\u0000\n\u0000", "\n\u0000").replace("\r", "\n");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(fileContents.getBytes("UTF-8"));
        return Utils.bytesToHex(hash);
    }

    static String getFileHash(String filename) throws NoSuchAlgorithmException, IOException {
        return HashCheck.getBufferHash(Files.readAllBytes(Paths.get(filename, new String[0])));
    }

    static String getJarFileHash(JarFile jar, JarEntry filename) throws NoSuchAlgorithmException, IOException {
        return HashCheck.getBufferHash(Utils.getEntryBytes(jar, filename));
    }

    static ArrayList<String> getJarHashes(JarFile jar, String fileName) throws NoSuchAlgorithmException, IOException {
        ArrayList<String> hashes = new ArrayList<String>();
        Enumeration<JarEntry> elements = jar.entries();
        while (elements.hasMoreElements()) {
            JarEntry entry = elements.nextElement();
            if (!entry.getName().endsWith(fileName)) continue;
            hashes.add(HashCheck.getJarFileHash(jar, entry));
        }
        return hashes;
    }

    static String getDecodedURLPath(URL url) throws URISyntaxException {
        return url.toURI().getSchemeSpecificPart();
    }

    static boolean CheckHash(Aug aug, String hash, String className, URL sourceLocation, String fileName) {
        try {
            ArrayList<String> hashes;
            block17: {
                if (sourceLocation == null) {
                    aug.SendWarning(new RookError(new Exceptions.RookSourceLocationMissing(fileName, className)));
                    return true;
                }
                if (hash == null) {
                    return true;
                }
                hashes = new ArrayList<String>();
                try {
                    File[] sourceFiles;
                    String sourceLocationPath;
                    if (Utils.IsColdFusionFile(fileName).booleanValue()) {
                        String filePath = sourceLocation.getPath();
                        String localHash = HashCheck.getFileHash(filePath);
                        if (!localHash.equals(hash)) {
                            aug.SetError(new RookError(new Exceptions.RookHashMismatchException(filePath, hash, localHash)));
                            return false;
                        }
                        return true;
                    }
                    URLConnection connection = sourceLocation.openConnection();
                    if (connection instanceof JarURLConnection) {
                        URI url = new URI(sourceLocation.getPath().substring(0, sourceLocation.getPath().indexOf(33)));
                        hashes.addAll(HashCheck.getJarHashes(new JarFile(url.getPath()), fileName));
                        break block17;
                    }
                    if (connection.getURL().getFile().endsWith(".jar")) {
                        JarFile jar = new JarFile(HashCheck.getDecodedURLPath(connection.getURL()));
                        hashes.addAll(HashCheck.getJarHashes(jar, fileName));
                        break block17;
                    }
                    if (!sourceLocation.getPath().endsWith("/") && !sourceLocation.getPath().endsWith("\\")) break block17;
                    try {
                        sourceLocationPath = Paths.get(HashCheck.getDecodedURLPath(sourceLocation), new String[0]).toString();
                    }
                    catch (IllegalArgumentException | URISyntaxException e) {
                        sourceLocationPath = sourceLocation.getFile();
                    }
                    for (File file : sourceFiles = new File[]{Paths.get(sourceLocationPath, fileName).toFile(), Paths.get(sourceLocationPath, className.substring(0, className.lastIndexOf("/")).replace("/", File.separator), fileName).toFile()}) {
                        if (!file.isFile()) continue;
                        hashes.add(HashCheck.getFileHash(file.getAbsolutePath()));
                    }
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    aug.SendWarning(new RookError(new Exceptions.RookHashCalculationFailed(fileName, className, (Throwable)e)));
                    return true;
                }
            }
            if (hashes.isEmpty()) {
                aug.SendWarning(new RookError(new Exceptions.RookSourceFileNotFound(fileName)));
                return true;
            }
            int count = 0;
            for (String h : hashes) {
                if (!h.equals(hash)) continue;
                ++count;
            }
            if (count == 0) {
                aug.SetError(new RookError(new Exceptions.RookHashMismatchException(fileName, hash, (String)hashes.get(0))));
                return false;
            }
            if (count == 1) {
                return true;
            }
            aug.SendWarning(new RookError(new Exceptions.RookMultipleSoruceFilesFound(fileName)));
            return true;
        }
        catch (Throwable e) {
            String message = "Exception while performing hash check";
            RookLogger.Instance().log(Level.WARNING, message, e);
            aug.SendWarning(new RookError(e, message));
            return true;
        }
    }
}

