/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Logging;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Services.Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LoggingService {
    private final HashMap<String, Handler> handlers = new HashMap();
    private static boolean ignoreExceptions = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddLoggingAug(String logger, Aug aug) {
        HashMap<String, Handler> hashMap = this.handlers;
        synchronized (hashMap) {
            Handler handler = this.handlers.get(logger);
            if (null == handler) {
                handler = new Handler(logger);
                this.handlers.put(logger, handler);
            }
            handler.AddAug(aug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RemoveAug(String augId) {
        HashMap<String, Handler> hashMap = this.handlers;
        synchronized (hashMap) {
            for (Handler handler : this.handlers.values()) {
                handler.RemoveAug(augId);
            }
        }
        this.PruneHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ClearAugs() {
        HashMap<String, Handler> hashMap = this.handlers;
        synchronized (hashMap) {
            for (Handler handler : this.handlers.values()) {
                handler.ClearAugs();
            }
        }
        this.PruneHandlers();
    }

    public void Close() {
        this.ClearAugs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void PruneHandlers() {
        HashMap<String, Handler> hashMap = this.handlers;
        synchronized (hashMap) {
            ArrayList<String> handlersToPrune = new ArrayList<String>();
            for (Map.Entry<String, Handler> entry : this.handlers.entrySet()) {
                if (!entry.getValue().Empty()) continue;
                handlersToPrune.add(entry.getKey());
            }
            for (String handler : handlersToPrune) {
                this.handlers.get(handler).close();
                this.handlers.remove(handler);
            }
        }
    }

    public class Handler {
        private String name;
        private final HashMap<String, Aug> augs = new HashMap();

        Handler(String name) {
            this.name = name;
        }

        public void close() throws SecurityException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runAugs(Frame frame, ContainerNamespace extracted) {
            HashMap<String, Aug> hashMap = this.augs;
            synchronized (hashMap) {
                for (Aug aug : this.augs.values()) {
                    aug.Execute(frame, extracted);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void AddAug(Aug aug) {
            HashMap<String, Aug> hashMap = this.augs;
            synchronized (hashMap) {
                this.augs.put(aug.augId, aug);
                aug.SetActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void RemoveAug(String augId) {
            HashMap<String, Aug> hashMap = this.augs;
            synchronized (hashMap) {
                Aug aug = this.augs.get(augId);
                if (null == aug) {
                    return;
                }
                this.augs.remove(augId);
                aug.SetRemoved();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ClearAugs() {
            HashMap<String, Aug> hashMap = this.augs;
            synchronized (hashMap) {
                Object[] aug_ids;
                for (Object aug_id : aug_ids = this.augs.keySet().toArray()) {
                    this.RemoveAug((String)aug_id);
                }
            }
        }

        boolean Empty() {
            return this.augs.isEmpty();
        }
    }
}

