/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Com;

import com.rookout.Messages;
import com.rookout.rook.AugManager;
import com.rookout.rook.Com.AgentComWs;
import com.rookout.rook.RookLogger;
import java.util.logging.Level;
import rook.com.google.protobuf.Any;
import rook.com.google.protobuf.InvalidProtocolBufferException;
import rook.org.json.JSONObject;

public class CommandHandler {
    AgentComWs agentCom;
    AugManager augManager;

    public CommandHandler(AgentComWs agentCom, final AugManager augManager) {
        this.agentCom = agentCom;
        this.augManager = augManager;
        this.agentCom.on("InitialAugsCommand", new AgentComWs.Callable(){

            @Override
            public void call(Any any) {
                augManager.ClearAugs();
                try {
                    Messages.InitialAugsCommand initialAugsCommand = Messages.InitialAugsCommand.parseFrom(any.getValue());
                    for (String aug : initialAugsCommand.getAugsList()) {
                        augManager.AddAug(new JSONObject(aug));
                    }
                }
                catch (InvalidProtocolBufferException exc) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to create message", exc);
                }
            }
        });
        this.agentCom.on("RemoveAugCommand", new AgentComWs.Callable(){

            @Override
            public void call(Any any) {
                try {
                    Messages.RemoveAugCommand removeAugCommand = Messages.RemoveAugCommand.parseFrom(any.getValue());
                    augManager.RemoveAug(removeAugCommand.getAugId());
                }
                catch (InvalidProtocolBufferException exc) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to create message", exc);
                }
            }
        });
        this.agentCom.on("AddAugCommand", new AgentComWs.Callable(){

            @Override
            public void call(Any any) {
                try {
                    Messages.AddAugCommand addAugCommand = Messages.AddAugCommand.parseFrom(any.getValue());
                    augManager.AddAug(new JSONObject(addAugCommand.getAugJson()));
                }
                catch (InvalidProtocolBufferException exc) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to create message", exc);
                }
            }
        });
    }
}

