/*
 * Decompiled with CFR 0.152.
 */
package rook.org.glassfish.tyrus.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import rook.org.glassfish.tyrus.core.TyrusWebSocket;
import rook.org.glassfish.tyrus.core.frame.Frame;

class OutputStreamToAsyncBinaryAdapter
extends OutputStream {
    private final TyrusWebSocket socket;

    public OutputStreamToAsyncBinaryAdapter(TyrusWebSocket socket) {
        this.socket = socket;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        Future<Frame> future = this.socket.sendBinary(b, off, len, false);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte[] byteArray = new byte[]{(byte)i};
        this.write(byteArray, 0, byteArray.length);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.socket.sendBinary(new byte[0], true);
    }
}

