/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.AgentInfo;
import com.rookout.EnvelopeOuterClass;
import com.rookout.Messages;
import com.rookout.rook.Com.AgentCom;
import com.rookout.rook.Com.OutputBase;
import com.rookout.rook.ComWs.Information;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import rook.com.google.protobuf.Any;
import rook.com.google.protobuf.InvalidProtocolBufferException;
import rook.com.google.protobuf.Message;
import rook.org.glassfish.tyrus.client.ClientManager;
import rook.org.glassfish.tyrus.core.HandshakeException;

public class AgentComWs
implements AgentCom {
    private Map<String, String> labels;
    private String[] tags;
    protected String agentId;
    private ConnectionHolder connectionHolder;
    private boolean connected;
    private boolean stopping;
    private Double currentBackoff;
    private Future<Session> sessionFuture = null;
    private OutputBase output;
    private URI agentUri;
    private String token;
    private int retries = 0;
    private long lastSuccessfulConnection = 0L;
    private List<EnvelopeOuterClass.Envelope> pendingMessages;
    private ConcurrentHashMap<String, List<MessageCallback>> callbacks;

    public AgentComWs(OutputBase output, String agentHost, int agentPort, String token, Map<String, String> labels, String[] tags) throws URISyntaxException {
        Config config = Config.Instance();
        this.output = output;
        this.agentUri = new URI(String.format("%s:%d/v1", agentHost, agentPort));
        this.labels = labels;
        this.tags = tags;
        this.resetId();
        this.output.setAgentId(this.agentId);
        this.currentBackoff = config.AgentComConfiguration$BACK_OFF;
        this.token = token;
        this.connectionHolder = new ConnectionHolder();
        this.callbacks = new ConcurrentHashMap();
        this.pendingMessages = new ArrayList<EnvelopeOuterClass.Envelope>();
    }

    public <T extends Message> void add(T message) {
        this.send(this.wrapInEnvelope(message));
    }

    public void on(String messageName, Callable callback) {
        this.registerCallback(messageName, callback, true);
    }

    public void once(String messageName, Callable callback) {
        this.registerCallback(messageName, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCallback(String messageName, Callable callback, Boolean persistent) {
        MessageCallback messageCallback = new MessageCallback(callback, persistent);
        ConcurrentHashMap<String, List<MessageCallback>> concurrentHashMap = this.callbacks;
        synchronized (concurrentHashMap) {
            if (!this.callbacks.containsKey(messageName)) {
                this.callbacks.put(messageName, Collections.synchronizedList(new ArrayList()));
            }
            this.callbacks.get(messageName).add(messageCallback);
        }
    }

    private CountDownLatch awaitMessage(String messageName) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.once(messageName, new Callable(){

            @Override
            public void call(Any any) {
                latch.countDown();
            }
        });
        return latch;
    }

    private void registerAgent() throws IOException {
        Information info = Information.Collect();
        info.agentId = this.agentId;
        info.labels = this.labels;
        info.tags = this.tags;
        AgentInfo.AgentInformation packedInfo = Information.PackAgentInfo(info);
        CountDownLatch gotInitialAugsCommand = this.awaitMessage("InitialAugsCommand");
        Messages.NewAgentMessage.Builder m = Messages.NewAgentMessage.newBuilder();
        m.setAgentInfo(packedInfo);
        this.connected = true;
        this.lastSuccessfulConnection = System.currentTimeMillis();
        this.send(this.wrapInEnvelope(m.build()));
        try {
            gotInitialAugsCommand.await(Config.Instance().AgentCom$WS_CONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException exc) {
            throw new IOException("Failed to sync with agent. Will keep trying");
        }
    }

    private <T extends Message> EnvelopeOuterClass.Envelope wrapInEnvelope(T message) {
        EnvelopeOuterClass.Envelope.Builder envelope = EnvelopeOuterClass.Envelope.newBuilder();
        envelope.setTimestamp(Utils.dateToTimestamp(new Date()));
        envelope.setMsg(Any.pack(message));
        return envelope.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(EnvelopeOuterClass.Envelope envelope) {
        ConnectionHolder connectionHolder = this.connectionHolder;
        synchronized (connectionHolder) {
            if (!this.connected) {
                List<EnvelopeOuterClass.Envelope> list = this.pendingMessages;
                synchronized (list) {
                    if (this.pendingMessages.size() < Config.Instance().AgentComConfiguration$MAX_QUEUED_MESSAGES) {
                        this.pendingMessages.add(envelope);
                        return;
                    }
                }
            }
            try {
                this.connectionHolder.connection.getBasicRemote().sendBinary(ByteBuffer.wrap(envelope.toByteArray()));
            }
            catch (IOException | IllegalStateException exception) {
                // empty catch block
            }
        }
    }

    private void waitForConnection() throws Exceptions.RookInvalidToken, IOException {
        try {
            this.sessionFuture.get(Config.Instance().AgentCom$WS_CONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (ExecutionException exc) {
            this.sessionFuture.cancel(false);
            Throwable cause = exc.getCause();
            if (cause != null && cause instanceof DeploymentException && (cause = cause.getCause()) != null && cause instanceof HandshakeException && ((HandshakeException)cause).getHttpStatusCode() == 403) {
                throw new Exceptions.RookInvalidToken();
            }
            throw new IOException("Failed to connect to agent. Will keep trying");
        }
        catch (InterruptedException | TimeoutException e) {
            this.sessionFuture.cancel(false);
            throw new IOException("Failed to connect to agent. Will keep trying");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ConnectToAgent() throws Exceptions.RookInvalidToken {
        this.StartNewConnection();
        try {
            ArrayList<EnvelopeOuterClass.Envelope> copyPendingMessages;
            this.waitForConnection();
            this.registerAgent();
            List<EnvelopeOuterClass.Envelope> list = this.pendingMessages;
            synchronized (list) {
                copyPendingMessages = new ArrayList<EnvelopeOuterClass.Envelope>(this.pendingMessages);
                this.pendingMessages.clear();
            }
            for (EnvelopeOuterClass.Envelope env : copyPendingMessages) {
                this.send(env);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exceptions.RookInvalidToken e) {
            throw e;
        }
        catch (IOException e) {
            this.reconnect(e.getMessage(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncomingMessage(ByteBuffer data) {
        EnvelopeOuterClass.Envelope envelope;
        try {
            envelope = EnvelopeOuterClass.Envelope.parseFrom(data.array());
        }
        catch (InvalidProtocolBufferException exc) {
            RookLogger.Instance().log(Level.SEVERE, "Invalid protocol exception", exc);
            return;
        }
        String[] splittedEnvelopeType = envelope.getMsg().getTypeUrl().split("\\.", -1);
        String partialTypeName = splittedEnvelopeType[splittedEnvelopeType.length - 1];
        ConcurrentHashMap<String, List<MessageCallback>> concurrentHashMap = this.callbacks;
        synchronized (concurrentHashMap) {
            List<MessageCallback> cb = this.callbacks.get(partialTypeName);
            Any any = envelope.getMsg();
            ArrayList<MessageCallback> remainingCallbacks = new ArrayList<MessageCallback>();
            for (MessageCallback messageCallback : cb) {
                messageCallback.callback.call(any);
                if (!messageCallback.persistent.booleanValue()) continue;
                remainingCallbacks.add(messageCallback);
            }
            this.callbacks.put(partialTypeName, remainingCallbacks);
        }
    }

    private void StartNewConnection() {
        RookLogger.Instance().info("Connecting to agent-\t" + this.agentUri);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator(new ClientEndpointConfig.Configurator(){

            @Override
            public void beforeRequest(Map<String, List<String>> headers) {
                headers.put("User-Agent", Arrays.asList(String.format("RookoutAgent/%s+%s", Config.Instance().VersionConfiguration$VERSION, Config.Instance().VersionConfiguration$COMMIT)));
                if (AgentComWs.this.token != null) {
                    headers.put("X-Rookout-Token", Arrays.asList(AgentComWs.this.token));
                }
            }
        }).build();
        ClientManager client = ClientManager.createClient();
        try {
            this.sessionFuture = client.asyncConnectToServer(new Endpoint(){
                Timer timer;
                TimerTask closeTask;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onOpen(Session session, EndpointConfig config) {
                    ConnectionHolder connectionHolder = AgentComWs.this.connectionHolder;
                    synchronized (connectionHolder) {
                        AgentComWs.this.connectionHolder.connection = session;
                        if (this.timer != null) {
                            this.timer.cancel();
                        }
                        this.timer = new Timer();
                        this.timer.schedule(new TimerTask(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                ConnectionHolder connectionHolder = AgentComWs.this.connectionHolder;
                                synchronized (connectionHolder) {
                                    if (AgentComWs.this.connectionHolder.connection == null) {
                                        return;
                                    }
                                    try {
                                        AgentComWs.this.connectionHolder.connection.getBasicRemote().sendPing(ByteBuffer.wrap("ping message client".getBytes()));
                                    }
                                    catch (IOException | IllegalStateException exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }, 0L, TimeUnit.SECONDS.toMillis(Config.Instance().AgentCom$WS_PING_INTERVAL.intValue()));
                        this.initCloseTask();
                        AgentComWs.this.connectionHolder.connection.addMessageHandler(new MessageHandler.Whole<ByteBuffer>(){

                            @Override
                            public void onMessage(ByteBuffer data) {
                                AgentComWs.this.handleIncomingMessage(data);
                            }
                        });
                        AgentComWs.this.connectionHolder.connection.addMessageHandler(new MessageHandler.Whole<PongMessage>(){

                            @Override
                            public void onMessage(PongMessage message) {
                                this.initCloseTask();
                            }
                        });
                        try {
                            AgentComWs.this.connectionHolder.connection.getBasicRemote().sendPing(ByteBuffer.wrap("ping message client".getBytes()));
                        }
                        catch (IOException | IllegalStateException exception) {
                            // empty catch block
                        }
                    }
                }

                void initCloseTask() {
                    if (this.closeTask != null) {
                        this.closeTask.cancel();
                    }
                    this.closeTask = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ConnectionHolder connectionHolder = AgentComWs.this.connectionHolder;
                            synchronized (connectionHolder) {
                                if (AgentComWs.this.connectionHolder.connection == null) {
                                    return;
                                }
                                try {
                                    AgentComWs.this.connectionHolder.connection.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    };
                    this.timer.schedule(this.closeTask, TimeUnit.SECONDS.toMillis(Config.Instance().AgentCom$WS_PING_TIMEOUT.intValue()));
                }

                @Override
                public void onClose(Session session, CloseReason closeReason) {
                    RookLogger.Instance().log(Level.INFO, "Websocket connection closed: " + closeReason.toString());
                    this.reset("Connection closed", true);
                }

                @Override
                public void onError(Session session, Throwable t) {
                    RookLogger.Instance().log(Level.SEVERE, "Websocket error occur", t);
                    this.reset(t.getMessage(), true);
                }

                private void reset(String reason, boolean closed) {
                    this.closeTask.cancel();
                    AgentComWs.this.reconnect(reason, true);
                }
            }, config, this.agentUri);
        }
        catch (DeploymentException exc) {
            RookLogger.Instance().log(Level.SEVERE, "Fail to connect server", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConnection(boolean closed) {
        ConnectionHolder connectionHolder = this.connectionHolder;
        synchronized (connectionHolder) {
            if (!closed && this.connectionHolder.connection != null) {
                try {
                    this.connectionHolder.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.connectionHolder.connection = null;
            this.connected = false;
        }
    }

    private void reconnect(String reason, boolean closed) {
        if (this.stopping) {
            return;
        }
        long MaxSleepMs = Config.Instance().AgentCom$WS_RESET_BACKOFF_TIMEOUT * 1000;
        if (this.connected && System.currentTimeMillis() > this.lastSuccessfulConnection + MaxSleepMs) {
            this.retries = 0;
            this.currentBackoff = Config.Instance().AgentComConfiguration$BACK_OFF;
        }
        this.resetConnection(closed);
        Timer timer = new Timer("rookout_timer", true);
        ++this.retries;
        this.currentBackoff = Math.min(this.currentBackoff * 2.0, (double)Config.Instance().AgentCom$MAX_SLEEP.intValue());
        RookLogger.Instance().info(String.format("Connection failed; reason = %s, retry = #%d, waiting %fs", reason, this.retries, this.currentBackoff));
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    AgentComWs.this.ConnectToAgent();
                }
                catch (Exceptions.RookInvalidToken e) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to connect to the agent: ", e.getMessage());
                }
            }
        }, (long)(this.currentBackoff * 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Close() {
        this.stopping = true;
        ConnectionHolder connectionHolder = this.connectionHolder;
        synchronized (connectionHolder) {
            try {
                this.connectionHolder.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.output.FlushMessages();
        this.output.StopSendingMessages();
    }

    private void resetId() {
        this.agentId = UUID.randomUUID().toString().replace("-", "");
    }

    class ConnectionHolder {
        private Session connection;

        ConnectionHolder() {
        }
    }

    private class MessageCallback {
        Callable callback;
        Boolean persistent;

        public MessageCallback(Callable callback, Boolean persistent) {
            this.callback = callback;
            this.persistent = persistent;
        }
    }

    public static interface Callable {
        public void call(Any var1);
    }
}

