/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.RookOptions;
import com.rookout.rook.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JavaAgent {
    private static RookOptions opts;
    private static List<String> TRUE_VALUES;

    public static void premain(String agentArgs, Instrumentation instrumentation) throws Exception {
        if (JavaAgent.isLoaded()) {
            return;
        }
        System.setProperty("com.rookout.rook.present", "TRUE");
        String disable = System.getenv("ROOKOUT_DISABLE_AUTOSTART");
        if (disable != null && !disable.equals("0")) {
            return;
        }
        opts = RookOptions.deserialize(System.getProperties());
        JavaAgent.opts.reload_classes = false;
        JavaAgent.getDisableClassTransformOption();
        JavaAgent.InitRook(instrumentation);
        Singleton.start();
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        if (JavaAgent.isLoaded()) {
            return;
        }
        System.setProperty("com.rookout.rook.present", "TRUE");
        opts = RookOptions.deserialize(System.getProperties());
        if (JavaAgent.opts.reload_classes == null) {
            String v = System.getenv("ROOKOUT_DISABLE_CLASS_RELOADING");
            JavaAgent.opts.reload_classes = v != null ? Boolean.valueOf(v.equals("1")) : Boolean.valueOf(true);
        }
        JavaAgent.getDisableClassTransformOption();
        JavaAgent.InitRook(instrumentation);
    }

    private static boolean isLoaded() {
        String rookPresent = System.getProperty("com.rookout.rook.present");
        if (rookPresent != null) {
            return rookPresent.equals("TRUE");
        }
        return false;
    }

    private static void getDisableClassTransformOption() {
        if (JavaAgent.opts.disable_class_transform == null) {
            String v = System.getenv("ROOKOUT_DISABLE_CLASS_TRANSFORM");
            JavaAgent.opts.disable_class_transform = v != null ? Boolean.valueOf(v.equals("1")) : Boolean.valueOf(false);
        }
    }

    private static void InitRook(Instrumentation instrumentation) {
        JavaAgent.addStaticCallbackToBootstrapLoader(instrumentation);
        JavaAgent.loadOptions();
        Singleton.init(opts, instrumentation);
    }

    private static void addStaticCallbackToBootstrapLoader(Instrumentation instrumentation) {
        try {
            String[] filesToCopy;
            File tempFile = File.createTempFile("rookagent", "");
            tempFile.deleteOnExit();
            JarFile self = new JarFile(JavaAgent.class.getProtectionDomain().getCodeSource().getLocation().getFile());
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (String fileToCopy : filesToCopy = new String[]{"com/rookout/agent/StaticCallback.class"}) {
                int length;
                InputStream input = self.getInputStream(self.getEntry(fileToCopy));
                zipOutputStream.putNextEntry(new ZipEntry(fileToCopy));
                byte[] bytes = new byte[1024];
                while ((length = input.read(bytes)) >= 0) {
                    zipOutputStream.write(bytes, 0, length);
                }
            }
            zipOutputStream.close();
            fileOutputStream.close();
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(tempFile.getPath()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String GetConfigurationString(String env) {
        String v = System.getenv(env);
        if (v == null) {
            v = System.getProperty(env);
        }
        return v;
    }

    public static void SetOptions(RookOptions options) {
        opts = options;
    }

    public static void loadOptions() {
        String v;
        if (JavaAgent.opts.debug == null) {
            v = JavaAgent.GetConfigurationString("ROOKOUT_DEBUG");
            JavaAgent.opts.debug = v != null ? Boolean.valueOf(TRUE_VALUES.contains(v)) : Boolean.valueOf(false);
        }
        if (JavaAgent.opts.log_to_stderr == null && (v = JavaAgent.GetConfigurationString("ROOKOUT_LOG_TO_STDERR")) != null) {
            JavaAgent.opts.log_to_stderr = TRUE_VALUES.contains(v);
        }
        if (JavaAgent.opts.log_file == null && (v = JavaAgent.GetConfigurationString("ROOKOUT_LOG_FILE")) != null) {
            JavaAgent.opts.log_file = v;
        }
        if (JavaAgent.opts.log_level == null && (v = JavaAgent.GetConfigurationString("ROOKOUT_LOG_LEVEL")) != null) {
            JavaAgent.opts.log_level = v;
        }
        if (JavaAgent.opts.host == null) {
            v = JavaAgent.GetConfigurationString("ROOKOUT_CONTROLLER_HOST");
            if (v != null) {
                JavaAgent.opts.host = v;
            } else {
                v = JavaAgent.GetConfigurationString("ROOKOUT_AGENT_HOST");
                if (v != null) {
                    JavaAgent.opts.host = v;
                }
            }
        }
        if (JavaAgent.opts.port == null) {
            v = JavaAgent.GetConfigurationString("ROOKOUT_CONTROLLER_PORT");
            if (v != null) {
                try {
                    JavaAgent.opts.port = Integer.parseInt(v);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                v = JavaAgent.GetConfigurationString("ROOKOUT_AGENT_PORT");
                if (v != null) {
                    try {
                        JavaAgent.opts.port = Integer.parseInt(v);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (JavaAgent.opts.token == null && (v = JavaAgent.GetConfigurationString("ROOKOUT_TOKEN")) != null) {
            JavaAgent.opts.token = v;
        }
        if (JavaAgent.opts.tags == null) {
            JavaAgent.opts.tags = new String[0];
            v = JavaAgent.GetConfigurationString("ROOKOUT_ROOK_TAGS");
            if (v != null) {
                JavaAgent.opts.tags = v.split(";");
            }
        }
        if (JavaAgent.opts.labels == null) {
            JavaAgent.opts.labels = new HashMap();
            v = JavaAgent.GetConfigurationString("ROOKOUT_LABELS");
            if (v != null) {
                for (String label : v.split(",")) {
                    String[] parts = label.split(":");
                    if (parts.length != 2) continue;
                    String key = parts[0];
                    String value = parts[1];
                    if (key.isEmpty()) continue;
                    JavaAgent.opts.labels.put(key, value);
                }
            }
        }
        if (JavaAgent.opts.throw_errors == null) {
            JavaAgent.opts.throw_errors = false;
        }
    }

    static {
        TRUE_VALUES = Arrays.asList("y", "Y", "yes", "Yes", "YES", "true", "True", "TRUE", "1");
    }
}

