/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.Services.Instrumentation.Augs;
import java.util.HashMap;
import java.util.logging.Level;
import rook.org.objectweb.asm.Type;

public class CallbackDispatcher {
    private static CallbackDispatcher instance;
    private final Augs augs;
    static final String CallbackDescriptor;

    static void CreateCallbackDispatcher(Augs augs) {
        if (null != instance) {
            throw new RuntimeException("Cannot create CallbackDispatcher twice");
        }
        instance = new CallbackDispatcher(augs);
    }

    static void Close() {
        instance = null;
    }

    public void Callback(String fileName, int lineno, HashMap<String, Object> locals, Throwable t) throws Throwable {
        try {
            Augs.AugList augList = this.augs.GetAugs(fileName, lineno);
            Frame frame = new Frame(t, locals);
            frame.stackTrace.setBaseFrameIndex(1);
            if (null != augList) {
                for (Augs.HashedAug aug : augList) {
                    aug.aug.Execute(frame, null);
                }
            } else {
                RookLogger.Instance().severe("Failed to find aug for id: " + fileName + "@" + lineno);
            }
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw e;
            }
            RookLogger.Instance().log(Level.SEVERE, "Error while calling aug", e);
        }
    }

    private CallbackDispatcher(Augs augs) {
        this.augs = augs;
    }

    static {
        CallbackDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class), Type.INT_TYPE, Type.getType(HashMap.class));
    }
}

