/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import java.util.concurrent.atomic.AtomicInteger;

class WarningCache {
    private String[] cache;
    private AtomicInteger nextFreeItem;

    WarningCache(int cacheSize) {
        this.cache = new String[cacheSize];
        this.nextFreeItem = new AtomicInteger(0);
    }

    boolean contains(String elem) {
        for (int i = 0; i < Math.min(this.cache.length, this.nextFreeItem.get()); ++i) {
            if (this.cache[i] == null || !this.cache[i].equals(elem)) continue;
            return true;
        }
        return false;
    }

    boolean isFull() {
        return this.nextFreeItem.get() >= this.cache.length;
    }

    void put(String elem) {
        if (!this.isFull()) {
            int lastValue = this.nextFreeItem.getAndIncrement();
            if (lastValue == this.cache.length) {
                return;
            }
            this.cache[lastValue] = elem;
        }
    }
}

