/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.AgentInfo;
import com.rookout.rook.Com.Output;
import com.rookout.rook.Config;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class Information {
    public String agentId = "";
    public String version = "";
    public String commit = "";
    public String ipAddr = "";
    public String network = "";
    public String hostName = "";
    public String os = "";
    public String osVersion = "";
    public String distro = "";
    public String arch = "";
    public String platform = "";
    public String platformVersion = "";
    public String platformVariant = "";
    public String scmCommit = "";
    public String origin = "";
    public String executable = "";
    public ArrayList<String> commandArguments = new ArrayList();
    public int processId = 0;
    public Map<String, String> labels = new HashMap<String, String>();
    public String[] tags;

    public static Information Collect() {
        Information info = new Information();
        AgentInformation.CollectInto(info);
        return info;
    }

    public static AgentInfo.AgentInformation PackAgentInfo(Information info) {
        AgentInfo.AgentInformation.Builder builder = AgentInfo.AgentInformation.newBuilder();
        builder.setAgentId(info.agentId);
        AgentInfo.VersionInformation.Builder versionInfo = AgentInfo.VersionInformation.newBuilder();
        versionInfo.setVersion(info.version);
        versionInfo.setCommit(info.commit);
        builder.setVersion(versionInfo);
        AgentInfo.NetworkInformation.Builder networkInfo = AgentInfo.NetworkInformation.newBuilder();
        networkInfo.setIpAddr(info.ipAddr);
        networkInfo.setNetwork(info.network);
        builder.setNetwork(networkInfo);
        AgentInfo.SystemInformation.Builder systemInfo = AgentInfo.SystemInformation.newBuilder();
        systemInfo.setHostname(info.hostName);
        systemInfo.setOs(info.os);
        systemInfo.setOsVersion(info.osVersion);
        systemInfo.setDistro(info.distro);
        systemInfo.setArch(info.arch);
        builder.setSystem(systemInfo);
        AgentInfo.PlatformInformation.Builder platformInfo = AgentInfo.PlatformInformation.newBuilder();
        platformInfo.setPlatform(info.platform);
        platformInfo.setVersion(info.platformVersion);
        platformInfo.setVariant(info.platformVariant);
        builder.setPlatform(platformInfo);
        AgentInfo.SCMInformation.Builder scmInfo = AgentInfo.SCMInformation.newBuilder();
        scmInfo.setCommit(info.scmCommit);
        scmInfo.setOrigin(info.origin);
        builder.setScm(scmInfo);
        builder.setExecutable(info.executable);
        builder.addAllCommandArguments(info.commandArguments);
        builder.setProcessId(info.processId);
        builder.putAllLabels(info.labels);
        builder.addAllTags(Arrays.asList(info.tags));
        return builder.build();
    }

    static class AgentInformation {
        AgentInformation() {
        }

        public static void CollectInto(Information info) {
            VersionInformation.CollectInto(info);
            NetworkInformation.CollectInto(info);
            SystemInformation.CollectInto(info);
            PlatformInformation.CollectInto(info);
            SCMInformation.CollectInto(info);
            info.executable = Utils.GetExecutalbePath();
            info.commandArguments = Utils.GetCommandLine();
            String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
            String pid = nameOfRunningVM.substring(0, nameOfRunningVM.indexOf(64));
            info.processId = Integer.parseInt(pid);
        }
    }

    static class PlatformInformation {
        PlatformInformation() {
        }

        public static void CollectInto(Information info) {
            info.platform = "java";
            info.platformVersion = System.getProperty("java.version");
            info.platformVariant = System.getProperty("java.vendor");
        }
    }

    static class VersionInformation {
        VersionInformation() {
        }

        public static void CollectInto(Information info) {
            info.version = Config.Instance().VersionConfiguration$VERSION;
            info.commit = Config.Instance().VersionConfiguration$COMMIT;
        }
    }

    static class SystemInformation {
        SystemInformation() {
        }

        public static void CollectInto(Information info) {
            try {
                info.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed machine information", e);
            }
            info.os = System.getProperty("os.name");
            info.osVersion = System.getProperty("os.version");
            info.distro = "";
            info.arch = "";
        }
    }

    static class NetworkInformation {
        NetworkInformation() {
        }

        public static void CollectInto(Information info) {
            try {
                info.ipAddr = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed machine network", e);
            }
        }
    }

    static class SCMInformation {
        SCMInformation() {
        }

        public static void CollectInto(Information info) {
            info.scmCommit = Config.Instance().GitConfiguration$COMMIT != null ? Config.Instance().GitConfiguration$COMMIT : Output.GetUserSuppliedValue("ROOKOUT_COMMIT");
            info.origin = Config.Instance().GitConfiguration$ORIGIN != null ? Config.Instance().GitConfiguration$ORIGIN : Output.GetUserSuppliedValue("ROOKOUT_REMOTE_ORIGIN");
        }
    }
}

