/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Com;

import com.rookout.rook.AugManager;
import com.rookout.rook.Com.AgentCom;
import com.rookout.rook.Com.Output;
import com.rookout.rook.Com.State;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import com.rookout.rook.protobuf.AgentManagementServiceGrpc;
import com.rookout.rook.protobuf.Rook;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLException;
import rook.io.grpc.ManagedChannel;
import rook.io.grpc.Metadata;
import rook.io.grpc.Status;
import rook.io.grpc.internal.DnsNameResolverProvider;
import rook.io.grpc.netty.GrpcSslContexts;
import rook.io.grpc.netty.NettyChannelBuilder;
import rook.io.grpc.stub.MetadataUtils;
import rook.io.grpc.stub.StreamObserver;
import rook.io.netty.handler.ssl.SslContextBuilder;
import rook.io.netty.handler.ssl.SslProvider;
import rook.org.json.JSONObject;

public class AgentComGrpc
implements AgentCom {
    private AugManager augManager;
    private Output output;
    private String agentHost;
    private int agentPort;
    private String token;
    private Metadata metadata = new Metadata();
    private AgentManagementServiceGrpc.AgentManagementServiceStub client = null;
    private ManagedChannel managedChannel = null;
    private int retries = 0;
    private long successfulConnectionAt = 0L;
    private State state = new State();

    public AgentComGrpc(AugManager augManager, Output output, String agentHost, int agentPort, String token) {
        this.augManager = augManager;
        this.output = output;
        this.agentHost = agentHost;
        this.agentPort = agentPort;
        this.token = token;
        if (null != token) {
            this.metadata.put(Metadata.Key.of("rookout-token", Metadata.ASCII_STRING_MARSHALLER), token);
        }
    }

    @Override
    public void Close() {
        if (this.managedChannel != null) {
            this.output.FlushMessages();
            this.output.StopSendingMessages();
        }
        this.state.set(State.StateValue.CLOSED);
        this.CloseClient();
    }

    @Override
    public void ConnectToAgent() throws Exception {
        this.state.addObserver(new Observer(){
            Timer timer = new Timer("rookout_timer", true);

            @Override
            public void update(Observable o, Object arg) {
                if (State.StateValue.ERROR == AgentComGrpc.this.state.get()) {
                    long delay = 0L;
                    if (AgentComGrpc.this.retries > 0) {
                        Config config = Config.Instance();
                        double backoff = Math.min(config.AgentComConfiguration$BACK_OFF * Math.pow(2.0, AgentComGrpc.this.retries - 1), config.AgentComConfiguration$MAX_SLEEP);
                        delay = (long)(backoff * 1000.0);
                        RookLogger.Instance().fine("Sleeping for- " + delay + "ms");
                    }
                    ++AgentComGrpc.this.retries;
                    this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            AgentComGrpc.this.StartNewConnection();
                        }
                    }, delay);
                } else if (State.StateValue.CONNECTED == AgentComGrpc.this.state.get()) {
                    AgentComGrpc.this.successfulConnectionAt = System.currentTimeMillis();
                    final long MaxSleepMs = (long)(Config.Instance().AgentComConfiguration$MAX_SLEEP * 1000.0);
                    this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (AgentComGrpc.this.state.get() == State.StateValue.CONNECTED && System.currentTimeMillis() > AgentComGrpc.this.successfulConnectionAt + MaxSleepMs) {
                                AgentComGrpc.this.retries = 0;
                            }
                        }
                    }, (long)((double)MaxSleepMs * 1.1));
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        Observer observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                latch.countDown();
            }
        };
        this.state.addObserver(observer);
        this.StartNewConnection();
        if (!latch.await(Config.Instance().AgentCom$GRPC_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
            RookLogger.Instance().warning("Timeout while syncing with agent");
            this.state.set(State.StateValue.ERROR);
        }
        this.state.deleteObserver(observer);
        if (this.state.get() == State.StateValue.ERROR) {
            throw new IOException("Failed to connect to agent. Will keep trying");
        }
        if (this.state.get() == State.StateValue.FAILED) {
            throw new Exceptions.RookInvalidToken(this.token);
        }
    }

    public void SendRookMessages(Rook.RookMessages messages) {
        final CountDownLatch latch = new CountDownLatch(1);
        ((AgentManagementServiceGrpc.AgentManagementServiceStub)this.client.withDeadlineAfter(Config.Instance().AgentCom$SEND_ROOK_MESSAGES_TIMEOUT.intValue(), TimeUnit.SECONDS)).sendMessages(messages, new StreamObserver<Rook.RpcReturnCode>(){

            @Override
            public void onNext(Rook.RpcReturnCode value) {
            }

            @Override
            public void onError(Throwable t) {
                latch.countDown();
                RookLogger.Instance().log(Level.SEVERE, "Failed to send messages", t);
            }

            @Override
            public void onCompleted() {
                latch.countDown();
            }
        });
        try {
            latch.await(Config.Instance().AgentCom$SEND_ROOK_MESSAGES_TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void BuildClient() throws SSLException {
        this.CloseClient();
        boolean secureConnection = false;
        String newHost = this.agentHost;
        try {
            URL url = new URL(this.agentHost);
            newHost = url.getHost();
            secureConnection = url.getProtocol().startsWith("https");
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        RookLogger.Instance().info("Connecting to agent-\t" + newHost);
        NettyChannelBuilder channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress(newHost, this.agentPort).nameResolverFactory(new DnsNameResolverProvider())).keepAliveTime(2L, TimeUnit.MINUTES).keepAliveTimeout(2500L, TimeUnit.MILLISECONDS).keepAliveWithoutCalls(true);
        if (secureConnection) {
            channel.sslContext(GrpcSslContexts.configure(SslContextBuilder.forClient(), SslProvider.OPENSSL).build());
        } else {
            channel.usePlaintext(true);
        }
        this.managedChannel = channel.build();
        this.client = (AgentManagementServiceGrpc.AgentManagementServiceStub)MetadataUtils.attachHeaders(AgentManagementServiceGrpc.newStub(this.managedChannel).withMaxOutboundMessageSize(Config.Instance().AgentCom$MAX_MESSAGE_LENGTH), this.metadata);
    }

    private void StartNewConnection() {
        try {
            this.BuildClient();
        }
        catch (SSLException e) {
            this.state.set(State.StateValue.FAILED);
            return;
        }
        RookLogger.Instance().info("Successfully connected to agent");
        this.client.newRookNotification(this.output.GetRookInfo(), new StreamObserver<Rook.RookCommand>(){

            @Override
            public void onNext(Rook.RookCommand command) {
                switch (command.getCommandType()) {
                    case COMMAND_ADD_AUG: {
                        RookLogger.Instance().info("Got an add aug command");
                        try {
                            AgentComGrpc.this.augManager.AddAug(new JSONObject(command.getAugJson()));
                        }
                        catch (Throwable e) {
                            RookLogger.Instance().log(Level.SEVERE, "Error processing new aug", e);
                        }
                        break;
                    }
                    case COMMAND_REMOVE_AUG: {
                        RookLogger.Instance().info("Got a remove aug command");
                        try {
                            AgentComGrpc.this.augManager.RemoveAug(command.getAugId());
                        }
                        catch (Throwable e) {
                            RookLogger.Instance().log(Level.SEVERE, "Error removing aug", e);
                        }
                        break;
                    }
                    case COMAND_INIT_FINISHED: {
                        RookLogger.Instance().info("Finished initialization");
                        try {
                            AgentComGrpc.this.output.StartSendingMessages();
                        }
                        catch (Throwable e) {
                            RookLogger.Instance().log(Level.SEVERE, "Error initiating output", e);
                        }
                        AgentComGrpc.this.state.set(State.StateValue.CONNECTED);
                        break;
                    }
                    case COMMAND_CLEAR_AUGS: {
                        RookLogger.Instance().info("Got clear augs command");
                        try {
                            AgentComGrpc.this.augManager.ClearAugs();
                        }
                        catch (Throwable e) {
                            RookLogger.Instance().log(Level.SEVERE, "Error clearing augs", e);
                        }
                        break;
                    }
                    case COMMAND_SET_ROOK_ID: {
                        RookLogger.Instance().info("Got set rook_id command- " + command.getRookId());
                        try {
                            AgentComGrpc.this.output.setAgentId(command.getRookId());
                        }
                        catch (Throwable e) {
                            RookLogger.Instance().log(Level.SEVERE, "Error setting id", e);
                        }
                        break;
                    }
                    default: {
                        RookLogger.Instance().severe("Unknown command- " + command.getCommandType());
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                Status status = Status.fromThrowable(t);
                if (status.getDescription().equals("Channel shutdownNow invoked")) {
                    return;
                }
                if (status.getCode() == Status.Code.PERMISSION_DENIED || status.getDescription().equals("GrpcInvalidTokenException")) {
                    AgentComGrpc.this.state.set(State.StateValue.FAILED);
                    return;
                }
                AgentComGrpc.this.output.StopSendingMessages();
                Level level = Level.SEVERE;
                if (AgentComGrpc.this.retries > 0) {
                    level = Level.INFO;
                }
                RookLogger.Instance().log(level, "Error on gRPC connection-", t);
                AgentComGrpc.this.state.set(State.StateValue.ERROR);
            }

            @Override
            public void onCompleted() {
                AgentComGrpc.this.output.StopSendingMessages();
                RookLogger.Instance().log(Level.SEVERE, "onCompleted called!!");
                AgentComGrpc.this.state.set(State.StateValue.ERROR);
            }
        });
    }

    private void CloseClient() {
        if (this.managedChannel != null) {
            this.managedChannel.shutdownNow();
            try {
                this.managedChannel.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.managedChannel = null;
        this.client = null;
    }
}

